/*
 * Decompiled with CFR 0.152.
 */
package hu.montlikadani.tablist.api;

import hu.montlikadani.tablist.TabList;
import hu.montlikadani.tablist.packets.PacketNM;
import hu.montlikadani.tablist.tablist.TabText;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public final class TabListAPI {
    private static boolean isTpsMethodExists;
    private static boolean isPingMethodExists;

    public static TabList getPlugin() {
        return (TabList)JavaPlugin.getPlugin(TabList.class);
    }

    public static void sendTabList(Player p, String header, String footer) {
        if (p != null) {
            PacketNM.NMS_PACKET.sendTabTitle(p, TabText.parseFromText(header).toComponent(), TabText.parseFromText(footer).toComponent());
        }
    }

    public static void sendTabList(String header, String footer) {
        Object head = TabText.parseFromText(header).toComponent();
        Object foot = TabText.parseFromText(footer).toComponent();
        for (Player player2 : Bukkit.getOnlinePlayers()) {
            PacketNM.NMS_PACKET.sendTabTitle(player2, head, foot);
        }
    }

    public static int getPing(Player player2) {
        return isPingMethodExists ? player2.getPing() : PacketNM.NMS_PACKET.playerPing(player2);
    }

    public static double[] getTPS() {
        return isTpsMethodExists ? Bukkit.getServer().getTPS() : PacketNM.NMS_PACKET.serverTps();
    }

    static {
        try {
            Bukkit.getServer().getTPS();
            isTpsMethodExists = true;
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            Player.class.getDeclaredMethod("getPing", new Class[0]);
            isPingMethodExists = true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }
}

