/*
 * Decompiled with CFR 0.152.
 */
package hu.montlikadani.tablist;

import java.util.List;
import java.util.Random;

public final class TextAnimation {
    public final String name;
    private final int time;
    private final String[] texts;
    private Random random;
    private int last;

    public TextAnimation(String name, List<String> texts, int time, boolean randomized) {
        this.name = name;
        this.time = time < 1 ? 150 : time;
        this.texts = texts.toArray(new String[0]);
        if (randomized) {
            this.random = new Random();
        }
    }

    public String next() {
        int index = (int)(System.currentTimeMillis() % (long)(this.texts.length * this.time) / (long)this.time);
        if (this.last != index && this.random != null) {
            for (int i = this.texts.length - 1; i > 0; --i) {
                int randomIndexToSwap = this.random.nextInt(i + 1);
                String temp = this.texts[randomIndexToSwap];
                this.texts[randomIndexToSwap] = this.texts[i];
                this.texts[i] = temp;
            }
            this.last = index;
        }
        return this.texts[index];
    }
}

