/*
 * Decompiled with CFR 0.152.
 */
package hu.montlikadani.tablist;

import hu.montlikadani.tablist.Global;
import hu.montlikadani.tablist.Objects;
import hu.montlikadani.tablist.TextAnimation;
import hu.montlikadani.tablist.api.TabListAPI;
import hu.montlikadani.tablist.commands.Commands;
import hu.montlikadani.tablist.config.CommentedConfig;
import hu.montlikadani.tablist.config.Configuration;
import hu.montlikadani.tablist.config.constantsLoader.ConfigValues;
import hu.montlikadani.tablist.config.constantsLoader.TabConfigValues;
import hu.montlikadani.tablist.lib.bstats.bukkit.Metrics;
import hu.montlikadani.tablist.lib.bstats.charts.SimplePie;
import hu.montlikadani.tablist.listeners.Listeners;
import hu.montlikadani.tablist.listeners.resources.CMIAfkStatus;
import hu.montlikadani.tablist.listeners.resources.EssAfkStatus;
import hu.montlikadani.tablist.listeners.resources.PurpurAfkStatus;
import hu.montlikadani.tablist.packets.PacketNM;
import hu.montlikadani.tablist.tablist.TabManager;
import hu.montlikadani.tablist.tablist.TabToggleBase;
import hu.montlikadani.tablist.tablist.fakeplayers.FakePlayerHandler;
import hu.montlikadani.tablist.tablist.groups.Groups;
import hu.montlikadani.tablist.user.PlayerScore;
import hu.montlikadani.tablist.user.TabListUser;
import hu.montlikadani.tablist.utils.ServerVersion;
import hu.montlikadani.tablist.utils.UpdateDownloader;
import hu.montlikadani.tablist.utils.Util;
import hu.montlikadani.tablist.utils.plugin.PermissionService;
import hu.montlikadani.tablist.utils.scheduler.BukkitScheduler;
import hu.montlikadani.tablist.utils.scheduler.FoliaScheduler;
import hu.montlikadani.tablist.utils.scheduler.TLScheduler;
import hu.montlikadani.tablist.utils.stuff.Complement;
import hu.montlikadani.tablist.utils.stuff.Complement1;
import hu.montlikadani.tablist.utils.stuff.Complement2;
import hu.montlikadani.tablist.utils.variables.Variables;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitWorker;

public final class TabList
extends JavaPlugin {
    private transient PermissionService permissionService;
    private transient Objects objects;
    private transient Variables variables;
    private transient Groups groups;
    private transient Configuration conf;
    private transient TabManager tabManager;
    private transient FakePlayerHandler fakePlayerHandler;
    private transient Complement complement;
    private transient Plugin papi;
    private transient boolean hasPermissionService;
    private transient boolean isFoliaServer;
    private final Set<TextAnimation> animations = new HashSet<TextAnimation>(8);
    private final Set<TabListUser> users = Collections.newSetFromMap(new ConcurrentHashMap());
    private List<Class<?>> packetClasses;
    private boolean printed;

    public void onEnable() {
        long load = System.currentTimeMillis();
        ServerVersion currentVersion = ServerVersion.current();
        if (currentVersion == null) {
            this.getLogger().log(Level.SEVERE, "Your server version does not supported " + this.getServer().getBukkitVersion());
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.verifyServerSoftware();
        this.papi = this.getServer().getPluginManager().getPlugin("PlaceholderAPI");
        this.conf = new Configuration(this);
        this.groups = new Groups(this);
        this.variables = new Variables(this);
        this.tabManager = new TabManager(this);
        this.fakePlayerHandler = new FakePlayerHandler(this);
        try {
            Class.forName("hu.montlikadani.tablist.packets.PacketNM");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (PacketNM.NMS_PACKET == null) {
            this.getLogger().log(Level.SEVERE, "Future versions does not supported at the moment " + this.getServer().getBukkitVersion());
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        TabListAPI.getTPS();
        this.conf.loadFiles();
        this.variables.load();
        this.loadPacketListener();
        if (this.hasPapi()) {
            Util.consolePrint(Level.INFO, (Plugin)this, "Found {0} version: {1}", this.papi.getName(), this.papi.getDescription().getVersion());
        }
        this.hasPermissionService = this.isPluginEnabled("Vault") && (this.permissionService = new PermissionService()).getPermission() != null;
        this.fakePlayerHandler.load();
        this.loadAnimations();
        this.loadListeners();
        this.registerCommands();
        this.groups.load();
        this.getServer().getOnlinePlayers().forEach(this::getOrLoadUser);
        this.tabManager.toggleBase.load(this);
        this.getServer().getOnlinePlayers().forEach(this::updateAll);
        UpdateDownloader.checkFromGithub(this);
        this.beginDataCollection();
        Util.consolePrint(Level.INFO, (Plugin)this, "v{0} on {1} ({2}ms)", this.getDescription().getVersion(), currentVersion.name(), System.currentTimeMillis() - load);
    }

    public void onDisable() {
        if (this.fakePlayerHandler == null) {
            return;
        }
        this.groups.cancelUpdate();
        this.tabManager.cancelTask();
        if (this.objects != null) {
            this.objects.cancelTask();
        }
        if (this.isFoliaServer) {
            this.getServer().getAsyncScheduler().cancelTasks((Plugin)this);
            this.getServer().getGlobalRegionScheduler().cancelTasks((Plugin)this);
        } else {
            this.getServer().getScheduler().cancelTasks((Plugin)this);
            for (BukkitWorker worker : this.getServer().getScheduler().getActiveWorkers()) {
                if (!this.equals(worker.getOwner())) continue;
                worker.getThread().interrupt();
            }
        }
        if (!this.users.isEmpty()) {
            if (this.objects != null) {
                for (Objects.ObjectTypes type : Objects.ObjectTypes.values()) {
                    if (type == Objects.ObjectTypes.NONE) continue;
                    for (TabListUser user : this.users) {
                        this.objects.unregisterObjective(type, user);
                    }
                }
            }
            this.users.forEach(tlu -> {
                tlu.getTabHandler().sendEmptyTab(tlu.getPlayer());
                tlu.setHidden(false);
            });
        }
        this.tabManager.toggleBase.save(this);
        this.fakePlayerHandler.removeAllFakePlayer();
        HandlerList.unregisterAll((Plugin)this);
    }

    public CommentedConfig getConfig() {
        return this.conf.getConfig();
    }

    public void saveConfig() {
        this.getConfig().save();
    }

    private void verifyServerSoftware() {
        try {
            Class.forName("io.papermc.paper.threadedregions.scheduler.RegionScheduler");
            this.isFoliaServer = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            Class.forName("net.kyori.adventure.text.Component");
            Player.class.getDeclaredMethod("displayName", new Class[0]);
            Player.class.getDeclaredMethod("playerListName", new Class[0]);
            this.complement = new Complement2();
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            this.complement = new Complement1();
        }
    }

    private void beginDataCollection() {
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)new File(new File(this.getDataFolder().getParentFile(), "bStats"), "config.yml"));
        if (!config.getBoolean("enabled", true)) {
            return;
        }
        Metrics metrics = new Metrics(this, 1479);
        metrics.addCustomChart(new SimplePie("using_placeholderapi", () -> Boolean.toString(this.hasPapi())));
        if (TabConfigValues.isEnabled()) {
            metrics.addCustomChart(new SimplePie("tab_interval", () -> Integer.toString(TabConfigValues.getUpdateInterval())));
        }
        metrics.addCustomChart(new SimplePie("enable_tablist", () -> Boolean.toString(TabConfigValues.isEnabled())));
        if (ConfigValues.getObjectType() != Objects.ObjectTypes.NONE) {
            metrics.addCustomChart(new SimplePie("object_type", () -> ConfigValues.getObjectType().name().toLowerCase(Locale.ENGLISH)));
        }
        metrics.addCustomChart(new SimplePie("enable_fake_players", () -> Boolean.toString(ConfigValues.isFakePlayers())));
        metrics.addCustomChart(new SimplePie("enable_groups", () -> Boolean.toString(ConfigValues.isPrefixSuffixEnabled())));
    }

    private void registerCommands() {
        Optional.ofNullable(this.getCommand("tablist")).ifPresent(tl -> {
            Commands commands = new Commands(this);
            tl.setExecutor((CommandExecutor)commands);
            tl.setTabCompleter((TabCompleter)commands);
        });
    }

    private void loadPacketListener() {
        if (!ConfigValues.isRemoveGrayColorFromTabInSpec() && !ConfigValues.isPrefixSuffixEnabled()) {
            this.getServer().getOnlinePlayers().forEach(PacketNM.NMS_PACKET::removePlayerChannelListener);
            this.packetClasses = null;
            return;
        }
        this.packetClasses = new ArrayList();
        if (ConfigValues.isPrefixSuffixEnabled()) {
            try {
                this.packetClasses.add(Class.forName("net.minecraft.network.protocol.game.PacketPlayOutScoreboardTeam"));
            }
            catch (ClassNotFoundException ex) {
                try {
                    this.packetClasses.add(Class.forName("net.minecraft.server." + Util.legacyNmsVersion() + ".PacketPlayOutScoreboardTeam"));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        if (ConfigValues.isRemoveGrayColorFromTabInSpec()) {
            try {
                this.packetClasses.add(Class.forName("net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket"));
            }
            catch (ClassNotFoundException e) {
                try {
                    this.packetClasses.add(Class.forName("net.minecraft.network.protocol.game.PacketPlayOutPlayerInfo"));
                }
                catch (ClassNotFoundException ex) {
                    try {
                        this.packetClasses.add(Class.forName("net.minecraft.server." + Util.legacyNmsVersion() + ".PacketPlayOutPlayerInfo"));
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
            }
        }
        if (this.packetClasses.isEmpty()) {
            this.packetClasses = null;
        }
    }

    void loadListeners() {
        HandlerList.unregisterAll((Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new Listeners(this), (Plugin)this);
        if (ConfigValues.isAfkStatusEnabled() || ConfigValues.isHidePlayerFromTabAfk()) {
            if (this.isPluginEnabled("Essentials")) {
                new EssAfkStatus(this);
            }
            if (this.isPluginEnabled("CMI")) {
                this.getServer().getPluginManager().registerEvents((Listener)new CMIAfkStatus(this), (Plugin)this);
            }
            try {
                Class<?> cl = Class.forName("org.purpurmc.purpur.event.PlayerAFKEvent");
                new PurpurAfkStatus(this, cl);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    public void reload() {
        this.tabManager.cancelTask();
        this.printed = false;
        this.users.forEach(user -> user.getTabHandler().sendEmptyTab(user.getPlayer()));
        this.groups.cancelUpdate();
        this.fakePlayerHandler.removeAllFakePlayer();
        this.loadListeners();
        this.conf.loadFiles();
        this.loadAnimations();
        this.loadPacketListener();
        this.variables.load();
        this.fakePlayerHandler.load();
        this.groups.load();
        if (this.objects != null) {
            this.objects.load();
        }
        this.getServer().getOnlinePlayers().forEach(pl -> this.updateAll((Player)pl, true));
    }

    private void loadAnimations() {
        this.animations.clear();
        ConfigurationSection section = this.conf.getAnimCreator().getConfigurationSection("animations");
        if (section == null) {
            return;
        }
        for (String name : section.getKeys(false)) {
            List list = section.getStringList(name + ".texts");
            if (list.isEmpty()) continue;
            list.replaceAll(this.variables::replaceMiscVariables);
            this.animations.add(new TextAnimation(name, list, section.getInt(name + ".interval", 200), section.getBoolean(name + ".random", false)));
        }
    }

    public String makeAnim(String str) {
        if (str.isEmpty()) {
            return str;
        }
        StringBuilder builder = new StringBuilder(str);
        for (int i = 0; i < this.animations.size(); ++i) {
            for (TextAnimation ac : this.animations) {
                Global.replace(builder, "%anim:" + ac.name + "%", ac::next);
            }
        }
        return builder.toString();
    }

    private TabListUser getOrLoadUser(Player player2) {
        return this.getUser(player2.getUniqueId()).orElseGet(() -> {
            TabListUser tlu = new TabListUser(this, player2.getUniqueId());
            if (TabToggleBase.TEMPORAL_PLAYER_CACHE.remove(tlu.getUniqueId())) {
                tlu.setTabVisibility(false);
            }
            this.users.add(tlu);
            return tlu;
        });
    }

    public void updateAll(Player p) {
        this.updateAll(p, false);
    }

    void updateAll(Player player2, boolean reload2) {
        TabListUser user = this.getOrLoadUser(player2);
        if (this.objects == null && ConfigValues.getObjectType() != Objects.ObjectTypes.NONE) {
            this.objects = new Objects(this);
            this.objects.load();
        }
        if (this.objects != null) {
            if (reload2) {
                this.objects.unregisterObjective(Objects.ObjectTypes.PING, user);
                this.objects.unregisterObjective(Objects.ObjectTypes.CUSTOM, user);
                PlayerScore playerScore = user.getPlayerScore(true);
                if (playerScore != null) {
                    playerScore.setLastScore(-1);
                }
            }
            this.objects.load(player2);
        }
        if (ConfigValues.isFakePlayers()) {
            this.fakePlayerHandler.display();
        }
        this.tabManager.load(user);
        if (!reload2) {
            this.groups.startTask();
        }
        if (this.packetClasses != null) {
            PacketNM.NMS_PACKET.addPlayerChannelListener(player2, this.packetClasses);
        }
        if (ConfigValues.isPerWorldPlayerList()) {
            this.newTLScheduler().submitSync(() -> {
                user.setHidden(true);
                if (user.isHidden()) {
                    user.getPlayerList().displayInWorld();
                }
            });
        } else if (user.isHidden()) {
            this.newTLScheduler().submitSync(() -> user.setHidden(false));
        }
    }

    public void onPlayerQuit(Player player2) {
        Iterator<TabListUser> iterator = this.users.iterator();
        UUID playerId = player2.getUniqueId();
        while (iterator.hasNext()) {
            TabListUser user = iterator.next();
            if (!playerId.equals(user.getUniqueId())) continue;
            if (user.isTabVisible()) {
                user.getTabHandler().sendEmptyTab(player2);
            } else {
                TabToggleBase.TEMPORAL_PLAYER_CACHE.add(user.getUniqueId());
            }
            this.groups.removePlayerGroup(user);
            if (this.objects != null && ConfigValues.getObjectType() != Objects.ObjectTypes.NONE) {
                this.objects.unregisterObjective(ConfigValues.getObjectType(), user);
            }
            iterator.remove();
            break;
        }
        PacketNM.NMS_PACKET.removePlayerChannelListener(player2);
    }

    public boolean tpsIsUnderValue() {
        double value = ConfigValues.getTpsObservationValue();
        if (value != -1.0 && TabListAPI.getTPS()[0] <= value) {
            if (!this.printed) {
                Util.consolePrint(Level.INFO, (Plugin)this, "All {0} schedulers has been terminated. (Low tps)", this.getName());
                this.printed = true;
            }
            return true;
        }
        return false;
    }

    public Optional<TabListUser> getUser(Player player2) {
        return player2 == null ? Optional.empty() : this.getUser(player2.getUniqueId());
    }

    public Optional<TabListUser> getUser(UUID uuid) {
        if (uuid != null) {
            for (TabListUser tlp : this.users) {
                if (!uuid.equals(tlp.getUniqueId())) continue;
                return Optional.of(tlp);
            }
        }
        return Optional.empty();
    }

    public TLScheduler newTLScheduler() {
        return this.isFoliaServer ? new FoliaScheduler((Plugin)this) : new BukkitScheduler((Plugin)this);
    }

    public Set<TabListUser> getUsers() {
        return this.users;
    }

    public boolean hasPermissionService() {
        return this.hasPermissionService;
    }

    public boolean hasPapi() {
        return this.papi != null && this.papi.isEnabled();
    }

    public boolean isFoliaServer() {
        return this.isFoliaServer;
    }

    public Variables getPlaceholders() {
        return this.variables;
    }

    public FakePlayerHandler getFakePlayerHandler() {
        return this.fakePlayerHandler;
    }

    public Groups getGroups() {
        return this.groups;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public PermissionService getPermissionService() {
        return this.permissionService;
    }

    public Complement getComplement() {
        return this.complement;
    }

    boolean isPluginEnabled(String name) {
        return this.getServer().getPluginManager().isPluginEnabled(name);
    }
}

