/*
 * Decompiled with CFR 0.152.
 */
package hu.montlikadani.tablist;

import hu.montlikadani.tablist.TabList;
import hu.montlikadani.tablist.api.TabListAPI;
import hu.montlikadani.tablist.config.constantsLoader.ConfigValues;
import hu.montlikadani.tablist.packets.PacketNM;
import hu.montlikadani.tablist.tablist.fakeplayers.IFakePlayer;
import hu.montlikadani.tablist.user.PlayerScore;
import hu.montlikadani.tablist.user.TabListUser;
import hu.montlikadani.tablist.utils.Util;
import hu.montlikadani.tablist.utils.reflection.ComponentParser;
import hu.montlikadani.tablist.utils.scheduler.TLScheduler;
import java.util.Locale;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.ChatColor;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.RenderType;
import org.bukkit.scoreboard.Scoreboard;

public final class Objects {
    private final transient TabList plugin;
    private TLScheduler scheduler;
    private PluginPlaceholders customPlaceholder;
    private Matcher numberEscapeSequence;
    private final transient boolean renderTypeSupported;

    Objects(TabList plugin) {
        boolean rtSupported;
        this.plugin = plugin;
        try {
            Class.forName("org.bukkit.scoreboard.RenderType");
            rtSupported = true;
        }
        catch (ClassNotFoundException ex) {
            rtSupported = false;
        }
        this.renderTypeSupported = rtSupported;
    }

    void load() {
        ObjectTypes type = ConfigValues.getObjectType();
        this.customPlaceholder = null;
        if (type == ObjectTypes.NONE || type == ObjectTypes.HEALTH) {
            this.cancelTask();
            return;
        }
        if (type == ObjectTypes.CUSTOM) {
            for (PluginPlaceholders placeholder : PluginPlaceholders.values()) {
                if (ConfigValues.getCustomObjectSetting().indexOf(placeholder.name) == -1) continue;
                this.customPlaceholder = placeholder;
                break;
            }
        }
    }

    void load(Player player2) {
        ObjectTypes type = ConfigValues.getObjectType();
        if (type == ObjectTypes.HEALTH) {
            this.cancelTask();
            this.registerHealthTab(player2);
        } else {
            this.unregisterHealthObjective(player2);
            if (type != ObjectTypes.NONE) {
                this.startTask();
            } else {
                this.cancelTask();
            }
        }
    }

    private void registerHealthTab(Player pl) {
        String objectName;
        if (ConfigValues.getObjectsDisabledWorlds().contains(pl.getWorld().getName()) || ConfigValues.getHealthObjectRestricted().contains(pl.getName())) {
            this.unregisterHealthObjective(pl);
            return;
        }
        Scoreboard board = pl.getScoreboard();
        if (board.getObjective(objectName = ConfigValues.getObjectType().objectName) != null) {
            return;
        }
        TLScheduler tlsched = this.plugin.newTLScheduler();
        tlsched.submitSync(() -> {
            Objective objective;
            if (this.renderTypeSupported) {
                objective = this.plugin.getComplement().registerNewObjective(board, objectName, "health", objectName, RenderType.HEARTS);
            } else {
                objective = board.registerNewObjective(objectName, "health");
                this.plugin.getComplement().displayName(objective, String.valueOf(ChatColor.RED) + "\u2665");
            }
            objective.setDisplaySlot(DisplaySlot.PLAYER_LIST);
            this.adjustMaxHealth(pl, 1.0);
            pl.setHealth(pl.getHealth() + 1.0);
            tlsched.runDelayed(() -> {
                this.adjustMaxHealth(pl, -1.0);
                pl.setHealth(pl.getHealth() - 1.0);
            }, pl.getLocation(), 2L);
        });
    }

    private void adjustMaxHealth(Player player2, double value) {
        try {
            AttributeInstance maxHealth = player2.getAttribute(Attribute.GENERIC_MAX_HEALTH);
            if (maxHealth != null) {
                maxHealth.setBaseValue(maxHealth.getBaseValue() + value);
            }
        }
        catch (Error err) {
            player2.setMaxHealth(player2.getMaxHealth() + value);
        }
    }

    private void startTask() {
        if (ConfigValues.getObjectRefreshInterval() == 0) {
            this.update();
            return;
        }
        if (!this.isCancelled()) {
            return;
        }
        this.scheduler = this.plugin.newTLScheduler().submitAsync(() -> {
            if (this.plugin.tpsIsUnderValue() || this.plugin.getUsers().isEmpty()) {
                this.cancelTask();
            } else {
                this.update();
            }
        }, 0L, ConfigValues.getObjectRefreshInterval());
    }

    private void update() {
        for (TabListUser user : this.plugin.getUsers()) {
            Player player2;
            PlayerScore playerScore = user.getPlayerScore(true);
            if (playerScore == null || playerScore.getScoreName().isEmpty() || (player2 = user.getPlayer()) == null || ConfigValues.getObjectsDisabledWorlds().contains(player2.getWorld().getName())) continue;
            ObjectTypes type = ConfigValues.getObjectType();
            if (!playerScore.isObjectiveCreated()) {
                Object objectiveInstance = PacketNM.NMS_PACKET.createObjectivePacket(type.objectName, type.chatBaseComponent, ConfigValues.objectiveFormat(), ConfigValues.getObjectiveFormatText());
                PacketNM.NMS_PACKET.sendPacket(player2, PacketNM.NMS_PACKET.scoreboardObjectivePacket(objectiveInstance, 0));
                PacketNM.NMS_PACKET.sendPacket(player2, PacketNM.NMS_PACKET.scoreboardDisplayObjectivePacket(objectiveInstance, 0));
                if (type == ObjectTypes.PING) {
                    for (IFakePlayer fakePlayer : this.plugin.getFakePlayerHandler().fakePlayers) {
                        int pingLatency = fakePlayer.getPingLatency();
                        if (pingLatency <= 0) continue;
                        PacketNM.NMS_PACKET.sendPacket(player2, PacketNM.NMS_PACKET.changeScoreboardScorePacket(type.objectName, fakePlayer.getName(), pingLatency));
                    }
                }
                playerScore.setObjectiveCreated();
            }
            int lastScore = 0;
            if (type == ObjectTypes.PING) {
                lastScore = TabListAPI.getPing(player2);
            } else if (type == ObjectTypes.CUSTOM) {
                lastScore = this.getValue(player2);
            }
            if (lastScore == playerScore.getLastScore()) continue;
            playerScore.setLastScore(lastScore);
            for (Player pl : this.plugin.getServer().getOnlinePlayers()) {
                PacketNM.NMS_PACKET.sendPacket(pl, PacketNM.NMS_PACKET.changeScoreboardScorePacket(type.objectName, playerScore.getScoreName(), lastScore));
            }
        }
    }

    private int getValue(Player player2) {
        if (this.customPlaceholder == null) {
            return this.parsePapi(player2);
        }
        switch (this.customPlaceholder.ordinal()) {
            case 1: {
                return player2.getExpToLevel();
            }
            case 2: {
                return player2.getLevel();
            }
            case 0: {
                return TabListAPI.getPing(player2);
            }
            case 3: {
                return player2.getLocation().getBlock().getLightLevel();
            }
        }
        return this.parsePapi(player2);
    }

    private int parsePapi(Player player2) {
        if (this.plugin.hasPapi()) {
            String value = ConfigValues.getCustomObjectSetting();
            if (this.numberEscapeSequence == null) {
                this.numberEscapeSequence = Pattern.compile("[^\\d]").matcher("");
            }
            try {
                return Integer.parseInt(this.numberEscapeSequence.reset(PlaceholderAPI.setPlaceholders((Player)player2, (String)value)).replaceAll(""));
            }
            catch (NumberFormatException e) {
                Util.consolePrint(Level.INFO, (Plugin)this.plugin, "Invalid custom objective with {0} value", value);
            }
        }
        return 0;
    }

    public void cancelTask() {
        if (!this.isCancelled()) {
            this.scheduler.cancelTask();
            this.scheduler = null;
        }
    }

    public boolean isCancelled() {
        return this.scheduler == null;
    }

    public void unregisterHealthObjective(Player player2) {
        Objective obj = player2.getScoreboard().getObjective(ObjectTypes.HEALTH.objectName);
        if (obj != null) {
            obj.unregister();
        }
    }

    public void unregisterObjective(ObjectTypes type, TabListUser source) {
        PlayerScore playerScore = source.getPlayerScore();
        if (playerScore == null) {
            return;
        }
        Player player2 = source.getPlayer();
        if (player2 == null) {
            return;
        }
        if (type == ObjectTypes.HEALTH) {
            this.unregisterHealthObjective(player2);
            return;
        }
        if (playerScore.isObjectiveCreated()) {
            playerScore.setObjectiveCreated();
        }
        PacketNM.NMS_PACKET.sendPacket(player2, PacketNM.NMS_PACKET.removeScoreboardScorePacket(type.objectName, playerScore.getScoreName(), 0));
        PacketNM.NMS_PACKET.sendPacket(player2, PacketNM.NMS_PACKET.scoreboardObjectivePacket(PacketNM.NMS_PACKET.createScoreboardHealthObjectivePacket(type.objectName, type.chatBaseComponent), 1));
    }

    public static enum ObjectTypes {
        HEALTH("showhealth", false),
        PING("PingTab", true),
        CUSTOM("customObj", true),
        NONE("", false);

        public final String objectName;
        private Object chatBaseComponent;

        private ObjectTypes(String objectName, boolean needComponent) {
            if (needComponent) {
                this.chatBaseComponent = ComponentParser.asComponent(objectName);
            }
            this.objectName = objectName;
        }
    }

    private static enum PluginPlaceholders {
        PING,
        EXP_TO_LEVEL,
        LEVEL,
        LIGHT_LEVEL;

        final String name = "%" + this.name().replace('_', '-').toLowerCase(Locale.ENGLISH) + "%";
    }
}

