/*
 * Decompiled with CFR 0.152.
 */
package hu.montlikadani.tablist;

import java.util.function.Supplier;

public final class Global {
    private Global() {
    }

    public static String replaceToUnicodeSymbol(String s) {
        if (s.indexOf(60) == -1) {
            return s;
        }
        int i = -1;
        for (String symbol : new String[]{"\u2022", "\u27a4", "\u2122", "\u2191", "\u2192", "\u2193", "\u221e", "\u2591", "\u25b2", "\u25b6", "\u25c0", "\u25cf", "\u2605", "\u2606", "\u2610", "\u2611", "\u2620", "\u2622", "\u2623", "\u2639", "\u263a", "\u2713", "\u2714", "\u2718", "\u271a", "\u213b", "\u2720", "\u2721", "\u2726", "\u2727", "\u2729", "\u272a", "\u272e", "\u272f", "\u32e1", "\u275d", "\u275e", "\u30c4", "\u2669", "\u266a", "\u266b", "\u266c", "\u266d", "\u266e", "\u266f", "\u00b6", "\u00a9", "\u00ae", "\u23ce", "\u21e7", "\u21ea", "\u1d34\u1d30", "\u2612", "\u2660", "\u2663", "\u263b", "\u2593", "\u27be", "\u2794", "\u27b3", "\u27a7", "\u300a", "\u300b", "\ufe3e", "\ufe3d", "\u2603", "\u00b9", "\u00b2", "\u00b3", "\u2248", "\u2120", "\u2665", "\u272c", "\u2194", "\u00ab", "\u00bb", "\u2600", "\u2666", "\u20bd", "\u260e", "\u2602", "\u2190", "\u2196", "\u2197", "\u2198", "\u2199", "\u27b2", "\u2710", "\u270e", "\u270f", "\u2706", "\u25c4", "\u263c", "\u25ba", "\u2195", "\u25bc", "\u2460", "\u2461", "\u2462", "\u2463", "\u2464", "\u2465", "\u2466", "\u2467", "\u2468", "\u2469", "\u246a", "\u246b", "\u246c", "\u246d", "\u246e", "\u246f", "\u2470", "\u2471", "\u2472", "\u2473", "\u2668", "\u2711", "\u2716", "\u2730", "\u2736", "\u2557", "\u2563", "\u25d9", "\u25cb", "\u2560", "\u2524", "\u2551", "\u255d", "\u2302", "\u2510", "\u2749", "\u2332", "\u00bd", "\u00bc", "\u00be", "\u2153", "\u2154", "\u2116", "\u2020", "\u2021", "\u00b5", "\u00a2", "\u00a3", "\u2205", "\u2264", "\u2265", "\u2260", "\u2227", "\u2228", "\u2229", "\u222a", "\u2208", "\u2200", "\u2203", "\u2204", "\u2211", "\u220f", "\u21ba", "\u21bb", "\u03a9"}) {
            s = s.replace("<" + Integer.toString(++i) + ">", symbol);
        }
        return s;
    }

    public static void replace(StringBuilder builder, String search, Supplier<String> replacement) {
        int index = builder.indexOf(search);
        if (index == -1) {
            return;
        }
        int searchLength = search.length();
        while ((index = builder.replace(index, index + searchLength, replacement.get()).indexOf(search, 0)) != -1) {
        }
    }

    public static String replace(String text, String search, Supplier<String> replacement) {
        StringBuilder stringBuilder;
        int index = text.indexOf(search);
        if (index == -1) {
            return text;
        }
        StringBuilder builder = new StringBuilder(text);
        int searchLength = search.length();
        int replacementLength = replacement.get().length();
        do {
            stringBuilder = builder.replace(index, index + searchLength, replacement.get());
            index += replacementLength;
        } while ((index = stringBuilder.indexOf(search, index)) != -1);
        return builder.toString();
    }

    public static String replaceFrom(String text, int start, String search, String replacement, int max) {
        int index;
        int n = index = start == 0 ? text.indexOf(search) : text.indexOf(search, start);
        if (index == -1) {
            return text;
        }
        StringBuilder builder = new StringBuilder(text);
        while (index != -1) {
            builder.replace(index, index + 1, replacement);
            if (--max <= 0) {
                return builder.toString();
            }
            index = builder.indexOf(search, start);
        }
        return builder.toString();
    }
}

