/*
 * Decompiled with CFR 0.152.
 */
package org.skills.utils.xseries.reflection.jvm;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.skills.utils.xseries.reflection.ReflectiveHandle;
import org.skills.utils.xseries.reflection.jvm.MemberHandle;
import org.skills.utils.xseries.reflection.jvm.classes.ClassHandle;
import org.skills.utils.xseries.reflection.parser.ReflectionParser;

public class ConstructorMemberHandle
extends MemberHandle {
    protected Class<?>[] parameterTypes = new Class[0];

    public ConstructorMemberHandle(ClassHandle classHandle) {
        super(classHandle);
    }

    public ConstructorMemberHandle parameters(Class<?> ... classArray) {
        this.parameterTypes = classArray;
        return this;
    }

    public ConstructorMemberHandle parameters(ClassHandle ... classHandleArray) {
        this.parameterTypes = (Class[])Arrays.stream(classHandleArray).map(ReflectiveHandle::unreflect).toArray(Class[]::new);
        return this;
    }

    @Override
    public MethodHandle reflect() {
        if (this.isFinal) {
            throw new UnsupportedOperationException("Constructor cannot be final: " + this);
        }
        if (this.makeAccessible) {
            return this.clazz.getNamespace().getLookup().unreflectConstructor((Constructor<?>)this.reflectJvm());
        }
        return this.clazz.getNamespace().getLookup().findConstructor((Class)this.clazz.unreflect(), MethodType.methodType(Void.TYPE, this.parameterTypes));
    }

    @Override
    public ConstructorMemberHandle signature(String string) {
        return new ReflectionParser(string).imports(this.clazz.getNamespace()).parseConstructor(this);
    }

    public Constructor<?> reflectJvm() {
        return this.handleAccessible(((Class)this.clazz.unreflect()).getDeclaredConstructor(this.parameterTypes));
    }

    public String toString() {
        String string = this.getClass().getSimpleName() + '{';
        if (this.makeAccessible) {
            string = string + "protected/private ";
        }
        string = string + this.clazz.toString() + ' ';
        string = string + '(' + Arrays.stream(this.parameterTypes).map(Class::getSimpleName).collect(Collectors.joining(", ")) + ')';
        return string + '}';
    }
}

