/*
 * Decompiled with CFR 0.152.
 */
package org.skills.utils.xseries.reflection;

import javax.annotation.Nonnull;
import org.jetbrains.annotations.Nullable;
import org.skills.utils.xseries.reflection.XReflection;

public interface ReflectiveHandle<T> {
    default public boolean exists() {
        try {
            this.reflect();
            return true;
        }
        catch (ReflectiveOperationException ignored) {
            return false;
        }
    }

    @Nullable
    default public ReflectiveOperationException catchError() {
        try {
            this.reflect();
            return null;
        }
        catch (ReflectiveOperationException ex) {
            return ex;
        }
    }

    @Nonnull
    default public T unreflect() {
        try {
            return this.reflect();
        }
        catch (ReflectiveOperationException e) {
            throw XReflection.throwCheckedException(e);
        }
    }

    @Nullable
    default public T reflectOrNull() {
        try {
            return this.reflect();
        }
        catch (ReflectiveOperationException ignored) {
            return null;
        }
    }

    @Nonnull
    public T reflect() throws ReflectiveOperationException;
}

