/*
 * Decompiled with CFR 0.152.
 */
package org.skills.utils.xseries.profiles.builder;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.skills.utils.xseries.profiles.ProfilesCore;
import org.skills.utils.xseries.profiles.builder.ProfileFallback;
import org.skills.utils.xseries.profiles.builder.XSkull;
import org.skills.utils.xseries.profiles.exceptions.ProfileChangeException;
import org.skills.utils.xseries.profiles.exceptions.ProfileException;
import org.skills.utils.xseries.profiles.mojang.PlayerProfileFetcherThread;
import org.skills.utils.xseries.profiles.mojang.ProfileRequestConfiguration;
import org.skills.utils.xseries.profiles.objects.ProfileContainer;
import org.skills.utils.xseries.profiles.objects.Profileable;

public final class ProfileInstruction<T>
implements Profileable {
    private final ProfileContainer<T> profileContainer;
    private Profileable profileable;
    private final List<Profileable> fallbacks = new ArrayList<Profileable>();
    private Consumer<ProfileFallback<T>> onFallback;
    private ProfileRequestConfiguration profileRequestConfiguration;
    private boolean lenient = false;

    protected ProfileInstruction(ProfileContainer<T> profileContainer) {
        this.profileContainer = profileContainer;
    }

    public T removeProfile() {
        this.profileContainer.setProfile(null);
        return this.profileContainer.getObject();
    }

    @ApiStatus.Experimental
    public ProfileInstruction<T> profileRequestConfiguration(ProfileRequestConfiguration profileRequestConfiguration) {
        this.profileRequestConfiguration = profileRequestConfiguration;
        return this;
    }

    public ProfileInstruction<T> lenient() {
        this.lenient = true;
        return this;
    }

    @Override
    public GameProfile getProfile() {
        return this.profileContainer.getProfile();
    }

    public String getProfileString() {
        return this.profileContainer.getProfileValue();
    }

    public ProfileInstruction<T> profile(Profileable profileable) {
        this.profileable = profileable;
        return this;
    }

    public ProfileInstruction<T> fallback(Profileable ... profileableArray) {
        this.fallbacks.addAll(Arrays.asList(profileableArray));
        return this;
    }

    public ProfileInstruction<T> onFallback(Consumer<ProfileFallback<T>> consumer) {
        this.onFallback = consumer;
        return this;
    }

    public ProfileInstruction<T> onFallback(Runnable runnable) {
        this.onFallback = profileFallback -> runnable.run();
        return this;
    }

    public T apply() {
        Objects.requireNonNull(this.profileable, "No profile was set");
        Throwable throwable = null;
        ArrayList<Profileable> arrayList = new ArrayList<Profileable>(2 + this.fallbacks.size());
        arrayList.add(this.profileable);
        arrayList.addAll(this.fallbacks);
        if (this.lenient) {
            arrayList.add(XSkull.getDefaultProfile());
        }
        boolean bl = false;
        boolean bl2 = false;
        for (Profileable object : arrayList) {
            try {
                this.profileContainer.setProfile(object.getDisposableProfile());
                bl = true;
                break;
            }
            catch (ProfileException profileException) {
                if (throwable == null) {
                    throwable = new ProfileChangeException("Could not set the profile for " + this.profileContainer);
                }
                throwable.addSuppressed(profileException);
                bl2 = true;
            }
        }
        if (throwable != null) {
            if (bl || this.lenient) {
                ProfilesCore.debug("apply() silenced exception {}", throwable);
            } else {
                throw throwable;
            }
        }
        Iterator<Object> iterator = this.profileContainer.getObject();
        if (bl2 && this.onFallback != null) {
            ProfileFallback profileFallback = new ProfileFallback(this, iterator, (ProfileChangeException)throwable);
            this.onFallback.accept(profileFallback);
            iterator = profileFallback.getObject();
        }
        return (T)iterator;
    }

    public CompletableFuture<T> applyAsync() {
        return CompletableFuture.supplyAsync(this::apply, PlayerProfileFetcherThread.EXECUTOR);
    }
}

