/*
 * Decompiled with CFR 0.152.
 */
package org.skills.utils.versionsupport;

import java.awt.Color;
import java.util.Collection;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.Block;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.skills.utils.xseries.particles.ParticleDisplay;
import org.skills.utils.xseries.particles.XParticle;

public class VersionSupportFuture {
    private static final UUID ATTRIBUTE_MODIFIER_ID = UUID.randomUUID();
    private static final String ATTRIBUTE_MODIFIER_NAME = "SkillsPro Class Max HP";

    public static void spawnColouredDust(Location location) {
        VersionSupportFuture.spawnColouredDust(location, Color.CYAN);
    }

    public static void spawnColouredDust(Location location, Color color) {
        ParticleDisplay.of(XParticle.DUST).withLocation(location).withColor(color, 2.0f).spawn();
    }

    public static boolean isPassenger(Entity entity, Entity entity2) {
        return entity.getPassengers().contains(entity2);
    }

    public static double getMaxHealth(LivingEntity livingEntity) {
        return livingEntity.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue();
    }

    private static AttributeModifier getAttrMod(double d) {
        return new AttributeModifier(ATTRIBUTE_MODIFIER_ID, ATTRIBUTE_MODIFIER_NAME, d, AttributeModifier.Operation.ADD_NUMBER);
    }

    private static void removeAttrMod(Collection<AttributeModifier> collection) {
        collection.removeIf(attributeModifier -> attributeModifier.getUniqueId() == ATTRIBUTE_MODIFIER_ID);
    }

    public static void setMaxHealth(LivingEntity livingEntity, double d) {
        AttributeInstance attributeInstance = livingEntity.getAttribute(Attribute.GENERIC_MAX_HEALTH);
        attributeInstance.setBaseValue(d);
    }

    public static boolean isCropFullyGrown(Block block) {
        BlockData blockData = block.getBlockData();
        if (blockData instanceof Ageable) {
            Ageable ageable = (Ageable)blockData;
            return ageable.getAge() == ageable.getMaximumAge();
        }
        return false;
    }
}

