/*
 * Decompiled with CFR 0.152.
 */
package org.skills.utils.nbt;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.skills.utils.nbt.NBTType;
import org.skills.utils.xseries.XMaterial;
import org.skills.utils.xseries.reflection.XReflection;

public final class NBTWrappers {
    private NBTWrappers() {
    }

    private static Class<?> getNBTClass(String string) {
        return XReflection.getNMSClass("nbt", string);
    }

    private static Field getDeclaredField(Class<?> clazz, String ... stringArray) {
        int n = 0;
        for (String string : stringArray) {
            ++n;
            try {
                return clazz.getDeclaredField(string);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                if (n != stringArray.length) continue;
                noSuchFieldException.printStackTrace();
            }
        }
        return null;
    }

    public static final class NBTTagFloat
    extends NBTNumber<Float> {
        private static final MethodHandle CONSTRUCTOR;
        private static final MethodHandle NBT_DATA;

        public NBTTagFloat(float f) {
            super(Float.valueOf(f));
        }

        public static NBTTagFloat fromNBT(Object object) {
            try {
                return new NBTTagFloat(NBT_DATA.invoke(object));
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }

        @Override
        public double getAsDouble() {
            return ((Float)this.value).floatValue();
        }

        @Override
        public float getAsFloat() {
            return ((Float)this.value).floatValue();
        }

        @Override
        public Object toNBT() {
            try {
                return CONSTRUCTOR.invoke(this.getAsFloat());
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }

        public String toString() {
            return "NBTTagFloat{" + this.value + '}';
        }

        static {
            Class clazz = NBTWrappers.getNBTClass("NBTTagFloat");
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            MethodHandle methodHandle = null;
            MethodHandle methodHandle2 = null;
            try {
                methodHandle = XMaterial.supports(15) ? lookup.findStatic(clazz, "a", MethodType.methodType(clazz, Float.TYPE)) : lookup.findConstructor(clazz, MethodType.methodType(Void.TYPE, Float.TYPE));
                Field field = NBTWrappers.getDeclaredField(clazz, new String[]{"w", "data"});
                field.setAccessible(true);
                methodHandle2 = lookup.unreflectGetter(field);
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                reflectiveOperationException.printStackTrace();
            }
            CONSTRUCTOR = methodHandle;
            NBT_DATA = methodHandle2;
        }
    }

    public static final class NBTTagLong
    extends NBTNumber<Long> {
        private static final MethodHandle CONSTRUCTOR;
        private static final MethodHandle NBT_DATA;

        public NBTTagLong(long l) {
            super(l);
        }

        public static NBTTagLong fromNBT(Object object) {
            try {
                return new NBTTagLong(NBT_DATA.invoke(object));
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }

        @Override
        public double getAsDouble() {
            return ((Long)this.value).longValue();
        }

        @Override
        public long getAsLong() {
            return (Long)this.value;
        }

        @Override
        public Object toNBT() {
            try {
                return CONSTRUCTOR.invoke(this.getAsLong());
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }

        public String toString() {
            return "NBTTagLong{" + this.value + '}';
        }

        static {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            Class clazz = NBTWrappers.getNBTClass("NBTTagLong");
            MethodHandle methodHandle = null;
            MethodHandle methodHandle2 = null;
            try {
                methodHandle = XMaterial.supports(15) ? lookup.findStatic(clazz, "a", MethodType.methodType(clazz, Long.TYPE)) : lookup.findConstructor(clazz, MethodType.methodType(Void.TYPE, Long.TYPE));
                Field field = NBTWrappers.getDeclaredField(clazz, new String[]{"c", "data"});
                field.setAccessible(true);
                methodHandle2 = lookup.unreflectGetter(field);
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                reflectiveOperationException.printStackTrace();
            }
            CONSTRUCTOR = methodHandle;
            NBT_DATA = methodHandle2;
        }
    }

    public static final class NBTTagShort
    extends NBTNumber<Short> {
        private static final MethodHandle CONSTRUCTOR;
        private static final MethodHandle NBT_DATA;

        public NBTTagShort(short s2) {
            super(s2);
        }

        public static NBTTagShort fromNBT(Object object) {
            try {
                return new NBTTagShort(NBT_DATA.invoke(object));
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }

        @Override
        public short getAsShort() {
            return (Short)this.value;
        }

        @Override
        public double getAsDouble() {
            return ((Short)this.value).shortValue();
        }

        @Override
        public Object toNBT() {
            try {
                return CONSTRUCTOR.invoke(this.getAsShort());
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }

        public String toString() {
            return "NBTTagShort{" + this.value + '}';
        }

        static {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            Class clazz = NBTWrappers.getNBTClass("NBTTagShort");
            MethodHandle methodHandle = null;
            MethodHandle methodHandle2 = null;
            try {
                methodHandle = XMaterial.supports(15) ? lookup.findStatic(clazz, "a", MethodType.methodType(clazz, Short.TYPE)) : lookup.findConstructor(clazz, MethodType.methodType(Void.TYPE, Short.TYPE));
                Field field = NBTWrappers.getDeclaredField(clazz, new String[]{"c", "data"});
                field.setAccessible(true);
                methodHandle2 = lookup.unreflectGetter(field);
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                reflectiveOperationException.printStackTrace();
            }
            CONSTRUCTOR = methodHandle;
            NBT_DATA = methodHandle2;
        }
    }

    public static final class NBTTagByteArray
    extends NBTArray<byte[]> {
        private static final MethodHandle CONSTRUCTOR;
        private static final MethodHandle NBT_DATA;

        public NBTTagByteArray(byte[] byArray) {
            super(byArray);
        }

        public static NBTTagByteArray fromNBT(Object object) {
            try {
                return object == null ? new NBTTagByteArray(new byte[0]) : new NBTTagByteArray(NBT_DATA.invoke(object));
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }

        @Override
        public Object toNBT() {
            try {
                return CONSTRUCTOR.invoke((byte[])this.value);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }

        public String toString() {
            return "NBTTagByteArray{" + Arrays.toString((byte[])this.value) + '}';
        }

        static {
            Class clazz = NBTWrappers.getNBTClass("NBTTagByteArray");
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            MethodHandle methodHandle = null;
            MethodHandle methodHandle2 = null;
            try {
                methodHandle = lookup.findConstructor(clazz, MethodType.methodType(Void.TYPE, byte[].class));
                Field field = NBTWrappers.getDeclaredField(clazz, new String[]{"c", "data"});
                field.setAccessible(true);
                methodHandle2 = lookup.unreflectGetter(field);
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                reflectiveOperationException.printStackTrace();
            }
            CONSTRUCTOR = methodHandle;
            NBT_DATA = methodHandle2;
        }
    }

    public static final class NBTTagByte
    extends NBTNumber<Byte> {
        private static final MethodHandle CONSTRUCTOR;
        private static final MethodHandle NBT_DATA;

        public NBTTagByte(byte by) {
            super(by);
        }

        public static NBTBase<Byte> fromNBT(Object object) {
            try {
                return new NBTTagByte(NBT_DATA.invoke(object));
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }

        @Override
        public double getAsDouble() {
            return ((Byte)this.value).byteValue();
        }

        @Override
        public Object toNBT() {
            try {
                return CONSTRUCTOR.invoke(this.getAsByte());
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }

        public String toString() {
            return "NBTTagByte{" + this.value + '}';
        }

        static {
            Class clazz = NBTWrappers.getNBTClass("NBTTagByte");
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            MethodHandle methodHandle = null;
            MethodHandle methodHandle2 = null;
            try {
                methodHandle = XMaterial.supports(15) ? lookup.findStatic(clazz, "a", MethodType.methodType(clazz, Byte.TYPE)) : lookup.findConstructor(clazz, MethodType.methodType(Void.TYPE, Byte.TYPE));
                Field field = NBTWrappers.getDeclaredField(clazz, new String[]{"x", "data"});
                field.setAccessible(true);
                methodHandle2 = lookup.unreflectGetter(field);
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                reflectiveOperationException.printStackTrace();
            }
            CONSTRUCTOR = methodHandle;
            NBT_DATA = methodHandle2;
        }
    }

    public static final class NBTTagInt
    extends NBTNumber<Integer> {
        private static final MethodHandle CONSTRUCTOR;
        private static final MethodHandle NBT_DATA;

        public NBTTagInt(int n) {
            super(n);
        }

        public static NBTTagInt fromNBT(Object object) {
            try {
                return new NBTTagInt(NBT_DATA.invoke(object));
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }

        @Override
        public double getAsDouble() {
            return ((Integer)this.value).intValue();
        }

        @Override
        public Object toNBT() {
            try {
                return CONSTRUCTOR.invoke((Integer)this.value);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }

        public String toString() {
            return "NBTTagInt{" + this.value + '}';
        }

        static {
            Class clazz = NBTWrappers.getNBTClass("NBTTagInt");
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            MethodHandle methodHandle = null;
            MethodHandle methodHandle2 = null;
            try {
                methodHandle = XMaterial.supports(15) ? lookup.findStatic(clazz, "a", MethodType.methodType(clazz, Integer.TYPE)) : lookup.findConstructor(clazz, MethodType.methodType(Void.TYPE, Integer.TYPE));
                Field field = NBTWrappers.getDeclaredField(clazz, new String[]{"c", "data"});
                field.setAccessible(true);
                methodHandle2 = lookup.unreflectGetter(field);
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                reflectiveOperationException.printStackTrace();
            }
            CONSTRUCTOR = methodHandle;
            NBT_DATA = methodHandle2;
        }
    }

    public static final class NBTTagDouble
    extends NBTNumber<Double> {
        private static final MethodHandle CONSTRUCTOR;
        private static final MethodHandle NBT_DATA;

        public NBTTagDouble(double d) {
            super(d);
        }

        public static NBTTagDouble fromNBT(Object object) {
            try {
                return new NBTTagDouble(NBT_DATA.invoke(object));
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }

        @Override
        public Object toNBT() {
            try {
                return CONSTRUCTOR.invoke(this.getAsDouble());
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }

        public String toString() {
            return "NBTTagDouble{" + this.value + '}';
        }

        @Override
        public double getAsDouble() {
            return (Double)this.value;
        }

        static {
            Class clazz = NBTWrappers.getNBTClass("NBTTagDouble");
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            MethodHandle methodHandle = null;
            MethodHandle methodHandle2 = null;
            try {
                methodHandle = XMaterial.supports(15) ? lookup.findStatic(clazz, "a", MethodType.methodType(clazz, Double.TYPE)) : lookup.findConstructor(clazz, MethodType.methodType(Void.TYPE, Double.TYPE));
                Field field = NBTWrappers.getDeclaredField(clazz, new String[]{"w", "data"});
                field.setAccessible(true);
                methodHandle2 = lookup.unreflectGetter(field);
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                reflectiveOperationException.printStackTrace();
            }
            CONSTRUCTOR = methodHandle;
            NBT_DATA = methodHandle2;
        }
    }

    public static abstract class NBTNumber<T extends Number>
    extends NBTBase<T> {
        public NBTNumber(T t) {
            super(t);
        }

        public int getAsInt() {
            return (int)Math.floor(this.getAsDouble());
        }

        public long getAsLong() {
            return (long)Math.floor(this.getAsDouble());
        }

        public abstract double getAsDouble();

        public float getAsFloat() {
            return (float)this.getAsDouble();
        }

        public byte getAsByte() {
            return (byte)(this.getAsInt() & 0xFF);
        }

        public short getAsShort() {
            return (short)(this.getAsInt() & 0xFFFF);
        }
    }

    public static abstract class NBTArray<T>
    extends NBTBase<T> {
        public NBTArray(T t) {
            super(t);
        }
    }

    public static final class NBTTagList<T>
    extends NBTBase<List<NBTBase<T>>> {
        private static final MethodHandle CONSTRUCTOR;
        private static final MethodHandle GET_DATA;
        private static final MethodHandle SET_DATA;
        private static final MethodHandle GET_TYPE_ID;

        public NBTTagList(List<NBTBase<T>> list) {
            super(list);
        }

        public NBTTagList() {
            super(new ArrayList());
        }

        public static NBTTagList<?> fromNBT(Object object) {
            List list;
            try {
                list = GET_DATA.invoke(object);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return new NBTTagList();
            }
            ArrayList arrayList = new ArrayList(list.size());
            for (Object e : list) {
                arrayList.add(NBTBase.fromNBT(e));
            }
            return new NBTTagList(arrayList);
        }

        public boolean add(NBTBase<T> nBTBase) {
            ((List)this.value).add(nBTBase);
            return true;
        }

        public boolean isType(NBTBase<?> nBTBase) {
            return ((List)this.value).isEmpty() || ((NBTBase)((List)this.value).get(0)).getClass().isInstance(nBTBase);
        }

        @Override
        public Object toNBT() {
            try {
                ArrayList<Object> arrayList = new ArrayList<Object>(((List)this.value).size());
                for (NBTBase nBTBase : (List)this.value) {
                    arrayList.add(nBTBase.toNBT());
                }
                if (XMaterial.supports(15)) {
                    byte by = arrayList.isEmpty() ? (byte)0 : GET_TYPE_ID.invoke(arrayList.get(0));
                    return CONSTRUCTOR.invoke(arrayList, by);
                }
                Object object = CONSTRUCTOR.invoke();
                SET_DATA.invoke(object, arrayList);
                return object;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }

        public String toString() {
            return "NBTTagList{" + Arrays.toString(((List)this.value).toArray()) + '}';
        }

        static {
            Class clazz = NBTWrappers.getNBTClass("NBTTagList");
            Class clazz2 = NBTWrappers.getNBTClass("NBTBase");
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            MethodHandle methodHandle = null;
            MethodHandle methodHandle2 = null;
            MethodHandle methodHandle3 = null;
            MethodHandle methodHandle4 = null;
            try {
                Field field = NBTWrappers.getDeclaredField(clazz, new String[]{"c", "list"});
                field.setAccessible(true);
                methodHandle2 = lookup.unreflectGetter(field);
                if (XMaterial.supports(15)) {
                    Constructor constructor = clazz.getDeclaredConstructor(List.class, Byte.TYPE);
                    constructor.setAccessible(true);
                    methodHandle = lookup.unreflectConstructor(constructor);
                } else {
                    methodHandle = lookup.findConstructor(clazz, MethodType.methodType(Void.TYPE));
                    methodHandle3 = lookup.unreflectSetter(field);
                }
                methodHandle4 = lookup.findVirtual(clazz2, XReflection.v(19, "b").v(18, "a").orElse("getTypeId"), MethodType.methodType(Byte.TYPE));
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                reflectiveOperationException.printStackTrace();
            }
            CONSTRUCTOR = methodHandle;
            GET_DATA = methodHandle2;
            SET_DATA = methodHandle3;
            GET_TYPE_ID = methodHandle4;
        }
    }

    public static final class NBTTagIntArray
    extends NBTArray<int[]> {
        private static final MethodHandle CONSTRUCTOR;
        private static final MethodHandle NBT_DATA;

        public NBTTagIntArray(int[] nArray) {
            super(nArray);
        }

        public static NBTTagIntArray fromNBT(Object object) {
            try {
                return new NBTTagIntArray(NBT_DATA.invoke(object));
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }

        @Override
        public Object toNBT() {
            try {
                return CONSTRUCTOR.invoke((int[])this.value);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }

        public String toString() {
            return "NBTTagIntArray{" + Arrays.toString((int[])this.value) + '}';
        }

        static {
            Class clazz = NBTWrappers.getNBTClass("NBTTagIntArray");
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            MethodHandle methodHandle = null;
            MethodHandle methodHandle2 = null;
            try {
                methodHandle = lookup.findConstructor(clazz, MethodType.methodType(Void.TYPE, int[].class));
                Field field = NBTWrappers.getDeclaredField(clazz, new String[]{"c", "data"});
                field.setAccessible(true);
                methodHandle2 = lookup.unreflectGetter(field);
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                reflectiveOperationException.printStackTrace();
            }
            CONSTRUCTOR = methodHandle;
            NBT_DATA = methodHandle2;
        }
    }

    public static final class NBTTagLongArray
    extends NBTArray<long[]> {
        private static final MethodHandle CONSTRUCTOR;
        private static final MethodHandle NBT_DATA;

        public NBTTagLongArray(long[] lArray) {
            super(lArray);
        }

        public static NBTTagLongArray fromNBT(Object object) {
            try {
                return new NBTTagLongArray(NBT_DATA.invoke(object));
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }

        @Override
        public Object toNBT() {
            try {
                return CONSTRUCTOR.invoke((long[])this.value);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }

        public String toString() {
            return "NBTTagLongArray{" + Arrays.toString((long[])this.value) + '}';
        }

        static {
            Class clazz = NBTWrappers.getNBTClass("NBTTagLongArray");
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            MethodHandle methodHandle = null;
            MethodHandle methodHandle2 = null;
            try {
                methodHandle = lookup.findConstructor(clazz, MethodType.methodType(Void.TYPE, long[].class));
                Field field = NBTWrappers.getDeclaredField(clazz, new String[]{"c", "data"});
                field.setAccessible(true);
                methodHandle2 = lookup.unreflectGetter(field);
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                reflectiveOperationException.printStackTrace();
            }
            CONSTRUCTOR = methodHandle;
            NBT_DATA = methodHandle2;
        }
    }

    public static final class NBTTagCompound
    extends NBTBase<Map<String, NBTBase<?>>> {
        private static final MethodHandle NBT_TAG_COMPOUND_CONSTRUCTOR;
        private static final MethodHandle GET_COMPOUND_MAP;
        private static final MethodHandle SET_COMPOUND_MAP;

        public NBTTagCompound(Map<String, NBTBase<?>> map) {
            super(map);
        }

        public NBTTagCompound(int n) {
            this(new HashMap(n));
        }

        public NBTTagCompound() {
            this(new HashMap());
        }

        public static Map<String, Object> getRawMap(Object object) {
            try {
                return GET_COMPOUND_MAP.invoke(object);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }

        public static NBTTagCompound fromNBT(Object object) {
            try {
                Map<String, Object> map = NBTTagCompound.getRawMap(object);
                NBTTagCompound nBTTagCompound = new NBTTagCompound(map.size());
                for (Map.Entry<String, Object> entry : map.entrySet()) {
                    NBTBase<?> nBTBase = NBTBase.fromNBT(entry.getValue());
                    if (nBTBase == null) continue;
                    nBTTagCompound.set(entry.getKey(), nBTBase);
                }
                return nBTTagCompound;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }

        public <T> void set(String string, NBTType<T> nBTType, T t) {
            NBTBase nBTBase = null;
            if (nBTType == NBTType.STRING) {
                nBTBase = new NBTTagString((String)t);
            } else if (nBTType == NBTType.BYTE) {
                nBTBase = new NBTTagByte((Byte)t);
            } else if (nBTType == NBTType.BOOLEAN) {
                nBTBase = new NBTTagByte((byte)((Boolean)t != false ? 1 : 0));
            } else if (nBTType == NBTType.SHORT) {
                nBTBase = new NBTTagShort((Short)t);
            } else if (nBTType == NBTType.INTEGER) {
                nBTBase = new NBTTagInt((Integer)t);
            } else if (nBTType == NBTType.LONG) {
                nBTBase = new NBTTagLong((Long)t);
            } else if (nBTType == NBTType.FLOAT) {
                nBTBase = new NBTTagFloat(((Float)t).floatValue());
            } else if (nBTType == NBTType.DOUBLE) {
                nBTBase = new NBTTagDouble((Double)t);
            } else if (nBTType == NBTType.BYTE_ARRAY) {
                nBTBase = new NBTTagByteArray((byte[])t);
            } else if (nBTType == NBTType.INTEGER_ARRAY) {
                nBTBase = new NBTTagIntArray((int[])t);
            } else if (nBTType == NBTType.LONG_ARRAY) {
                nBTBase = new NBTTagLong((Long)t);
            }
            ((Map)this.value).put(string, nBTBase);
        }

        public <T> T get(String string, NBTType<T> nBTType) {
            NBTBase nBTBase = (NBTBase)((Map)this.value).get(string);
            return nBTBase == null ? null : (T)nBTBase.value;
        }

        public <T> boolean has(String string, NBTType<T> nBTType) {
            return this.has(string);
        }

        public boolean has(String string) {
            return ((Map)this.value).containsKey(string);
        }

        public Object getContainer() {
            return this;
        }

        public void set(String string, NBTBase<?> nBTBase) {
            ((Map)this.value).put(string, nBTBase);
        }

        public <T extends NBTBase<?>> T remove(String string) {
            return (T)((NBTBase)((Map)this.value).remove(string));
        }

        public NBTBase<?> removeUnchecked(String string) {
            return (NBTBase)((Map)this.value).remove(string);
        }

        public void setByte(String string, byte by) {
            ((Map)this.getValue()).put(string, new NBTTagByte(by));
        }

        public void setShort(String string, short s2) {
            ((Map)this.getValue()).put(string, new NBTTagShort(s2));
        }

        public void setInt(String string, int n) {
            ((Map)this.getValue()).put(string, new NBTTagInt(n));
        }

        public void setLong(String string, long l) {
            ((Map)this.getValue()).put(string, new NBTTagLong(l));
        }

        public void setFloat(String string, float f) {
            ((Map)this.getValue()).put(string, new NBTTagFloat(f));
        }

        public void setDouble(String string, double d) {
            ((Map)this.getValue()).put(string, new NBTTagDouble(d));
        }

        public void setString(String string, String string2) {
            ((Map)this.getValue()).put(string, new NBTTagString(string2));
        }

        public void setStringList(String string, List<String> list) {
            ArrayList arrayList = new ArrayList(list.size());
            for (String string2 : list) {
                arrayList.add(new NBTTagString(string2));
            }
            ((Map)this.getValue()).put(string, new NBTTagList(arrayList));
        }

        public void setCompound(String string, NBTTagCompound nBTTagCompound) {
            ((Map)this.value).put(string, nBTTagCompound);
        }

        public void setByteArray(String string, byte[] byArray) {
            ((Map)this.getValue()).put(string, new NBTTagByteArray(byArray));
        }

        public void setIntArray(String string, int[] nArray) {
            ((Map)this.getValue()).put(string, new NBTTagIntArray(nArray));
        }

        public void setBoolean(String string, boolean bl) {
            this.setByte(string, (byte)(bl ? 1 : 0));
        }

        public NBTBase<?> get(String string) {
            return (NBTBase)((Map)this.value).get(string);
        }

        public byte getByte(String string) {
            NBTBase<?> nBTBase = this.get(string);
            if (!(nBTBase instanceof NBTTagByte)) {
                return 0;
            }
            return ((NBTTagByte)nBTBase).getAsByte();
        }

        public short getShort(String string) {
            NBTBase<?> nBTBase = this.get(string);
            if (!(nBTBase instanceof NBTTagShort)) {
                return 0;
            }
            return ((NBTTagShort)nBTBase).getAsShort();
        }

        public int getInt(String string) {
            NBTBase<?> nBTBase = this.get(string);
            if (!(nBTBase instanceof NBTTagInt)) {
                return 0;
            }
            return ((NBTTagInt)nBTBase).getAsShort();
        }

        public long getLong(String string) {
            NBTBase<?> nBTBase = this.get(string);
            if (!(nBTBase instanceof NBTTagLong)) {
                return 0L;
            }
            return ((NBTTagLong)nBTBase).getAsLong();
        }

        public NBTTagCompound getCompound(String string) {
            NBTBase<?> nBTBase = this.get(string);
            if (!(nBTBase instanceof NBTTagCompound)) {
                return null;
            }
            return (NBTTagCompound)nBTBase;
        }

        public float getFloat(String string) {
            NBTBase<?> nBTBase = this.get(string);
            if (!(nBTBase instanceof NBTTagFloat)) {
                return 0.0f;
            }
            return ((NBTTagFloat)nBTBase).getAsFloat();
        }

        public double getDouble(String string) {
            NBTBase<?> nBTBase = this.get(string);
            if (!(nBTBase instanceof NBTTagDouble)) {
                return 0.0;
            }
            return ((NBTTagDouble)nBTBase).getAsDouble();
        }

        public String getString(String string) {
            NBTBase<?> nBTBase = this.get(string);
            if (!(nBTBase instanceof NBTTagString)) {
                return null;
            }
            return (String)((NBTTagString)nBTBase).getValue();
        }

        public List<String> getStringList(String string) {
            NBTBase<?> nBTBase = this.get(string);
            if (!(nBTBase instanceof NBTTagList)) {
                return null;
            }
            List list = (List)((NBTTagList)nBTBase).getValue();
            ArrayList<String> arrayList = new ArrayList<String>(list.size());
            for (NBTBase nBTBase2 : list) {
                arrayList.add(String.valueOf(nBTBase2.value));
            }
            return arrayList;
        }

        public byte[] getByteArray(String string) {
            NBTBase<?> nBTBase = this.get(string);
            if (!(nBTBase instanceof NBTTagByteArray)) {
                return null;
            }
            return (byte[])((NBTTagByteArray)nBTBase).getValue();
        }

        public int[] getIntArray(String string) {
            NBTBase<?> nBTBase = this.get(string);
            if (!(nBTBase instanceof NBTTagIntArray)) {
                return null;
            }
            return (int[])((NBTTagIntArray)nBTBase).getValue();
        }

        public boolean getBoolean(String string) {
            return this.getByte(string) != 0;
        }

        @Override
        public Object toNBT() {
            try {
                Object object;
                HashMap<String, Object> hashMap = new HashMap<String, Object>(((Map)this.value).size());
                for (Map.Entry entry : ((Map)this.value).entrySet()) {
                    if (entry.getValue() == this) {
                        throw new IllegalStateException("recursive NBT");
                    }
                    hashMap.put((String)entry.getKey(), ((NBTBase)entry.getValue()).toNBT());
                }
                if (XMaterial.supports(15)) {
                    object = NBT_TAG_COMPOUND_CONSTRUCTOR.invoke(hashMap);
                } else {
                    object = NBT_TAG_COMPOUND_CONSTRUCTOR.invoke();
                    SET_COMPOUND_MAP.invoke(object, hashMap);
                }
                return object;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(10 + ((Map)this.value).size() * 50);
            stringBuilder.append("NBTTagCompound{");
            for (Map.Entry entry : ((Map)this.value).entrySet()) {
                stringBuilder.append('\n').append("  ").append((String)entry.getKey()).append(": ").append(entry.getValue());
            }
            return stringBuilder.append('\n').append('}').toString();
        }

        static {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            Class clazz = NBTWrappers.getNBTClass("NBTTagCompound");
            MethodHandle methodHandle = null;
            MethodHandle methodHandle2 = null;
            MethodHandle methodHandle3 = null;
            try {
                Field field = NBTWrappers.getDeclaredField(clazz, new String[]{"x", "map"});
                field.setAccessible(true);
                methodHandle2 = lookup.unreflectGetter(field);
                if (XMaterial.supports(15)) {
                    Constructor constructor = clazz.getDeclaredConstructor(Map.class);
                    constructor.setAccessible(true);
                    methodHandle = lookup.unreflectConstructor(constructor);
                } else {
                    methodHandle = lookup.findConstructor(clazz, MethodType.methodType(Void.TYPE));
                    methodHandle3 = lookup.unreflectSetter(field);
                }
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                reflectiveOperationException.printStackTrace();
            }
            NBT_TAG_COMPOUND_CONSTRUCTOR = methodHandle;
            GET_COMPOUND_MAP = methodHandle2;
            SET_COMPOUND_MAP = methodHandle3;
        }
    }

    public static final class NBTTagString
    extends NBTBase<String> {
        private static final MethodHandle CONSTRUCTOR;
        private static final MethodHandle NBT_DATA;

        public NBTTagString(String string) {
            super(string);
        }

        public static NBTTagString fromNBT(Object object) {
            try {
                return new NBTTagString(NBT_DATA.invoke(object));
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }

        public NBTType<String> getNBTType() {
            return NBTType.STRING;
        }

        @Override
        public Object toNBT() {
            try {
                return CONSTRUCTOR.invoke(this.value == null ? "" : this.value);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }

        public String toString() {
            return "NBTTagString{" + (String)this.value + '}';
        }

        static {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            Class clazz = NBTWrappers.getNBTClass("NBTTagString");
            MethodHandle methodHandle = null;
            MethodHandle methodHandle2 = null;
            try {
                methodHandle = XMaterial.supports(15) ? lookup.findStatic(clazz, "a", MethodType.methodType(clazz, String.class)) : lookup.findConstructor(clazz, MethodType.methodType(Void.TYPE, String.class));
                Field field = NBTWrappers.getDeclaredField(clazz, new String[]{"A", "data"});
                field.setAccessible(true);
                methodHandle2 = lookup.unreflectGetter(field);
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                reflectiveOperationException.printStackTrace();
            }
            CONSTRUCTOR = methodHandle;
            NBT_DATA = methodHandle2;
        }
    }

    public static final class NBTTagEnd
    extends NBTBase<Void> {
        private static final MethodHandle NBT_CONSTRUCTOR;

        public NBTTagEnd() {
            super(null);
        }

        public static NBTBase<Void> fromNBT(Object object) {
            return null;
        }

        @Override
        public Object toNBT() {
            try {
                return NBT_CONSTRUCTOR.invoke();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }

        public String toString() {
            return "NBTTagEnd";
        }

        static {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            Class clazz = NBTWrappers.getNBTClass("NBTTagEnd");
            Object var2_2 = null;
            try {
                lookup.findConstructor(clazz, MethodType.methodType(Void.TYPE));
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                reflectiveOperationException.printStackTrace();
            }
            NBT_CONSTRUCTOR = var2_2;
        }
    }

    public static abstract class NBTBase<T> {
        protected final T value;

        public NBTBase(T t) {
            this.value = t;
        }

        public static NBTBase<?> fromNBT(Object object) {
            switch (object.getClass().getSimpleName()) {
                case "NBTTagCompound": 
                case "CompoundTag": {
                    return NBTTagCompound.fromNBT(object);
                }
                case "NBTTagString": 
                case "StringTag": {
                    return NBTTagString.fromNBT(object);
                }
                case "NBTTagByte": 
                case "ByteTag": {
                    return NBTTagByte.fromNBT(object);
                }
                case "NBTTagShort": 
                case "ShortTag": {
                    return NBTTagShort.fromNBT(object);
                }
                case "NBTTagInt": 
                case "IntTag": {
                    return NBTTagInt.fromNBT(object);
                }
                case "NBTTagLong": 
                case "LongTag": {
                    return NBTTagLong.fromNBT(object);
                }
                case "NBTTagFloat": 
                case "FloatTag": {
                    return NBTTagFloat.fromNBT(object);
                }
                case "NBTTagDouble": 
                case "DoubleTag": {
                    return NBTTagDouble.fromNBT(object);
                }
                case "NBTTagByteArray": 
                case "ByteArrayTag": {
                    return NBTTagByteArray.fromNBT(object);
                }
                case "NBTTagIntArray": 
                case "IntArrayTag": {
                    return NBTTagIntArray.fromNBT(object);
                }
                case "NBTTagLongArray": 
                case "LongArrayTag": {
                    return NBTTagLongArray.fromNBT(object);
                }
                case "NBTTagList": 
                case "ListTag": {
                    return NBTTagList.fromNBT(object);
                }
                case "NBTTagEnd": 
                case "EndTag": {
                    return NBTTagEnd.fromNBT(object);
                }
            }
            throw new UnsupportedOperationException("Unknown NBT type: " + object.getClass().getSimpleName());
        }

        public final T getValue() {
            return this.value;
        }

        public abstract Object toNBT();
    }
}

