/*
 * Decompiled with CFR 0.152.
 */
package org.skills.utils.nbt;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import org.bukkit.inventory.ItemStack;
import org.skills.utils.nbt.NBTWrappers;
import org.skills.utils.xseries.reflection.XReflection;
import org.skills.utils.xseries.reflection.minecraft.MinecraftMapping;
import org.skills.utils.xseries.reflection.minecraft.MinecraftPackage;

public final class ItemNBT {
    public static final boolean CAN_ACCESS_UNBREAKABLE;
    public static final boolean SUPPORTS_COMPONENTS;
    private static final MethodHandle AS_NMS_COPY;
    private static final MethodHandle AS_BUKKIT_COPY;
    private static final MethodHandle SET_TAG;
    private static final MethodHandle CUSTOM_DATA_CTOR;
    private static final MethodHandle GET_TAG;
    private static final MethodHandle COPY_TAG;
    private static final Object CUSTOM_DATA_TYPE;

    private ItemNBT() {
    }

    private static Object asNMSCopy(ItemStack itemStack) {
        try {
            return AS_NMS_COPY.invoke(itemStack);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    private static ItemStack asBukkitCopy(Object object) {
        try {
            return AS_BUKKIT_COPY.invoke(object);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public static ItemStack setTag(ItemStack itemStack, NBTWrappers.NBTTagCompound nBTTagCompound) {
        Object object = nBTTagCompound.toNBT();
        Object object2 = ItemNBT.asNMSCopy(itemStack);
        try {
            if (SUPPORTS_COMPONENTS) {
                Object object3 = CUSTOM_DATA_CTOR.invoke(object);
                SET_TAG.invoke(object2, CUSTOM_DATA_TYPE, object3);
            } else {
                SET_TAG.invoke(object2, object);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return ItemNBT.asBukkitCopy(object2);
    }

    public static NBTWrappers.NBTTagCompound getTag(ItemStack itemStack) {
        Object object;
        Object object2 = ItemNBT.asNMSCopy(itemStack);
        try {
            if (SUPPORTS_COMPONENTS) {
                object = GET_TAG.invoke(object2, CUSTOM_DATA_TYPE);
                if (object != null) {
                    object = COPY_TAG.invoke(object);
                }
            } else {
                object = GET_TAG.invoke(object2);
            }
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
        if (object == null) {
            return new NBTWrappers.NBTTagCompound();
        }
        NBTWrappers.NBTTagCompound nBTTagCompound = NBTWrappers.NBTTagCompound.fromNBT(object);
        return nBTTagCompound == null ? new NBTWrappers.NBTTagCompound() : nBTTagCompound;
    }

    public static ItemStack addSimpleTag(ItemStack itemStack, String string, String string2) {
        NBTWrappers.NBTTagCompound nBTTagCompound = ItemNBT.getTag(itemStack);
        nBTTagCompound.setString(string, string2);
        return ItemNBT.setTag(itemStack, nBTTagCompound);
    }

    static {
        MethodHandle methodHandle;
        MethodHandle methodHandle2;
        CAN_ACCESS_UNBREAKABLE = XReflection.supports(11);
        MethodHandle methodHandle3 = null;
        MethodHandle methodHandle4 = null;
        MethodHandle methodHandle5 = null;
        MethodHandle methodHandle6 = null;
        Object object = null;
        boolean bl = false;
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        Class<?> clazz = XReflection.getCraftClass("inventory.CraftItemStack");
        Class<?> clazz2 = XReflection.getNMSClass("world.item", "ItemStack");
        Class<?> clazz3 = XReflection.getNMSClass("nbt", "NBTTagCompound");
        try {
            methodHandle3 = lookup.findStatic(clazz, "asNMSCopy", MethodType.methodType(clazz2, ItemStack.class));
            methodHandle4 = lookup.findStatic(clazz, "asBukkitCopy", MethodType.methodType(ItemStack.class, clazz2));
        }
        catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
        try {
            Object object2 = XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "core.component").map(MinecraftMapping.MOJANG, "DataComponents").reflect();
            Object object3 = XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "core.component").map(MinecraftMapping.MOJANG, "DataComponents").reflect();
            XReflection.getNMSClass("core.component", "DataComponentHolder");
            Object object4 = XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "core.component").map(MinecraftMapping.MOJANG, "DataComponentType").reflect();
            Object object5 = XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "world.item.component").map(MinecraftMapping.MOJANG, "CustomData").reflect();
            methodHandle2 = lookup.findVirtual(clazz2, XReflection.v(20, 5, "b").orElse("set"), MethodType.methodType(Object.class, object4, new Class[]{Object.class}));
            methodHandle = lookup.findVirtual(clazz2, XReflection.v(20, 5, "a").orElse("get"), MethodType.methodType(Object.class, object4));
            methodHandle6 = lookup.findVirtual((Class<?>)object5, XReflection.v(20, 5, "c").orElse("copyTag"), MethodType.methodType(clazz3));
            Constructor constructor = ((Class)object5).getDeclaredConstructor(clazz3);
            constructor.setAccessible(true);
            methodHandle5 = lookup.unreflectConstructor(constructor);
            Field field = ((Class)object2).getDeclaredField(XReflection.v(20, 5, "b").orElse("CUSTOM_DATA"));
            object = field.get(null);
            bl = true;
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException reflectiveOperationException) {
            try {
                methodHandle2 = lookup.findVirtual(clazz2, XReflection.v(18, "c").orElse("setTag"), MethodType.methodType(Void.TYPE, clazz3));
                methodHandle = lookup.findVirtual(clazz2, XReflection.v(19, "v").v(18, "t").orElse("getTag"), MethodType.methodType(clazz3));
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException2) {
                RuntimeException runtimeException = new RuntimeException(reflectiveOperationException2);
                runtimeException.addSuppressed(reflectiveOperationException);
                throw runtimeException;
            }
        }
        AS_NMS_COPY = methodHandle3;
        AS_BUKKIT_COPY = methodHandle4;
        SET_TAG = methodHandle2;
        GET_TAG = methodHandle;
        COPY_TAG = methodHandle6;
        CUSTOM_DATA_TYPE = object;
        CUSTOM_DATA_CTOR = methodHandle5;
        SUPPORTS_COMPONENTS = bl;
    }
}

