/*
 * Decompiled with CFR 0.152.
 */
package org.skills.utils.caffeine.cache.stats;

import java.util.concurrent.atomic.LongAdder;
import org.skills.utils.caffeine.cache.RemovalCause;
import org.skills.utils.caffeine.cache.stats.CacheStats;
import org.skills.utils.caffeine.cache.stats.StatsCounter;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.NonNull;

public final class ConcurrentStatsCounter
implements StatsCounter {
    private final LongAdder hitCount = new LongAdder();
    private final LongAdder missCount = new LongAdder();
    private final LongAdder loadSuccessCount = new LongAdder();
    private final LongAdder loadFailureCount = new LongAdder();
    private final LongAdder totalLoadTime = new LongAdder();
    private final LongAdder evictionCount = new LongAdder();
    private final LongAdder evictionWeight = new LongAdder();

    @Override
    public void recordHits(int n) {
        this.hitCount.add(n);
    }

    @Override
    public void recordMisses(int n) {
        this.missCount.add(n);
    }

    @Override
    public void recordLoadSuccess(long l) {
        this.loadSuccessCount.increment();
        this.totalLoadTime.add(l);
    }

    @Override
    public void recordLoadFailure(long l) {
        this.loadFailureCount.increment();
        this.totalLoadTime.add(l);
    }

    @Override
    @Deprecated
    public void recordEviction() {
        this.evictionCount.increment();
    }

    @Override
    @Deprecated
    public void recordEviction(int n) {
        this.evictionCount.increment();
        this.evictionWeight.add(n);
    }

    @Override
    public void recordEviction(int n, RemovalCause removalCause) {
        this.evictionCount.increment();
        this.evictionWeight.add(n);
    }

    @Override
    public CacheStats snapshot() {
        return CacheStats.of(ConcurrentStatsCounter.negativeToMaxValue(this.hitCount.sum()), ConcurrentStatsCounter.negativeToMaxValue(this.missCount.sum()), ConcurrentStatsCounter.negativeToMaxValue(this.loadSuccessCount.sum()), ConcurrentStatsCounter.negativeToMaxValue(this.loadFailureCount.sum()), ConcurrentStatsCounter.negativeToMaxValue(this.totalLoadTime.sum()), ConcurrentStatsCounter.negativeToMaxValue(this.evictionCount.sum()), ConcurrentStatsCounter.negativeToMaxValue(this.evictionWeight.sum()));
    }

    private static long negativeToMaxValue(long l) {
        return l >= 0L ? l : Long.MAX_VALUE;
    }

    public void incrementBy(@NonNull StatsCounter statsCounter) {
        CacheStats cacheStats = statsCounter.snapshot();
        this.hitCount.add(cacheStats.hitCount());
        this.missCount.add(cacheStats.missCount());
        this.loadSuccessCount.add(cacheStats.loadSuccessCount());
        this.loadFailureCount.add(cacheStats.loadFailureCount());
        this.totalLoadTime.add(cacheStats.totalLoadTime());
        this.evictionCount.add(cacheStats.evictionCount());
        this.evictionWeight.add(cacheStats.evictionWeight());
    }

    public String toString() {
        return this.snapshot().toString();
    }
}

