/*
 * Decompiled with CFR 0.152.
 */
package org.skills.utils.caffeine.cache;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.skills.utils.caffeine.cache.Async;
import org.skills.utils.caffeine.cache.AsyncCacheLoader;
import org.skills.utils.caffeine.cache.Cache;
import org.skills.utils.caffeine.cache.CacheLoader;
import org.skills.utils.caffeine.cache.CacheWriter;
import org.skills.utils.caffeine.cache.Caffeine;
import org.skills.utils.caffeine.cache.LocalAsyncCache;
import org.skills.utils.caffeine.cache.LocalAsyncLoadingCache;
import org.skills.utils.caffeine.cache.LocalCache;
import org.skills.utils.caffeine.cache.LocalLoadingCache;
import org.skills.utils.caffeine.cache.LocalManualCache;
import org.skills.utils.caffeine.cache.Policy;
import org.skills.utils.caffeine.cache.RemovalCause;
import org.skills.utils.caffeine.cache.RemovalListener;
import org.skills.utils.caffeine.cache.SerializationProxy;
import org.skills.utils.caffeine.cache.Ticker;
import org.skills.utils.caffeine.cache.WriteThroughEntry;
import org.skills.utils.caffeine.cache.stats.StatsCounter;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.Nullable;

final class UnboundedLocalCache<K, V>
implements LocalCache<K, V> {
    final @Nullable RemovalListener<K, V> removalListener;
    final ConcurrentHashMap<K, V> data;
    final StatsCounter statsCounter;
    final boolean isRecordingStats;
    final CacheWriter<K, V> writer;
    final Executor executor;
    final Ticker ticker;
    transient @Nullable Set<K> keySet;
    transient @Nullable Collection<V> values;
    transient @Nullable Set<Map.Entry<K, V>> entrySet;

    UnboundedLocalCache(Caffeine<? super K, ? super V> caffeine, boolean bl) {
        this.data = new ConcurrentHashMap(caffeine.getInitialCapacity());
        this.statsCounter = caffeine.getStatsCounterSupplier().get();
        this.removalListener = caffeine.getRemovalListener(bl);
        this.isRecordingStats = caffeine.isRecordingStats();
        this.writer = caffeine.getCacheWriter(bl);
        this.executor = caffeine.getExecutor();
        this.ticker = caffeine.getTicker();
    }

    @Override
    public boolean hasWriteTime() {
        return false;
    }

    @Override
    public @Nullable V getIfPresent(Object object, boolean bl) {
        V v = this.data.get(object);
        if (bl) {
            if (v == null) {
                this.statsCounter.recordMisses(1);
            } else {
                this.statsCounter.recordHits(1);
            }
        }
        return v;
    }

    @Override
    public @Nullable V getIfPresentQuietly(Object object, long[] lArray) {
        return this.data.get(object);
    }

    @Override
    public long estimatedSize() {
        return this.data.mappingCount();
    }

    @Override
    public Map<K, V> getAllPresent(Iterable<?> iterable) {
        Object object2;
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        for (Object object2 : iterable) {
            linkedHashSet.add(object2);
        }
        int n = 0;
        object2 = new LinkedHashMap(linkedHashSet.size());
        for (Object e : linkedHashSet) {
            V v = this.data.get(e);
            if (v == null) {
                ++n;
                continue;
            }
            object2.put(e, v);
        }
        this.statsCounter.recordMisses(n);
        this.statsCounter.recordHits(object2.size());
        Object object3 = object2;
        return Collections.unmodifiableMap(object3);
    }

    @Override
    public void cleanUp() {
    }

    @Override
    public StatsCounter statsCounter() {
        return this.statsCounter;
    }

    @Override
    public boolean hasRemovalListener() {
        return this.removalListener != null;
    }

    @Override
    public RemovalListener<K, V> removalListener() {
        return this.removalListener;
    }

    @Override
    public void notifyRemoval(@Nullable K k, @Nullable V v, RemovalCause removalCause) {
        Objects.requireNonNull(this.removalListener(), "Notification should be guarded with a check");
        this.executor.execute(() -> this.removalListener().onRemoval(k, v, removalCause));
    }

    @Override
    public boolean isRecordingStats() {
        return this.isRecordingStats;
    }

    @Override
    public Executor executor() {
        return this.executor;
    }

    @Override
    public Ticker expirationTicker() {
        return Ticker.disabledTicker();
    }

    @Override
    public Ticker statsTicker() {
        return this.ticker;
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> biConsumer) {
        this.data.forEach(biConsumer);
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> biFunction) {
        Objects.requireNonNull(biFunction);
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = new Object[1];
        this.data.replaceAll((object, object2) -> {
            Object r;
            if (objectArray[0] != null) {
                this.notifyRemoval(objectArray[0], objectArray2[0], RemovalCause.REPLACED);
                objectArray2[0] = null;
                objectArray[0] = null;
            }
            if ((r = Objects.requireNonNull(biFunction.apply((K)object, (V)object2))) != object2) {
                this.writer.write(object, r);
            }
            if (this.hasRemovalListener() && r != object2) {
                objectArray[0] = object;
                objectArray2[0] = object2;
            }
            return r;
        });
        if (objectArray[0] != null) {
            this.notifyRemoval(objectArray[0], objectArray2[0], RemovalCause.REPLACED);
        }
    }

    @Override
    public V computeIfAbsent(K k, Function<? super K, ? extends V> function, boolean bl, boolean bl2) {
        Objects.requireNonNull(function);
        Object object = this.data.get(k);
        if (object != null) {
            if (bl) {
                this.statsCounter.recordHits(1);
            }
            return object;
        }
        boolean[] blArray = new boolean[1];
        object = this.data.computeIfAbsent(k, object2 -> {
            blArray[0] = true;
            return bl ? this.statsAware(function, bl2).apply(k) : function.apply((K)k);
        });
        if (!blArray[0] && bl) {
            this.statsCounter.recordHits(1);
        }
        return object;
    }

    @Override
    public @Nullable V computeIfPresent(K k, BiFunction<? super K, ? super V, ? extends V> biFunction) {
        Objects.requireNonNull(biFunction);
        if (!this.data.containsKey(k)) {
            return null;
        }
        Object[] objectArray = new Object[1];
        RemovalCause[] removalCauseArray = new RemovalCause[1];
        Object object3 = this.data.computeIfPresent(k, (object, object2) -> {
            BiFunction biFunction2 = this.statsAware(biFunction, false, true, true);
            Object r = biFunction2.apply(object, object2);
            RemovalCause removalCause = removalCauseArray[0] = r == null ? RemovalCause.EXPLICIT : RemovalCause.REPLACED;
            if (this.hasRemovalListener() && r != object2) {
                objectArray[0] = object2;
            }
            return r;
        });
        if (objectArray[0] != null) {
            this.notifyRemoval(k, objectArray[0], removalCauseArray[0]);
        }
        return (V)object3;
    }

    @Override
    public V compute(K k, BiFunction<? super K, ? super V, ? extends V> biFunction, boolean bl, boolean bl2, boolean bl3) {
        Objects.requireNonNull(biFunction);
        return this.remap(k, this.statsAware(biFunction, bl, bl2, bl3));
    }

    @Override
    public V merge(K k, V v, BiFunction<? super V, ? super V, ? extends V> biFunction) {
        Objects.requireNonNull(biFunction);
        Objects.requireNonNull(v);
        return (V)this.remap(k, (object2, object3) -> object3 == null ? v : this.statsAware(biFunction).apply(object3, v));
    }

    V remap(K k, BiFunction<? super K, ? super V, ? extends V> biFunction) {
        Object[] objectArray = new Object[1];
        RemovalCause[] removalCauseArray = new RemovalCause[1];
        Object object3 = this.data.compute(k, (object, object2) -> {
            Object r = biFunction.apply((K)object, (V)object2);
            if (object2 == null && r == null) {
                return null;
            }
            RemovalCause removalCause = removalCauseArray[0] = r == null ? RemovalCause.EXPLICIT : RemovalCause.REPLACED;
            if (this.hasRemovalListener() && object2 != null && r != object2) {
                objectArray[0] = object2;
            }
            return r;
        });
        if (objectArray[0] != null) {
            this.notifyRemoval(k, objectArray[0], removalCauseArray[0]);
        }
        return (V)object3;
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public void clear() {
        if (!this.hasRemovalListener() && this.writer == CacheWriter.disabledWriter()) {
            this.data.clear();
            return;
        }
        for (Object k : this.data.keySet()) {
            this.remove(k);
        }
    }

    @Override
    public boolean containsKey(Object object) {
        return this.data.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.data.containsValue(object);
    }

    @Override
    public @Nullable V get(Object object) {
        return this.getIfPresent(object, false);
    }

    @Override
    public @Nullable V put(K k, V v) {
        return this.put(k, v, true);
    }

    @Override
    public @Nullable V put(K k, V v, boolean bl) {
        Objects.requireNonNull(v);
        Object[] objectArray = new Object[1];
        if (this.writer == CacheWriter.disabledWriter() || !bl) {
            objectArray[0] = this.data.put(k, v);
        } else {
            this.data.compute(k, (object3, object4) -> {
                if (v != object4) {
                    this.writer.write(k, v);
                }
                objectArray[0] = object4;
                return v;
            });
        }
        if (this.hasRemovalListener() && objectArray[0] != null && objectArray[0] != v) {
            this.notifyRemoval(k, objectArray[0], RemovalCause.REPLACED);
        }
        return (V)objectArray[0];
    }

    @Override
    public @Nullable V putIfAbsent(K k, V v) {
        Objects.requireNonNull(v);
        boolean[] blArray = new boolean[1];
        Object object = this.data.computeIfAbsent(k, object3 -> {
            this.writer.write(k, v);
            blArray[0] = true;
            return v;
        });
        return (V)(blArray[0] ? null : object);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        if (!this.hasRemovalListener() && this.writer == CacheWriter.disabledWriter()) {
            this.data.putAll(map);
            return;
        }
        map.forEach(this::put);
    }

    @Override
    public @Nullable V remove(Object object) {
        Object object4 = object;
        Object[] objectArray = new Object[1];
        if (this.writer == CacheWriter.disabledWriter()) {
            objectArray[0] = this.data.remove(object);
        } else {
            this.data.computeIfPresent(object4, (object2, object3) -> {
                this.writer.delete(object4, object3, RemovalCause.EXPLICIT);
                objectArray[0] = object3;
                return null;
            });
        }
        if (this.hasRemovalListener() && objectArray[0] != null) {
            this.notifyRemoval(object4, objectArray[0], RemovalCause.EXPLICIT);
        }
        return (V)objectArray[0];
    }

    @Override
    public boolean remove(Object object, Object object2) {
        boolean bl;
        if (object2 == null) {
            Objects.requireNonNull(object);
            return false;
        }
        Object object5 = object;
        Object[] objectArray = new Object[1];
        this.data.computeIfPresent(object5, (object3, object4) -> {
            if (object4.equals(object2)) {
                this.writer.delete(object5, object4, RemovalCause.EXPLICIT);
                objectArray[0] = object4;
                return null;
            }
            return object4;
        });
        boolean bl2 = bl = objectArray[0] != null;
        if (this.hasRemovalListener() && bl) {
            this.notifyRemoval(object5, objectArray[0], RemovalCause.EXPLICIT);
        }
        return bl;
    }

    @Override
    public @Nullable V replace(K k, V v) {
        Objects.requireNonNull(v);
        Object[] objectArray = new Object[1];
        this.data.computeIfPresent(k, (object3, object4) -> {
            if (v != object4) {
                this.writer.write(k, v);
            }
            objectArray[0] = object4;
            return v;
        });
        if (this.hasRemovalListener() && objectArray[0] != null && objectArray[0] != v) {
            this.notifyRemoval(k, v, RemovalCause.REPLACED);
        }
        return (V)objectArray[0];
    }

    @Override
    public boolean replace(K k, V v, V v2) {
        boolean bl;
        Objects.requireNonNull(v);
        Objects.requireNonNull(v2);
        Object[] objectArray = new Object[1];
        this.data.computeIfPresent(k, (object4, object5) -> {
            if (object5.equals(v)) {
                if (v2 != object5) {
                    this.writer.write(k, v2);
                }
                objectArray[0] = object5;
                return v2;
            }
            return object5;
        });
        boolean bl2 = bl = objectArray[0] != null;
        if (this.hasRemovalListener() && bl && objectArray[0] != v2) {
            this.notifyRemoval(k, objectArray[0], RemovalCause.REPLACED);
        }
        return bl;
    }

    @Override
    public boolean equals(Object object) {
        return this.data.equals(object);
    }

    @Override
    public int hashCode() {
        return this.data.hashCode();
    }

    public String toString() {
        return this.data.toString();
    }

    @Override
    public Set<K> keySet() {
        Set<K> set = this.keySet;
        return set == null ? (this.keySet = new KeySetView(this)) : set;
    }

    @Override
    public Collection<V> values() {
        Collection<V> collection = this.values;
        return collection == null ? (this.values = new ValuesView(this)) : collection;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Set<Map.Entry<K, V>> set = this.entrySet;
        return set == null ? (this.entrySet = new EntrySetView(this)) : set;
    }

    static final class UnboundedLocalAsyncLoadingCache<K, V>
    extends LocalAsyncLoadingCache<K, V>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final UnboundedLocalCache<K, CompletableFuture<V>> cache;
        @Nullable ConcurrentMap<K, CompletableFuture<V>> mapView;
        @Nullable Policy<K, V> policy;

        UnboundedLocalAsyncLoadingCache(Caffeine<K, V> caffeine, AsyncCacheLoader<? super K, V> asyncCacheLoader) {
            super(asyncCacheLoader);
            this.cache = new UnboundedLocalCache<K, V>(caffeine, true);
        }

        @Override
        public LocalCache<K, CompletableFuture<V>> cache() {
            return this.cache;
        }

        @Override
        public ConcurrentMap<K, CompletableFuture<V>> asMap() {
            return this.mapView == null ? (this.mapView = new LocalAsyncCache.AsyncAsMapView(this)) : this.mapView;
        }

        @Override
        public Policy<K, V> policy() {
            Function<CompletableFuture, Object> function;
            UnboundedLocalCache<K, CompletableFuture<V>> unboundedLocalCache = this.cache;
            Function<CompletableFuture, Object> function2 = function = Async::getIfReady;
            return this.policy == null ? (this.policy = new UnboundedPolicy<K, Object>(unboundedLocalCache, function2)) : this.policy;
        }

        private void readObject(ObjectInputStream objectInputStream) {
            throw new InvalidObjectException("Proxy required");
        }

        Object writeReplace() {
            SerializationProxy serializationProxy = new SerializationProxy();
            serializationProxy.isRecordingStats = this.cache.isRecordingStats();
            serializationProxy.removalListener = this.cache.removalListener();
            serializationProxy.ticker = this.cache.ticker;
            serializationProxy.writer = this.cache.writer;
            serializationProxy.loader = this.loader;
            serializationProxy.async = true;
            return serializationProxy;
        }
    }

    static final class UnboundedLocalAsyncCache<K, V>
    implements LocalAsyncCache<K, V>,
    Serializable {
        private static final long serialVersionUID = 1L;
        final UnboundedLocalCache<K, CompletableFuture<V>> cache;
        @Nullable ConcurrentMap<K, CompletableFuture<V>> mapView;
        @Nullable LocalAsyncCache.CacheView<K, V> cacheView;
        @Nullable Policy<K, V> policy;

        UnboundedLocalAsyncCache(Caffeine<K, V> caffeine) {
            this.cache = new UnboundedLocalCache<K, V>(caffeine, true);
        }

        @Override
        public UnboundedLocalCache<K, CompletableFuture<V>> cache() {
            return this.cache;
        }

        @Override
        public ConcurrentMap<K, CompletableFuture<V>> asMap() {
            return this.mapView == null ? (this.mapView = new LocalAsyncCache.AsyncAsMapView(this)) : this.mapView;
        }

        @Override
        public Cache<K, V> synchronous() {
            return this.cacheView == null ? (this.cacheView = new LocalAsyncCache.CacheView(this)) : this.cacheView;
        }

        @Override
        public Policy<K, V> policy() {
            Function<CompletableFuture, Object> function;
            UnboundedLocalCache<K, CompletableFuture<V>> unboundedLocalCache = this.cache;
            Function<CompletableFuture, Object> function2 = function = Async::getIfReady;
            return this.policy == null ? (this.policy = new UnboundedPolicy<K, Object>(unboundedLocalCache, function2)) : this.policy;
        }

        private void readObject(ObjectInputStream objectInputStream) {
            throw new InvalidObjectException("Proxy required");
        }

        Object writeReplace() {
            SerializationProxy serializationProxy = new SerializationProxy();
            serializationProxy.isRecordingStats = this.cache.isRecordingStats;
            serializationProxy.removalListener = this.cache.removalListener;
            serializationProxy.ticker = this.cache.ticker;
            serializationProxy.writer = this.cache.writer;
            serializationProxy.async = true;
            return serializationProxy;
        }
    }

    static final class UnboundedLocalLoadingCache<K, V>
    extends UnboundedLocalManualCache<K, V>
    implements LocalLoadingCache<K, V> {
        private static final long serialVersionUID = 1L;
        final Function<K, V> mappingFunction;
        final CacheLoader<? super K, V> loader;
        final @Nullable Function<Iterable<? extends K>, Map<K, V>> bulkMappingFunction;

        UnboundedLocalLoadingCache(Caffeine<K, V> caffeine, CacheLoader<? super K, V> cacheLoader) {
            super(caffeine);
            this.loader = cacheLoader;
            this.mappingFunction = LocalLoadingCache.newMappingFunction(cacheLoader);
            this.bulkMappingFunction = LocalLoadingCache.newBulkMappingFunction(cacheLoader);
        }

        @Override
        public CacheLoader<? super K, V> cacheLoader() {
            return this.loader;
        }

        @Override
        public Function<K, V> mappingFunction() {
            return this.mappingFunction;
        }

        @Override
        public @Nullable Function<Iterable<? extends K>, Map<K, V>> bulkMappingFunction() {
            return this.bulkMappingFunction;
        }

        @Override
        Object writeReplace() {
            SerializationProxy serializationProxy = (SerializationProxy)super.writeReplace();
            serializationProxy.loader = this.loader;
            return serializationProxy;
        }

        private void readObject(ObjectInputStream objectInputStream) {
            throw new InvalidObjectException("Proxy required");
        }
    }

    static final class UnboundedPolicy<K, V>
    implements Policy<K, V> {
        final UnboundedLocalCache<K, V> cache;
        final Function<V, V> transformer;

        UnboundedPolicy(UnboundedLocalCache<K, V> unboundedLocalCache, Function<V, V> function) {
            this.transformer = function;
            this.cache = unboundedLocalCache;
        }

        @Override
        public boolean isRecordingStats() {
            return this.cache.isRecordingStats;
        }

        @Override
        public V getIfPresentQuietly(Object object) {
            return this.transformer.apply(this.cache.data.get(object));
        }

        @Override
        public Optional<Policy.Eviction<K, V>> eviction() {
            return Optional.empty();
        }

        @Override
        public Optional<Policy.Expiration<K, V>> expireAfterAccess() {
            return Optional.empty();
        }

        @Override
        public Optional<Policy.Expiration<K, V>> expireAfterWrite() {
            return Optional.empty();
        }

        @Override
        public Optional<Policy.Expiration<K, V>> refreshAfterWrite() {
            return Optional.empty();
        }
    }

    static class UnboundedLocalManualCache<K, V>
    implements LocalManualCache<K, V>,
    Serializable {
        private static final long serialVersionUID = 1L;
        final UnboundedLocalCache<K, V> cache;
        @Nullable Policy<K, V> policy;

        UnboundedLocalManualCache(Caffeine<K, V> caffeine) {
            this.cache = new UnboundedLocalCache<K, V>(caffeine, false);
        }

        @Override
        public UnboundedLocalCache<K, V> cache() {
            return this.cache;
        }

        @Override
        public Policy<K, V> policy() {
            return this.policy == null ? (this.policy = new UnboundedPolicy<K, V>(this.cache, Function.identity())) : this.policy;
        }

        private void readObject(ObjectInputStream objectInputStream) {
            throw new InvalidObjectException("Proxy required");
        }

        Object writeReplace() {
            SerializationProxy serializationProxy = new SerializationProxy();
            serializationProxy.isRecordingStats = this.cache.isRecordingStats;
            serializationProxy.removalListener = this.cache.removalListener;
            serializationProxy.ticker = this.cache.ticker;
            serializationProxy.writer = this.cache.writer;
            return serializationProxy;
        }
    }

    static final class EntrySpliterator<K, V>
    implements Spliterator<Map.Entry<K, V>> {
        final Spliterator<Map.Entry<K, V>> spliterator;
        final UnboundedLocalCache<K, V> cache;

        EntrySpliterator(UnboundedLocalCache<K, V> unboundedLocalCache) {
            this(unboundedLocalCache, unboundedLocalCache.data.entrySet().spliterator());
        }

        EntrySpliterator(UnboundedLocalCache<K, V> unboundedLocalCache, Spliterator<Map.Entry<K, V>> spliterator) {
            this.spliterator = Objects.requireNonNull(spliterator);
            this.cache = Objects.requireNonNull(unboundedLocalCache);
        }

        @Override
        public void forEachRemaining(Consumer<? super Map.Entry<K, V>> consumer) {
            Objects.requireNonNull(consumer);
            this.spliterator.forEachRemaining((? super T entry) -> {
                WriteThroughEntry<K, V> writeThroughEntry = new WriteThroughEntry<K, V>(this.cache, entry.getKey(), entry.getValue());
                consumer.accept(writeThroughEntry);
            });
        }

        @Override
        public boolean tryAdvance(Consumer<? super Map.Entry<K, V>> consumer) {
            Objects.requireNonNull(consumer);
            return this.spliterator.tryAdvance((? super T entry) -> {
                WriteThroughEntry<K, V> writeThroughEntry = new WriteThroughEntry<K, V>(this.cache, entry.getKey(), entry.getValue());
                consumer.accept(writeThroughEntry);
            });
        }

        public @Nullable EntrySpliterator<K, V> trySplit() {
            Spliterator<Map.Entry<K, V>> spliterator = this.spliterator.trySplit();
            return spliterator == null ? null : new EntrySpliterator<K, V>(this.cache, spliterator);
        }

        @Override
        public long estimateSize() {
            return this.spliterator.estimateSize();
        }

        @Override
        public int characteristics() {
            return this.spliterator.characteristics();
        }
    }

    static final class EntryIterator<K, V>
    implements Iterator<Map.Entry<K, V>> {
        final UnboundedLocalCache<K, V> cache;
        final Iterator<Map.Entry<K, V>> iterator;
        @Nullable Map.Entry<K, V> entry;

        EntryIterator(UnboundedLocalCache<K, V> unboundedLocalCache) {
            this.cache = Objects.requireNonNull(unboundedLocalCache);
            this.iterator = unboundedLocalCache.data.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            this.entry = this.iterator.next();
            return new WriteThroughEntry<K, V>(this.cache, this.entry.getKey(), this.entry.getValue());
        }

        @Override
        public void remove() {
            if (this.entry == null) {
                throw new IllegalStateException();
            }
            this.cache.remove(this.entry.getKey());
            this.entry = null;
        }
    }

    static final class EntrySetView<K, V>
    extends AbstractSet<Map.Entry<K, V>> {
        final UnboundedLocalCache<K, V> cache;

        EntrySetView(UnboundedLocalCache<K, V> unboundedLocalCache) {
            this.cache = Objects.requireNonNull(unboundedLocalCache);
        }

        @Override
        public boolean isEmpty() {
            return this.cache.isEmpty();
        }

        @Override
        public int size() {
            return this.cache.size();
        }

        @Override
        public void clear() {
            this.cache.clear();
        }

        @Override
        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            V v = this.cache.get(entry.getKey());
            return v != null && v.equals(entry.getValue());
        }

        @Override
        public boolean remove(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return this.cache.remove(entry.getKey(), entry.getValue());
        }

        @Override
        public boolean removeIf(Predicate<? super Map.Entry<K, V>> predicate) {
            Objects.requireNonNull(predicate);
            boolean bl = false;
            for (Map.Entry entry : this.cache.data.entrySet()) {
                if (!predicate.test(entry)) continue;
                bl |= this.cache.remove(entry.getKey(), entry.getValue());
            }
            return bl;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator<K, V>(this.cache);
        }

        @Override
        public Spliterator<Map.Entry<K, V>> spliterator() {
            return new EntrySpliterator<K, V>(this.cache);
        }
    }

    static final class ValuesIterator<K, V>
    implements Iterator<V> {
        final UnboundedLocalCache<K, V> cache;
        final Iterator<Map.Entry<K, V>> iterator;
        @Nullable Map.Entry<K, V> entry;

        ValuesIterator(UnboundedLocalCache<K, V> unboundedLocalCache) {
            this.cache = Objects.requireNonNull(unboundedLocalCache);
            this.iterator = unboundedLocalCache.data.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public V next() {
            this.entry = this.iterator.next();
            return this.entry.getValue();
        }

        @Override
        public void remove() {
            if (this.entry == null) {
                throw new IllegalStateException();
            }
            this.cache.remove(this.entry.getKey());
            this.entry = null;
        }
    }

    static final class ValuesView<K, V>
    extends AbstractCollection<V> {
        final UnboundedLocalCache<K, V> cache;

        ValuesView(UnboundedLocalCache<K, V> unboundedLocalCache) {
            this.cache = Objects.requireNonNull(unboundedLocalCache);
        }

        @Override
        public boolean isEmpty() {
            return this.cache.isEmpty();
        }

        @Override
        public int size() {
            return this.cache.size();
        }

        @Override
        public void clear() {
            this.cache.clear();
        }

        @Override
        public boolean contains(Object object) {
            return this.cache.containsValue(object);
        }

        @Override
        public boolean removeIf(Predicate<? super V> predicate) {
            Objects.requireNonNull(predicate);
            boolean bl = false;
            for (Map.Entry entry : this.cache.data.entrySet()) {
                if (!predicate.test(entry.getValue())) continue;
                bl |= this.cache.remove(entry.getKey(), entry.getValue());
            }
            return bl;
        }

        @Override
        public Iterator<V> iterator() {
            return new ValuesIterator<K, V>(this.cache);
        }

        @Override
        public Spliterator<V> spliterator() {
            return this.cache.data.values().spliterator();
        }
    }

    static final class KeyIterator<K>
    implements Iterator<K> {
        final UnboundedLocalCache<K, ?> cache;
        final Iterator<K> iterator;
        @Nullable K current;

        KeyIterator(UnboundedLocalCache<K, ?> unboundedLocalCache) {
            this.cache = Objects.requireNonNull(unboundedLocalCache);
            this.iterator = ((ConcurrentHashMap.KeySetView)unboundedLocalCache.data.keySet()).iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public K next() {
            this.current = this.iterator.next();
            return this.current;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            this.cache.remove(this.current);
            this.current = null;
        }
    }

    static final class KeySetView<K>
    extends AbstractSet<K> {
        final UnboundedLocalCache<K, ?> cache;

        KeySetView(UnboundedLocalCache<K, ?> unboundedLocalCache) {
            this.cache = Objects.requireNonNull(unboundedLocalCache);
        }

        @Override
        public boolean isEmpty() {
            return this.cache.isEmpty();
        }

        @Override
        public int size() {
            return this.cache.size();
        }

        @Override
        public void clear() {
            this.cache.clear();
        }

        @Override
        public boolean contains(Object object) {
            return this.cache.containsKey(object);
        }

        @Override
        public boolean remove(Object object) {
            return this.cache.remove(object) != null;
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator<K>(this.cache);
        }

        @Override
        public Spliterator<K> spliterator() {
            return ((ConcurrentHashMap.KeySetView)this.cache.data.keySet()).spliterator();
        }
    }
}

