/*
 * Decompiled with CFR 0.152.
 */
package org.skills.utils.caffeine.cache;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.skills.utils.caffeine.cache.Scheduler;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.Nullable;

enum SystemScheduler implements Scheduler
{
    INSTANCE;

    static final @Nullable Method delayedExecutor;

    @Override
    public Future<?> schedule(Executor executor, Runnable runnable, long l, TimeUnit timeUnit) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(runnable);
        Objects.requireNonNull(timeUnit);
        try {
            Executor executor2 = (Executor)delayedExecutor.invoke(CompletableFuture.class, new Object[]{l, timeUnit, executor});
            return CompletableFuture.runAsync(runnable, executor2);
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }

    static @Nullable Method getDelayedExecutorMethod() {
        try {
            return CompletableFuture.class.getMethod("delayedExecutor", Long.TYPE, TimeUnit.class, Executor.class);
        }
        catch (NoSuchMethodException | SecurityException exception) {
            return null;
        }
    }

    static boolean isPresent() {
        return delayedExecutor != null;
    }

    static {
        delayedExecutor = SystemScheduler.getDelayedExecutorMethod();
    }
}

