/*
 * Decompiled with CFR 0.152.
 */
package org.skills.utils.caffeine.cache;

import java.util.Arrays;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import org.skills.utils.caffeine.cache.Buffer;
import org.skills.utils.caffeine.cache.Caffeine;
import org.skills.utils.caffeine.cache.UnsafeAccess;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.Nullable;

abstract class StripedBuffer<E>
implements Buffer<E> {
    static final long TABLE_BUSY = UnsafeAccess.objectFieldOffset(StripedBuffer.class, "tableBusy");
    static final long PROBE = UnsafeAccess.objectFieldOffset(Thread.class, "threadLocalRandomProbe");
    static final int NCPU = Runtime.getRuntime().availableProcessors();
    static final int MAXIMUM_TABLE_SIZE = 4 * Caffeine.ceilingPowerOfTwo(NCPU);
    static final int ATTEMPTS = 3;
    volatile transient Buffer<E> @Nullable [] table;
    volatile transient int tableBusy;

    StripedBuffer() {
    }

    final boolean casTableBusy() {
        return UnsafeAccess.UNSAFE.compareAndSwapInt(this, TABLE_BUSY, 0, 1);
    }

    static final int getProbe() {
        return UnsafeAccess.UNSAFE.getInt(Thread.currentThread(), PROBE);
    }

    static final int advanceProbe(int n) {
        n ^= n << 13;
        n ^= n >>> 17;
        n ^= n << 5;
        UnsafeAccess.UNSAFE.putInt(Thread.currentThread(), PROBE, n);
        return n;
    }

    protected abstract Buffer<E> create(E var1);

    @Override
    public int offer(E e) {
        Buffer<E> buffer;
        int n;
        int n2 = 0;
        boolean bl = true;
        Buffer<E>[] bufferArray = this.table;
        if (bufferArray == null || (n = bufferArray.length - 1) < 0 || (buffer = bufferArray[StripedBuffer.getProbe() & n]) == null || !(bl = (n2 = buffer.offer(e)) != -1)) {
            this.expandOrRetry(e, bl);
        }
        return n2;
    }

    @Override
    public void drainTo(Consumer<E> consumer) {
        Buffer<E>[] bufferArray = this.table;
        if (bufferArray == null) {
            return;
        }
        for (Buffer<E> buffer : bufferArray) {
            if (buffer == null) continue;
            buffer.drainTo(consumer);
        }
    }

    @Override
    public int reads() {
        Buffer<E>[] bufferArray = this.table;
        if (bufferArray == null) {
            return 0;
        }
        int n = 0;
        for (Buffer<E> buffer : bufferArray) {
            if (buffer == null) continue;
            n += buffer.reads();
        }
        return n;
    }

    @Override
    public int writes() {
        Buffer<E>[] bufferArray = this.table;
        if (bufferArray == null) {
            return 0;
        }
        int n = 0;
        for (Buffer<E> buffer : bufferArray) {
            if (buffer == null) continue;
            n += buffer.writes();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void expandOrRetry(E e, boolean bl) {
        int n = StripedBuffer.getProbe();
        if (n == 0) {
            ThreadLocalRandom.current();
            n = StripedBuffer.getProbe();
            bl = true;
        }
        boolean bl2 = false;
        for (int i = 0; i < 3; ++i) {
            Buffer[] bufferArray;
            boolean bl3;
            int n2;
            Buffer<E>[] bufferArray2 = this.table;
            if (this.table != null && (n2 = bufferArray2.length) > 0) {
                Buffer<E> buffer = bufferArray2[n2 - 1 & n];
                if (buffer == null) {
                    if (this.tableBusy == 0 && this.casTableBusy()) {
                        bl3 = false;
                        try {
                            int n3;
                            int n4;
                            bufferArray = this.table;
                            if (this.table != null && (n4 = bufferArray.length) > 0 && bufferArray[n3 = n4 - 1 & n] == null) {
                                bufferArray[n3] = this.create(e);
                                bl3 = true;
                            }
                        }
                        finally {
                            this.tableBusy = 0;
                        }
                        if (!bl3) continue;
                        break;
                    }
                    bl2 = false;
                } else if (!bl) {
                    bl = true;
                } else {
                    if (buffer.offer(e) != -1) break;
                    if (n2 >= MAXIMUM_TABLE_SIZE || this.table != bufferArray2) {
                        bl2 = false;
                    } else if (!bl2) {
                        bl2 = true;
                    } else if (this.tableBusy == 0 && this.casTableBusy()) {
                        try {
                            if (this.table == bufferArray2) {
                                this.table = Arrays.copyOf(bufferArray2, n2 << 1);
                            }
                        }
                        finally {
                            this.tableBusy = 0;
                        }
                        bl2 = false;
                        continue;
                    }
                }
                n = StripedBuffer.advanceProbe(n);
                continue;
            }
            if (this.tableBusy != 0 || this.table != bufferArray2 || !this.casTableBusy()) continue;
            bl3 = false;
            try {
                if (this.table == bufferArray2) {
                    bufferArray = new Buffer[]{this.create(e)};
                    this.table = bufferArray;
                    bl3 = true;
                }
            }
            finally {
                this.tableBusy = 0;
            }
            if (bl3) break;
        }
    }
}

