/*
 * Decompiled with CFR 0.152.
 */
package org.skills.utils.caffeine.cache;

import org.skills.utils.caffeine.cache.CacheLoader;
import org.skills.utils.caffeine.cache.Caffeine;
import org.skills.utils.caffeine.cache.Node;
import org.skills.utils.caffeine.cache.Pacer;
import org.skills.utils.caffeine.cache.SSMS;
import org.skills.utils.caffeine.cache.Scheduler;
import org.skills.utils.caffeine.cache.Ticker;
import org.skills.utils.caffeine.cache.WriteOrderDeque;

class SSMSW<K, V>
extends SSMS<K, V> {
    final Ticker ticker;
    final WriteOrderDeque<Node<K, V>> writeOrderDeque;
    volatile long expiresAfterWriteNanos;
    final Pacer pacer;

    SSMSW(Caffeine<K, V> caffeine, CacheLoader<? super K, V> cacheLoader, boolean bl) {
        super(caffeine, cacheLoader, bl);
        this.ticker = caffeine.getTicker();
        this.writeOrderDeque = new WriteOrderDeque();
        this.expiresAfterWriteNanos = caffeine.getExpiresAfterWriteNanos();
        this.pacer = caffeine.getScheduler() == Scheduler.disabledScheduler() ? null : new Pacer(caffeine.getScheduler());
    }

    @Override
    public final Ticker expirationTicker() {
        return this.ticker;
    }

    @Override
    protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
        return this.writeOrderDeque;
    }

    @Override
    protected final boolean expiresAfterWrite() {
        return true;
    }

    @Override
    protected final long expiresAfterWriteNanos() {
        return this.expiresAfterWriteNanos;
    }

    @Override
    protected final void setExpiresAfterWriteNanos(long l) {
        this.expiresAfterWriteNanos = l;
    }

    @Override
    public final Pacer pacer() {
        return this.pacer;
    }
}

