/*
 * Decompiled with CFR 0.152.
 */
package org.skills.utils.caffeine.cache;

import java.lang.ref.ReferenceQueue;
import java.util.Objects;
import org.skills.utils.caffeine.cache.Node;
import org.skills.utils.caffeine.cache.NodeFactory;
import org.skills.utils.caffeine.cache.UnsafeAccess;

class PS<K, V>
extends Node<K, V>
implements NodeFactory<K, V> {
    protected static final long KEY_OFFSET = UnsafeAccess.objectFieldOffset(PS.class, "key");
    protected static final long VALUE_OFFSET = UnsafeAccess.objectFieldOffset(PS.class, "value");
    volatile K key;
    volatile V value;

    PS() {
    }

    PS(K k, ReferenceQueue<K> referenceQueue, V v, ReferenceQueue<V> referenceQueue2, int n, long l) {
        this(k, v, referenceQueue2, n, l);
    }

    PS(Object object, V v, ReferenceQueue<V> referenceQueue, int n, long l) {
        UnsafeAccess.UNSAFE.putObject(this, KEY_OFFSET, object);
        UnsafeAccess.UNSAFE.putObject(this, VALUE_OFFSET, v);
    }

    @Override
    public final K getKey() {
        return (K)UnsafeAccess.UNSAFE.getObject(this, KEY_OFFSET);
    }

    @Override
    public final Object getKeyReference() {
        return UnsafeAccess.UNSAFE.getObject(this, KEY_OFFSET);
    }

    @Override
    public final V getValue() {
        return (V)UnsafeAccess.UNSAFE.getObject(this, VALUE_OFFSET);
    }

    @Override
    public final Object getValueReference() {
        return UnsafeAccess.UNSAFE.getObject(this, VALUE_OFFSET);
    }

    @Override
    public final void setValue(V v, ReferenceQueue<V> referenceQueue) {
        UnsafeAccess.UNSAFE.putObject(this, VALUE_OFFSET, v);
    }

    @Override
    public final boolean containsValue(Object object) {
        return Objects.equals(object, this.getValue());
    }

    @Override
    public Node<K, V> newNode(K k, ReferenceQueue<K> referenceQueue, V v, ReferenceQueue<V> referenceQueue2, int n, long l) {
        return new PS<K, V>(k, referenceQueue, v, referenceQueue2, n, l);
    }

    @Override
    public Node<K, V> newNode(Object object, V v, ReferenceQueue<V> referenceQueue, int n, long l) {
        return new PS<K, V>(object, v, referenceQueue, n, l);
    }

    @Override
    public final boolean isAlive() {
        Object object = this.getKeyReference();
        return object != RETIRED_STRONG_KEY && object != DEAD_STRONG_KEY;
    }

    @Override
    public final boolean isRetired() {
        return this.getKeyReference() == RETIRED_STRONG_KEY;
    }

    @Override
    public final void retire() {
        UnsafeAccess.UNSAFE.putObject(this, KEY_OFFSET, RETIRED_STRONG_KEY);
    }

    @Override
    public final boolean isDead() {
        return this.getKeyReference() == DEAD_STRONG_KEY;
    }

    @Override
    public final void die() {
        UnsafeAccess.UNSAFE.putObject(this, VALUE_OFFSET, null);
        UnsafeAccess.UNSAFE.putObject(this, KEY_OFFSET, DEAD_STRONG_KEY);
    }
}

