/*
 * Decompiled with CFR 0.152.
 */
package org.skills.utils.caffeine.cache;

import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.skills.utils.caffeine.cache.AsyncCacheLoader;
import org.skills.utils.caffeine.cache.AsyncLoadingCache;
import org.skills.utils.caffeine.cache.CacheLoader;
import org.skills.utils.caffeine.cache.LoadingCache;
import org.skills.utils.caffeine.cache.LocalAsyncCache;
import org.skills.utils.caffeine.cache.RemovalCause;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.Nullable;

abstract class LocalAsyncLoadingCache<K, V>
implements LocalAsyncCache<K, V>,
AsyncLoadingCache<K, V> {
    static final Logger logger = Logger.getLogger(LocalAsyncLoadingCache.class.getName());
    final boolean canBulkLoad;
    final AsyncCacheLoader<K, V> loader;
    @Nullable LoadingCacheView<K, V> cacheView;

    LocalAsyncLoadingCache(AsyncCacheLoader<? super K, V> asyncCacheLoader) {
        this.loader = asyncCacheLoader;
        this.canBulkLoad = LocalAsyncLoadingCache.canBulkLoad(asyncCacheLoader);
    }

    private static boolean canBulkLoad(AsyncCacheLoader<?, ?> asyncCacheLoader) {
        try {
            Method method;
            Method method2;
            Class<AsyncCacheLoader> clazz = AsyncCacheLoader.class;
            if (asyncCacheLoader instanceof CacheLoader) {
                clazz = CacheLoader.class;
                method2 = asyncCacheLoader.getClass().getMethod("loadAll", Iterable.class);
                if (!method2.equals(method = CacheLoader.class.getMethod("loadAll", Iterable.class))) {
                    return true;
                }
            }
            method2 = asyncCacheLoader.getClass().getMethod("asyncLoadAll", Iterable.class, Executor.class);
            method = clazz.getMethod("asyncLoadAll", Iterable.class, Executor.class);
            return !method2.equals(method);
        }
        catch (NoSuchMethodException | SecurityException exception) {
            logger.log(Level.WARNING, "Cannot determine if CacheLoader can bulk load", exception);
            return false;
        }
    }

    @Override
    public CompletableFuture<V> get(K k) {
        return this.get(k, this.loader::asyncLoad);
    }

    @Override
    public CompletableFuture<Map<K, V>> getAll(Iterable<? extends K> iterable) {
        if (this.canBulkLoad) {
            return this.getAll(iterable, this.loader::asyncLoadAll);
        }
        LinkedHashMap<Object, CompletableFuture> linkedHashMap = new LinkedHashMap<Object, CompletableFuture>();
        Function<Object, CompletableFuture> function = this::get;
        for (K k : iterable) {
            CompletableFuture completableFuture = linkedHashMap.computeIfAbsent(k, function);
            Objects.requireNonNull(completableFuture);
        }
        return this.composeResult(linkedHashMap);
    }

    @Override
    public LoadingCache<K, V> synchronous() {
        return this.cacheView == null ? (this.cacheView = new LoadingCacheView(this)) : this.cacheView;
    }

    static final class LoadingCacheView<K, V>
    extends LocalAsyncCache.AbstractCacheView<K, V>
    implements LoadingCache<K, V> {
        private static final long serialVersionUID = 1L;
        final LocalAsyncLoadingCache<K, V> asyncCache;

        LoadingCacheView(LocalAsyncLoadingCache<K, V> localAsyncLoadingCache) {
            this.asyncCache = Objects.requireNonNull(localAsyncLoadingCache);
        }

        @Override
        LocalAsyncLoadingCache<K, V> asyncCache() {
            return this.asyncCache;
        }

        @Override
        public V get(K k) {
            return LoadingCacheView.resolve(this.asyncCache.get(k));
        }

        @Override
        public Map<K, V> getAll(Iterable<? extends K> iterable) {
            return LoadingCacheView.resolve(this.asyncCache.getAll(iterable));
        }

        @Override
        public void refresh(K k) {
            CompletableFuture completableFuture;
            long[] lArray;
            block5: {
                block4: {
                    Objects.requireNonNull(k);
                    lArray = new long[1];
                    completableFuture = this.asyncCache.cache().getIfPresentQuietly(k, lArray);
                    if (completableFuture == null) break block4;
                    if (!completableFuture.isDone() || !completableFuture.isCompletedExceptionally()) break block5;
                }
                this.asyncCache.get(k, this.asyncCache.loader::asyncLoad, false);
                return;
            }
            if (!completableFuture.isDone()) {
                return;
            }
            completableFuture.thenAccept(object3 -> {
                long l = this.asyncCache.cache().statsTicker().read();
                CompletableFuture<Object> completableFuture2 = object3 == null ? this.asyncCache.loader.asyncLoad(k, this.asyncCache.cache().executor()) : this.asyncCache.loader.asyncReload(k, object3, this.asyncCache.cache().executor());
                completableFuture2.whenComplete((object2, throwable) -> {
                    long l2 = this.asyncCache.cache().statsTicker().read() - l;
                    if (throwable != null) {
                        this.asyncCache.cache().statsCounter().recordLoadFailure(l2);
                        logger.log(Level.WARNING, "Exception thrown during refresh", (Throwable)throwable);
                        return;
                    }
                    boolean[] blArray = new boolean[1];
                    this.asyncCache.cache().compute(k, (object3, completableFuture3) -> {
                        if (completableFuture3 == null) {
                            return object2 == null ? null : completableFuture2;
                        }
                        if (completableFuture3 == completableFuture) {
                            long l = lArray[0];
                            if (this.asyncCache.cache().hasWriteTime()) {
                                this.asyncCache.cache().getIfPresentQuietly(k, lArray);
                            }
                            if (lArray[0] == l) {
                                return object2 == null ? null : completableFuture2;
                            }
                        }
                        blArray[0] = true;
                        return completableFuture3;
                    }, false, false, true);
                    if (blArray[0] && this.asyncCache.cache().hasRemovalListener()) {
                        this.asyncCache.cache().notifyRemoval(k, completableFuture2, RemovalCause.REPLACED);
                    }
                    if (object2 == null) {
                        this.asyncCache.cache().statsCounter().recordLoadFailure(l2);
                    } else {
                        this.asyncCache.cache().statsCounter().recordLoadSuccess(l2);
                    }
                });
            });
        }
    }
}

