/*
 * Decompiled with CFR 0.152.
 */
package org.skills.utils.caffeine.cache;

import org.skills.utils.caffeine.cache.Caffeine;
import org.skills.utils.caffeine.checkerframework.checker.index.qual.NonNegative;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.NonNull;

final class FrequencySketch<E> {
    static final long[] SEED = new long[]{-4348849565147123417L, -5435081209227447693L, -7286425919675154353L, -3750763034362895579L};
    static final long RESET_MASK = 0x7777777777777777L;
    static final long ONE_MASK = 0x1111111111111111L;
    int sampleSize;
    int tableMask;
    long[] table;
    int size;

    public void ensureCapacity(@NonNegative long l) {
        Caffeine.requireArgument(l >= 0L);
        int n = (int)Math.min(l, 0x3FFFFFFFL);
        if (this.table != null && this.table.length >= n) {
            return;
        }
        this.table = new long[n == 0 ? 1 : Caffeine.ceilingPowerOfTwo(n)];
        this.tableMask = Math.max(0, this.table.length - 1);
        int n2 = this.sampleSize = l == 0L ? 10 : 10 * n;
        if (this.sampleSize <= 0) {
            this.sampleSize = Integer.MAX_VALUE;
        }
        this.size = 0;
    }

    public boolean isNotInitialized() {
        return this.table == null;
    }

    public @NonNegative int frequency(@NonNull E e) {
        if (this.isNotInitialized()) {
            return 0;
        }
        int n = this.spread(e.hashCode());
        int n2 = (n & 3) << 2;
        int n3 = Integer.MAX_VALUE;
        for (int i = 0; i < 4; ++i) {
            int n4 = this.indexOf(n, i);
            int n5 = (int)(this.table[n4] >>> (n2 + i << 2) & 0xFL);
            n3 = Math.min(n3, n5);
        }
        return n3;
    }

    public void increment(@NonNull E e) {
        if (this.isNotInitialized()) {
            return;
        }
        int n = this.spread(e.hashCode());
        int n2 = (n & 3) << 2;
        int n3 = this.indexOf(n, 0);
        int n4 = this.indexOf(n, 1);
        int n5 = this.indexOf(n, 2);
        int n6 = this.indexOf(n, 3);
        boolean bl = this.incrementAt(n3, n2);
        bl |= this.incrementAt(n4, n2 + 1);
        bl |= this.incrementAt(n5, n2 + 2);
        if ((bl |= this.incrementAt(n6, n2 + 3)) && ++this.size == this.sampleSize) {
            this.reset();
        }
    }

    boolean incrementAt(int n, int n2) {
        int n3 = n2 << 2;
        long l = 15L << n3;
        if ((this.table[n] & l) != l) {
            int n4 = n;
            this.table[n4] = this.table[n4] + (1L << n3);
            return true;
        }
        return false;
    }

    void reset() {
        int n = 0;
        for (int i = 0; i < this.table.length; ++i) {
            n += Long.bitCount(this.table[i] & 0x1111111111111111L);
            this.table[i] = this.table[i] >>> 1 & 0x7777777777777777L;
        }
        this.size = (this.size >>> 1) - (n >>> 2);
    }

    int indexOf(int n, int n2) {
        long l = ((long)n + SEED[n2]) * SEED[n2];
        l += l >>> 32;
        return (int)l & this.tableMask;
    }

    int spread(int n) {
        n = (n >>> 16 ^ n) * 73244475;
        n = (n >>> 16 ^ n) * 73244475;
        return n >>> 16 ^ n;
    }
}

