/*
 * Decompiled with CFR 0.152.
 */
package org.skills.utils.caffeine.cache;

import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.skills.utils.caffeine.cache.DisabledFuture;
import org.skills.utils.caffeine.cache.Scheduler;

final class ExecutorServiceScheduler
implements Scheduler,
Serializable {
    static final Logger logger = Logger.getLogger(ExecutorServiceScheduler.class.getName());
    static final long serialVersionUID = 1L;
    final ScheduledExecutorService scheduledExecutorService;

    ExecutorServiceScheduler(ScheduledExecutorService scheduledExecutorService) {
        this.scheduledExecutorService = Objects.requireNonNull(scheduledExecutorService);
    }

    @Override
    public Future<?> schedule(Executor executor, Runnable runnable, long l, TimeUnit timeUnit) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(runnable);
        Objects.requireNonNull(timeUnit);
        if (this.scheduledExecutorService.isShutdown()) {
            return DisabledFuture.INSTANCE;
        }
        return this.scheduledExecutorService.schedule(() -> {
            try {
                executor.execute(runnable);
            }
            catch (Throwable throwable) {
                logger.log(Level.WARNING, "Exception thrown when submitting scheduled task", throwable);
                throw throwable;
            }
        }, l, timeUnit);
    }
}

