/*
 * Decompiled with CFR 0.152.
 */
package org.skills.utils.caffeine.cache;

import java.io.Serializable;
import java.util.Objects;
import org.skills.utils.caffeine.cache.Caffeine;
import org.skills.utils.caffeine.cache.Weigher;

final class BoundedWeigher<K, V>
implements Weigher<K, V>,
Serializable {
    static final long serialVersionUID = 1L;
    final Weigher<? super K, ? super V> delegate;

    BoundedWeigher(Weigher<? super K, ? super V> weigher) {
        this.delegate = Objects.requireNonNull(weigher);
    }

    @Override
    public int weigh(K k, V v) {
        int n = this.delegate.weigh(k, v);
        Caffeine.requireArgument(n >= 0);
        return n;
    }

    Object writeReplace() {
        return this.delegate;
    }
}

