/*
 * Decompiled with CFR 0.152.
 */
package org.skills.utils.caffeine.cache;

import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import org.skills.utils.caffeine.cache.Expiry;
import org.skills.utils.caffeine.cache.RemovalCause;
import org.skills.utils.caffeine.cache.RemovalListener;
import org.skills.utils.caffeine.cache.Weigher;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.Nullable;

final class Async {
    static final long ASYNC_EXPIRY = 0x5FFFFFFFFFFFFFFEL;

    private Async() {
    }

    static boolean isReady(@Nullable CompletableFuture<?> completableFuture) {
        return completableFuture != null && completableFuture.isDone() && !completableFuture.isCompletedExceptionally() && completableFuture.join() != null;
    }

    static <V> @Nullable V getIfReady(@Nullable CompletableFuture<V> completableFuture) {
        return Async.isReady(completableFuture) ? (V)completableFuture.join() : null;
    }

    static <V> @Nullable V getWhenSuccessful(@Nullable CompletableFuture<V> completableFuture) {
        try {
            return completableFuture == null ? null : (V)completableFuture.join();
        }
        catch (CancellationException | CompletionException runtimeException) {
            return null;
        }
    }

    static final class AsyncExpiry<K, V>
    implements Expiry<K, CompletableFuture<V>>,
    Serializable {
        private static final long serialVersionUID = 1L;
        final Expiry<K, V> delegate;

        AsyncExpiry(Expiry<K, V> expiry) {
            this.delegate = Objects.requireNonNull(expiry);
        }

        @Override
        public long expireAfterCreate(K k, CompletableFuture<V> completableFuture, long l) {
            if (Async.isReady(completableFuture)) {
                long l2 = this.delegate.expireAfterCreate(k, completableFuture.join(), l);
                return Math.min(l2, 0x3FFFFFFFFFFFFFFFL);
            }
            return 0x5FFFFFFFFFFFFFFEL;
        }

        @Override
        public long expireAfterUpdate(K k, CompletableFuture<V> completableFuture, long l, long l2) {
            if (Async.isReady(completableFuture)) {
                long l3 = l2 > 0x3FFFFFFFFFFFFFFFL ? this.delegate.expireAfterCreate(k, completableFuture.join(), l) : this.delegate.expireAfterUpdate(k, completableFuture.join(), l, l2);
                return Math.min(l3, 0x3FFFFFFFFFFFFFFFL);
            }
            return 0x5FFFFFFFFFFFFFFEL;
        }

        @Override
        public long expireAfterRead(K k, CompletableFuture<V> completableFuture, long l, long l2) {
            if (Async.isReady(completableFuture)) {
                long l3 = this.delegate.expireAfterRead(k, completableFuture.join(), l, l2);
                return Math.min(l3, 0x3FFFFFFFFFFFFFFFL);
            }
            return 0x5FFFFFFFFFFFFFFEL;
        }

        Object writeReplace() {
            return this.delegate;
        }
    }

    static final class AsyncWeigher<K, V>
    implements Weigher<K, CompletableFuture<V>>,
    Serializable {
        private static final long serialVersionUID = 1L;
        final Weigher<K, V> delegate;

        AsyncWeigher(Weigher<K, V> weigher) {
            this.delegate = Objects.requireNonNull(weigher);
        }

        @Override
        public int weigh(K k, CompletableFuture<V> completableFuture) {
            return Async.isReady(completableFuture) ? this.delegate.weigh(k, completableFuture.join()) : 0;
        }

        Object writeReplace() {
            return this.delegate;
        }
    }

    static final class AsyncRemovalListener<K, V>
    implements RemovalListener<K, CompletableFuture<V>>,
    Serializable {
        private static final long serialVersionUID = 1L;
        final RemovalListener<K, V> delegate;
        final Executor executor;

        AsyncRemovalListener(RemovalListener<K, V> removalListener, Executor executor) {
            this.delegate = Objects.requireNonNull(removalListener);
            this.executor = Objects.requireNonNull(executor);
        }

        @Override
        public void onRemoval(@Nullable K k, @Nullable CompletableFuture<V> completableFuture, RemovalCause removalCause) {
            if (completableFuture != null) {
                completableFuture.thenAcceptAsync(object2 -> {
                    if (object2 != null) {
                        this.delegate.onRemoval(k, object2, removalCause);
                    }
                }, this.executor);
            }
        }

        Object writeReplace() {
            return this.delegate;
        }
    }
}

