/*
 * Decompiled with CFR 0.152.
 */
package org.skills.utils;

import com.google.common.base.Strings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.skills.main.locale.SkillsLang;

public class UpdateChecker
implements Listener {
    public final String currentVersion;
    private final String REQUEST_URL;
    private final String prefix;
    private final JavaPlugin plugin;
    private final int $RESOURCE_ID;
    private final File download;
    public int lastHttpResponseCode;
    public String latestVersion;
    public boolean canUpdate;

    public UpdateChecker(@Nonnull JavaPlugin javaPlugin, int n) {
        Objects.requireNonNull(javaPlugin, "Update checker plugin cannot be null");
        this.plugin = javaPlugin;
        this.prefix = SkillsLang.PREFIX.parse(new Object[0]);
        this.$RESOURCE_ID = n;
        this.download = new File(javaPlugin.getDataFolder(), javaPlugin.getName() + ".jar");
        this.currentVersion = javaPlugin.getDescription().getVersion();
        this.REQUEST_URL = "https://api.spigotmc.org/legacy/update.php?resource=" + n;
        if (javaPlugin.getConfig().getBoolean("check-updates")) {
            Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)javaPlugin);
        }
    }

    public static boolean isVersionHigher(@Nullable String string, @Nullable String string2) {
        if (Strings.isNullOrEmpty((String)string) || Strings.isNullOrEmpty((String)string2)) {
            return false;
        }
        if (string.equals(string2)) {
            return false;
        }
        string = StringUtils.remove((String)StringUtils.remove((String)StringUtils.remove((String)StringUtils.remove((String)StringUtils.deleteWhitespace((String)string.toLowerCase(Locale.ENGLISH)), (char)'v'), (char)'b'), (char)'-'), (String)"snapshot");
        string2 = StringUtils.remove((String)StringUtils.remove((String)StringUtils.remove((String)StringUtils.remove((String)StringUtils.deleteWhitespace((String)string2.toLowerCase(Locale.ENGLISH)), (char)'v'), (char)'b'), (char)'-'), (String)"snapshot");
        boolean bl = false;
        boolean bl2 = false;
        if (string.contains("beta")) {
            bl = true;
            string = StringUtils.remove((String)string, (String)"beta");
        }
        if (string2.contains("beta")) {
            bl2 = true;
            string2 = StringUtils.remove((String)string2, (String)"beta");
        }
        String[] stringArray = StringUtils.split((String)string, (char)'.');
        String[] stringArray2 = StringUtils.split((String)string2, (char)'.');
        int n = Math.max(stringArray.length, stringArray2.length);
        boolean bl3 = stringArray.length != stringArray2.length;
        for (int i = 0; i < n; ++i) {
            if (bl3 && i + 1 == n) {
                return n == stringArray2.length;
            }
            int n2 = Integer.parseInt(stringArray[i]);
            int n3 = Integer.parseInt(stringArray2[i]);
            if (n3 == n2) continue;
            if (n3 > n2) {
                if (bl2 && bl) {
                    return true;
                }
                return !bl2 || bl;
            }
            return false;
        }
        return false;
    }

    public int getLastHttpResponseCode() {
        return this.lastHttpResponseCode;
    }

    public CompletableFuture<String> checkForUpdates() {
        return this.getVersion().thenApply(string -> {
            this.latestVersion = string;
            this.canUpdate = UpdateChecker.isVersionHigher(this.currentVersion, string);
            return string;
        });
    }

    public boolean canUpdate() {
        return this.canUpdate;
    }

    public String getLatestVersion() {
        return this.latestVersion;
    }

    public void sendUpdates() {
        if (!this.plugin.getConfig().getBoolean("check-updates")) {
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            if (this.canUpdate) {
                this.sendMessages(this.updateText());
            } else if (this.latestVersion != null) {
                this.sendMessages("&2No updates found &7- &8(&6v" + this.currentVersion + "&8)");
            }
        });
    }

    @EventHandler
    public void onJoinNotify(PlayerJoinEvent playerJoinEvent) {
        if (!this.canUpdate) {
            return;
        }
        Player player = playerJoinEvent.getPlayer();
        if (player.hasPermission(this.plugin.getName().toLowerCase() + ".updates")) {
            this.sendMessages((CommandSender)player, this.updateText());
        }
    }

    private void sendMessages(@Nonnull String string) {
        this.sendMessages((CommandSender)Bukkit.getConsoleSender(), string);
    }

    private void sendMessages(@Nonnull CommandSender commandSender, @Nonnull String string) {
        String string2 = "";
        for (String string3 : StringUtils.splitPreserveAllTokens((String)string, (char)'\n')) {
            string3 = string2 + ChatColor.translateAlternateColorCodes((char)'&', (String)(this.prefix + string3));
            commandSender.sendMessage(string3);
            string2 = ChatColor.getLastColors((String)string3);
        }
    }

    public String updateText() {
        return "&8-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-\n  &2There is an update available!\n  &2Current Version&8: &6v" + this.currentVersion + "\n  &2Latest Version&8: &6v" + this.latestVersion + '\n' + "&8-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-";
    }

    public CompletableFuture<String> getVersion() {
        return CompletableFuture.supplyAsync(() -> {
            Object object;
            block15: {
                URL uRL = new URL(this.REQUEST_URL);
                HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
                httpURLConnection.setConnectTimeout(2000);
                httpURLConnection.setReadTimeout(2000);
                httpURLConnection.setDoOutput(true);
                this.sendMessages("&2Checking for updates...");
                this.lastHttpResponseCode = httpURLConnection.getResponseCode();
                InputStream inputStream = httpURLConnection.getResponseCode() == 200 ? httpURLConnection.getInputStream() : httpURLConnection.getErrorStream();
                try {
                    String string;
                    object = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
                    try {
                        string = ((BufferedReader)object).readLine();
                    }
                    finally {
                        ((BufferedReader)object).close();
                    }
                    Object object2 = object = string.isEmpty() ? null : string;
                    if (inputStream == null) break block15;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        this.sendMessages("&cFailed to check for updates&8: &e" + iOException.getMessage() + " (internet connection problems?)");
                        if (this.plugin.getConfig().getBoolean("debug")) {
                            iOException.printStackTrace();
                        }
                        return null;
                    }
                }
                inputStream.close();
            }
            return object;
        });
    }

    @Nonnull
    public CompletableFuture<Void> downloadUpdate() {
        return CompletableFuture.runAsync(() -> {
            try {
                URL uRL = new URL("http://api.spiget.org/v2/resources/" + this.$RESOURCE_ID + "/download/");
                ReadableByteChannel readableByteChannel = Channels.newChannel(uRL.openStream());
                FileOutputStream fileOutputStream = new FileOutputStream(this.download);
                FileChannel fileChannel = fileOutputStream.getChannel();
                fileChannel.transferFrom(readableByteChannel, 0L, Integer.MAX_VALUE);
                fileChannel.close();
                fileOutputStream.close();
                readableByteChannel.close();
                this.sendMessages("&2Successfully downloaded the plugin. Check the plugin folder.");
            }
            catch (IOException iOException) {
                this.sendMessages("&cFailed to download the plugin&8:");
                iOException.printStackTrace();
            }
        });
    }
}

