/*
 * Decompiled with CFR 0.152.
 */
package org.skills.utils;

import com.google.common.base.Enums;
import com.google.common.base.Strings;
import java.text.DecimalFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.skills.main.locale.LanguageManager;
import org.skills.main.locale.MessageHandler;
import org.skills.services.manager.ServiceHandler;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.NonNull;

public final class StringUtils
extends org.apache.commons.lang.StringUtils {
    private static final DateTimeFormatter FULL_DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy/MM/dd hh:mm:ss");
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("hh:mm:ss");
    private static final DecimalFormat NUMBER_FORMAT = new DecimalFormat("#,###.##");

    @Nullable
    public static String capitalize(@Nullable String string) {
        if (Strings.isNullOrEmpty((String)string)) {
            return string;
        }
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == ' ' || c == '_') {
                if (c != '_') {
                    stringBuilder.append(' ');
                }
                bl = true;
                continue;
            }
            if (bl) {
                stringBuilder.append(Character.toTitleCase(c));
                bl = false;
                continue;
            }
            stringBuilder.append(Character.toLowerCase(c));
        }
        return stringBuilder.toString();
    }

    public static String configOption(@Nullable Enum<?> enum_) {
        return StringUtils.configOption(enum_.name());
    }

    public static String configOption(@Nullable String string) {
        if (Strings.isNullOrEmpty((String)string)) {
            return string;
        }
        char[] cArray = string.toCharArray();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            cArray[i] = c == '_' ? 45 : (char)(c | 0x20);
        }
        return new String(cArray);
    }

    public static String toLatinLowerCase(@Nullable String string, char c, char c2) {
        if (Strings.isNullOrEmpty((String)string)) {
            return string;
        }
        char[] cArray = string.toCharArray();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c3 = cArray[i];
            cArray[i] = c3 == c ? c2 : (char)(c3 | 0x20);
        }
        return new String(cArray);
    }

    public static boolean isEnglish(@Nullable String string) {
        if (Strings.isNullOrEmpty((String)string)) {
            return true;
        }
        for (char c : string.toCharArray()) {
            if (c == '_' || c == ' ' || StringUtils.isEnglishLetterOrDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static void printStackTrace() {
        MessageHandler.sendConsolePluginMessage("&f--------------------------------------------");
        Arrays.stream(Thread.currentThread().getStackTrace()).skip(2L).forEach(stackTraceElement -> {
            String string = stackTraceElement.getClassName();
            String string2 = string.startsWith("net.minecraft") ? "&6" : (string.startsWith("org.bukkit") ? "&d" : (string.startsWith("co.aikar") || string.startsWith("io.papermc") || string.startsWith("com.destroystokyo") ? "&d" : (string.startsWith("java") ? "&c" : "&2")));
            MessageHandler.sendConsolePluginMessage(string2 + stackTraceElement.getClassName() + "&8.&9" + stackTraceElement.getMethodName() + "&8: &5" + stackTraceElement.getLineNumber());
        });
        MessageHandler.sendConsolePluginMessage("&f--------------------------------------------");
    }

    public static boolean hasSymbol(@Nullable String string) {
        if (Strings.isNullOrEmpty((String)string)) {
            return false;
        }
        for (char c : string.toCharArray()) {
            if (c == '_' || c == ' ' || Character.isLetterOrDigit(c)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEnglishLetter(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    public static boolean isEnglishDigit(char c) {
        return c >= '0' && c <= '9';
    }

    @Nonnull
    public static List<String> cleanSplit(@Nonnull String string, char c) {
        return StringUtils.split(StringUtils.deleteWhitespace(string), c, false);
    }

    @Nullable
    public static String deleteWhitespace(@Nullable String string) {
        if (Strings.isNullOrEmpty((String)string)) {
            return string;
        }
        int n = string.length();
        char[] cArray = new char[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == ' ') continue;
            cArray[n2++] = c;
        }
        if (n2 == n) {
            return string;
        }
        return new String(cArray, 0, n2);
    }

    @Nonnull
    public static List<String> split(@Nonnull String string, char c, boolean bl) {
        if (Strings.isNullOrEmpty((String)string)) {
            throw new IllegalArgumentException("Cannot split a null or empty string: " + string);
        }
        int n = string.length();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 0;
        int n3 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        while (n2 < n) {
            if (string.charAt(n2) == c) {
                if (bl2 || bl) {
                    arrayList.add(string.substring(n3, n2));
                    bl2 = false;
                    bl3 = true;
                }
                n3 = ++n2;
                continue;
            }
            bl3 = false;
            bl2 = true;
            ++n2;
        }
        if (bl2 || bl && bl3) {
            arrayList.add(string.substring(n3, n2));
        }
        return arrayList;
    }

    public static boolean isEnglishLetterOrDigit(char c) {
        return StringUtils.isEnglishDigit(c) || StringUtils.isEnglishLetter(c);
    }

    public static boolean containsNumber(@Nullable String string) {
        if (Strings.isNullOrEmpty((String)string)) {
            return false;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (!StringUtils.isEnglishDigit(c)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAnyLangNumber(@Nullable String string) {
        if (Strings.isNullOrEmpty((String)string)) {
            return false;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (!Character.isDigit(c)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNumeric(@Nullable String string) {
        if (Strings.isNullOrEmpty((String)string)) {
            return false;
        }
        int n = string.length();
        char c = string.charAt(0);
        int n2 = n != 1 && c == '-' || c == '+' ? 1 : 0;
        for (int i = n2; i < n; ++i) {
            char c2 = string.charAt(i);
            if (StringUtils.isEnglishDigit(c2)) continue;
            return false;
        }
        return true;
    }

    public static BossBar parseBossBarFromConfig(Player player, ConfigurationSection configurationSection) {
        String string = LanguageManager.buildMessage(configurationSection.getString("title"), (OfflinePlayer)player, new Object[0]);
        BarColor barColor = (BarColor)Enums.getIfPresent(BarColor.class, (String)configurationSection.getString("color").toUpperCase(Locale.ENGLISH)).orNull();
        BarStyle barStyle = (BarStyle)Enums.getIfPresent(BarStyle.class, (String)configurationSection.getString("style").toUpperCase(Locale.ENGLISH)).orNull();
        ArrayList<BarFlag> arrayList = new ArrayList<BarFlag>();
        for (String string2 : configurationSection.getStringList("flags")) {
            BarFlag barFlag = (BarFlag)Enums.getIfPresent(BarFlag.class, (String)string2.toUpperCase(Locale.ENGLISH)).orNull();
            if (barFlag == null) continue;
            arrayList.add(barFlag);
        }
        BossBar bossBar = Bukkit.createBossBar((String)string, (BarColor)barColor, (BarStyle)barStyle, (BarFlag[])arrayList.toArray(new BarFlag[0]));
        if (player != null) {
            bossBar.addPlayer(player);
        }
        return bossBar;
    }

    public static boolean isPureNumber(@Nullable String string) {
        if (Strings.isNullOrEmpty((String)string)) {
            return false;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (StringUtils.isEnglishDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static @NonNull String getGroupedOption(@NonNull String string, int ... nArray) {
        Objects.requireNonNull(string, "Enum option name cannot be null");
        String string2 = string.toLowerCase(Locale.ENGLISH);
        if (nArray.length == 0) {
            return string2.replace('_', '-');
        }
        String[] stringArray = StringUtils.split((String)string2, (char)'_');
        Validate.isTrue((stringArray.length >= nArray.length ? 1 : 0) != 0, (String)"Groups cannot be greater than enum separators");
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int n : nArray) {
            arrayList.add(n - 1);
        }
        Object object = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            ((StringBuilder)object).append(stringArray[i]);
            if (arrayList.contains(i)) {
                ((StringBuilder)object).append('.');
                continue;
            }
            ((StringBuilder)object).append('-');
        }
        ((StringBuilder)object).setLength(((StringBuilder)object).length() - 1);
        return ((StringBuilder)object).toString();
    }

    public static boolean isOneOf(@Nullable String string, String ... stringArray) {
        if (Strings.isNullOrEmpty((String)string)) {
            return false;
        }
        return Arrays.asList(stringArray).contains(string);
    }

    @Nonnull
    public static String toFancyNumber(double d) {
        return NUMBER_FORMAT.format(d);
    }

    public static @NonNull String getFullTime() {
        return LocalDateTime.now().format(FULL_DATE_FORMAT);
    }

    @Nonnull
    public static String getFullTime(long l) {
        return FULL_DATE_FORMAT.withZone(ZoneId.systemDefault()).format(Instant.ofEpochMilli(l));
    }

    public static @NonNull String getTime() {
        return LocalDateTime.now().format(DATE_FORMAT);
    }

    public static @NonNull String getDate(long l) {
        return DATE_FORMAT.withZone(ZoneId.systemDefault()).format(Instant.ofEpochMilli(l));
    }

    public static boolean containsAny(@Nullable String string, String ... stringArray) {
        if (Strings.isNullOrEmpty((String)string) || stringArray == null) {
            return false;
        }
        for (String string2 : stringArray) {
            if (!string.contains(string2)) continue;
            return true;
        }
        return false;
    }

    public static String buildArguments(@NonNull String[] stringArray, @NonNull String string, int n) {
        Objects.requireNonNull(stringArray, "Cannot build arguments for null argument list");
        Validate.isTrue((n >= 0 ? 1 : 0) != 0, (String)("Start index should be at least 0: " + n));
        Validate.isTrue((n < stringArray.length ? 1 : 0) != 0, (String)("Start index cannot be equal or greater than arguments length: " + n));
        return String.join((CharSequence)string, (CharSequence[])Arrays.stream(stringArray).skip(n).toArray(String[]::new));
    }

    public static void performCommands(Player player, List<String> list) {
        Objects.requireNonNull(player, "Cannot perform commands to a null player");
        if (list == null) {
            return;
        }
        for (String string : list) {
            int n = string.indexOf(58);
            if (n != -1) {
                String string2 = string.substring(0, n).toUpperCase(Locale.ENGLISH);
                string = string.substring(n + 1);
                ConsoleCommandSender consoleCommandSender = string2.equals("CONSOLE") ? Bukkit.getConsoleSender() : player;
                boolean bl = string2.equals("OP");
                if (bl) {
                    consoleCommandSender.setOp(true);
                }
                Bukkit.dispatchCommand((CommandSender)consoleCommandSender, (String)ServiceHandler.translatePlaceholders((OfflinePlayer)player, string));
                if (!bl) continue;
                consoleCommandSender.setOp(false);
                continue;
            }
            player.performCommand(ServiceHandler.translatePlaceholders((OfflinePlayer)player, string));
        }
    }

    public static String buildArguments(@NonNull String[] stringArray, @NonNull String string) {
        return StringUtils.buildArguments(stringArray, string, 0);
    }

    public static String buildArguments(@NonNull String[] stringArray, int n) {
        return StringUtils.buildArguments(stringArray, " ", n);
    }

    public static String buildArguments(@NonNull String[] stringArray) {
        return StringUtils.buildArguments(stringArray, " ", 0);
    }
}

