/*
 * Decompiled with CFR 0.152.
 */
package org.skills.utils;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.util.Vector;
import org.skills.utils.xseries.particles.ParticleDisplay;
import org.skills.utils.xseries.particles.XParticle;

public final class ParticleUtil {
    public static final ParticleDisplay SPAWN_DESPAWN_PARTICLE = ParticleDisplay.of(XParticle.CLOUD).withCount(50).offset(1.0, 1.0, 1.0);
    private static final Vector UP = new Vector(0, 1, 0);
    private static final double UP_ANGLE = 1.5707963267948966;
    public static final Map<String, double[]> VALUES = new HashMap<String, double[]>();

    public static boolean hasValue(String string) {
        return VALUES.containsKey(string);
    }

    public static double[] getValues(String string) {
        return VALUES.get(string);
    }

    public static Vector getPerpendicularVector(Vector vector) {
        Vector vector2 = new Vector(Math.cos(1.5707963267948966), Math.sin(1.5707963267948966), 0.0);
        return ParticleUtil.INTERNAL_CALL_LookRotation(vector, UP).mul(vector2);
    }

    public static ParticleDisplay.Quaternion INTERNAL_CALL_LookRotation(Vector vector, Vector vector2) {
        vector = vector.normalize();
        vector2 = vector2.clone();
        Vector vector3 = vector2.getCrossProduct(vector).normalize();
        vector2 = vector.getCrossProduct(vector3);
        double d = vector3.getX();
        double d2 = vector3.getY();
        double d3 = vector3.getZ();
        double d4 = vector2.getX();
        double d5 = vector2.getY();
        double d6 = vector2.getZ();
        double d7 = vector.getX();
        double d8 = vector.getY();
        double d9 = vector.getZ();
        double d10 = d + d5 + d9;
        if (d10 > 0.0) {
            double d11 = Math.sqrt(d10 + 1.0);
            double d12 = d11 * 0.5;
            d11 = 0.5 / d11;
            double d13 = (d6 - d8) * d11;
            double d14 = (d7 - d3) * d11;
            double d15 = (d2 - d4) * d11;
            return new ParticleDisplay.Quaternion(d12, d13, d14, d15);
        }
        if (d >= d5 && d >= d9) {
            double d16 = Math.sqrt(1.0 + d - d5 - d9);
            double d17 = 0.5 / d16;
            double d18 = 0.5 * d16;
            double d19 = (d2 + d4) * d17;
            double d20 = (d3 + d7) * d17;
            double d21 = (d6 - d8) * d17;
            return new ParticleDisplay.Quaternion(d21, d18, d19, d20);
        }
        if (d5 > d9) {
            double d22 = Math.sqrt(1.0 + d5 - d - d9);
            double d23 = 0.5 / d22;
            double d24 = (d4 + d2) * d23;
            double d25 = 0.5 * d22;
            double d26 = (d8 + d6) * d23;
            double d27 = (d7 - d3) * d23;
            return new ParticleDisplay.Quaternion(d27, d24, d25, d26);
        }
        double d28 = Math.sqrt(1.0 + d9 - d - d5);
        double d29 = 0.5 / d28;
        double d30 = (d7 + d3) * d29;
        double d31 = (d8 + d6) * d29;
        double d32 = 0.5 * d28;
        double d33 = (d2 - d4) * d29;
        return new ParticleDisplay.Quaternion(d33, d30, d31, d32);
    }

    public static void cloudParticle(Location location) {
        SPAWN_DESPAWN_PARTICLE.spawn(location);
    }

    public static final class Listen
    implements Listener {
        @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
        public void onChat(AsyncPlayerChatEvent asyncPlayerChatEvent) {
            String string2 = asyncPlayerChatEvent.getMessage().toLowerCase(Locale.ENGLISH).replace(" ", "");
            String[] stringArray = string2.split(",");
            String string3 = stringArray[0];
            if (string3.startsWith("-")) {
                if (VALUES.remove(string3.substring(1)) != null) {
                    asyncPlayerChatEvent.getPlayer().sendMessage("removed " + string3.substring(1));
                }
                return;
            }
            VALUES.put(string3, Arrays.stream(stringArray).skip(1L).mapToDouble(string -> {
                boolean bl = false;
                if (string.startsWith("r")) {
                    bl = true;
                    string = string.substring(1);
                }
                double d = Double.parseDouble(string);
                if (bl) {
                    d = Math.toRadians(d);
                }
                return d;
            }).toArray());
        }
    }
}

