/*
 * Decompiled with CFR 0.152.
 */
package org.skills.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.skills.main.SkillsConfig;
import org.skills.main.locale.MessageHandler;
import org.skills.utils.FastUUID;
import org.skills.utils.xseries.reflection.XReflection;
import org.skills.utils.xseries.reflection.jvm.MethodMemberHandle;
import org.skills.utils.xseries.reflection.minecraft.MinecraftClassHandle;
import org.skills.utils.xseries.reflection.minecraft.MinecraftMapping;
import org.skills.utils.xseries.reflection.minecraft.MinecraftPackage;

public final class OfflineNBT {
    private static final MethodHandle GET_COMPOUND;
    private static final MethodHandle SET_FLOAT;
    private static final MethodHandle GET_FLOAT;
    private static final MethodHandle SET_BOOLEAN;
    private static final MethodHandle GET_BOOLEAN;
    private static final MethodHandle SAVE;
    private static final MethodHandle LOAD;
    private static final boolean EMERGENCY;
    private UUID player;
    private File file;
    private Object compound;
    private Object abilities;

    public OfflineNBT(UUID uUID) {
        try {
            this.player = uUID;
            this.file = new File(((World)Bukkit.getWorlds().get(0)).getWorldFolder(), "playerdata" + File.separator + this.player + ".dat");
            this.abilities = GET_COMPOUND.invoke(this.compound, "abilities");
            if (this.file.exists()) {
                this.compound = LOAD.invoke(new FileInputStream(this.file));
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void perform() {
        if (EMERGENCY) {
            MessageHandler.sendConsolePluginMessage("&cThere has been an error while getting ready to modify players data.");
            MessageHandler.sendConsolePluginMessage("&cPlease find the error from the logs above and report it.");
            return;
        }
        if (SkillsConfig.ARMOR_WEIGHTS_ENABLED.getBoolean()) {
            MessageHandler.sendConsolePluginMessage("&4Cannot reset players speed when armor weights option is on.");
            MessageHandler.sendConsolePluginMessage("&4You do not need to reset players data with this option on, the speeds");
            MessageHandler.sendConsolePluginMessage("&4will be automatically adjusted.");
            return;
        }
        float f = (float)SkillsConfig.ARMOR_WEIGHTS_RESET_SPEEDS_AMOUNT.getDouble();
        MessageHandler.sendConsolePluginMessage("&2Starting to reset players speed to " + f + "...");
        CompletableFuture.runAsync(() -> {
            for (World world : Bukkit.getWorlds()) {
                File[] fileArray;
                for (File file : fileArray = new File(world.getWorldFolder(), "playerdata").listFiles()) {
                    String string = file.getName();
                    int n = string.lastIndexOf(46);
                    if (n != -1) {
                        string = string.substring(0, n);
                    }
                    MessageHandler.sendConsolePluginMessage("&2Reseting player speed in &e" + world.getName() + "&8: &e" + string);
                    UUID uUID = FastUUID.fromString(string);
                    OfflineNBT offlineNBT = new OfflineNBT(uUID);
                    offlineNBT.setWalkSpeed(f);
                    offlineNBT.savePlayerData();
                }
            }
        }).exceptionally(throwable -> {
            throwable.printStackTrace();
            return null;
        });
    }

    public void savePlayerData() {
        try {
            SAVE.invoke(this.compound, new FileOutputStream(this.file));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public float getWalkSpeed() {
        try {
            return GET_FLOAT.invoke(this.abilities, "walkSpeed");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0.0f;
        }
    }

    public void setWalkSpeed(float f) {
        try {
            SET_FLOAT.invoke(this.abilities, "walkSpeed", f);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public float getFlySpeed() {
        try {
            return GET_FLOAT.invoke(this.abilities, "flySpeed");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0.0f;
        }
    }

    public void setFlySpeed(float f) {
        try {
            SET_FLOAT.invoke(this.abilities, "flySpeed", f);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public boolean getAllowFlight() {
        try {
            return GET_BOOLEAN.invoke(this.abilities, "mayFly");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    public void setAllowFlight(boolean bl) {
        try {
            SET_BOOLEAN.invoke(this.abilities, "mayFly", bl);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public boolean isFlying() {
        try {
            return GET_BOOLEAN.invoke(this.abilities, "flying");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    public void setFlying(boolean bl) {
        try {
            SET_BOOLEAN.invoke(this.abilities, "flying", bl);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    static {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        MinecraftClassHandle minecraftClassHandle = XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "nbt").map(MinecraftMapping.MOJANG, "NbtIo").map(MinecraftMapping.SPIGOT, "NBTCompressedStreamTools");
        Class clazz = (Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "nbt").map(MinecraftMapping.MOJANG, "CompoundTag").map(MinecraftMapping.SPIGOT, "NBTTagCompound").unreflect();
        MethodHandle methodHandle = null;
        MethodHandle methodHandle2 = null;
        MethodHandle methodHandle3 = null;
        MethodHandle methodHandle4 = null;
        MethodHandle methodHandle5 = null;
        MethodHandle methodHandle6 = null;
        MethodHandle methodHandle7 = null;
        boolean bl = false;
        try {
            methodHandle = lookup.findVirtual(clazz, "getCompound", MethodType.methodType(clazz, String.class));
            methodHandle2 = lookup.findVirtual(clazz, "setFloat", MethodType.methodType(Void.TYPE, String.class, Float.TYPE));
            methodHandle3 = lookup.findVirtual(clazz, "getFloat", MethodType.methodType(Float.TYPE, String.class));
            methodHandle4 = lookup.findVirtual(clazz, "setBoolean", MethodType.methodType(Void.TYPE, String.class, Boolean.TYPE));
            methodHandle5 = lookup.findVirtual(clazz, "getBoolean", MethodType.methodType(Boolean.TYPE, String.class));
            methodHandle6 = (MethodHandle)((MethodMemberHandle)minecraftClassHandle.method().asStatic().returns((Class)Void.TYPE)).parameters(clazz, OutputStream.class).map(MinecraftMapping.OBFUSCATED, "a").map(MinecraftMapping.MOJANG, "writeCompressed").unreflect();
            methodHandle7 = (MethodHandle)((MethodMemberHandle)minecraftClassHandle.method().asStatic().returns(clazz)).parameters(InputStream.class).map(MinecraftMapping.OBFUSCATED, "a").map(MinecraftMapping.MOJANG, "createDecompressorStream").unreflect();
        }
        catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            reflectiveOperationException.printStackTrace();
            bl = true;
        }
        GET_COMPOUND = methodHandle;
        SET_FLOAT = methodHandle2;
        GET_FLOAT = methodHandle3;
        SET_BOOLEAN = methodHandle4;
        GET_BOOLEAN = methodHandle5;
        SAVE = methodHandle6;
        LOAD = methodHandle7;
        EMERGENCY = bl;
    }
}

