/*
 * Decompiled with CFR 0.152.
 */
package org.skills.utils;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.Navigator;
import net.citizensnpcs.api.ai.NavigatorParameters;
import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.event.NPCDespawnEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.trait.Equipment;
import net.citizensnpcs.api.trait.trait.Inventory;
import net.citizensnpcs.api.trait.trait.Owner;
import net.citizensnpcs.trait.RotationTrait;
import net.citizensnpcs.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.mcmonkey.sentinel.SentinelTrait;
import org.skills.main.SkillsPro;
import org.skills.managers.DamageManager;
import org.skills.utils.LocationUtils;
import org.skills.utils.xseries.particles.ParticleDisplay;
import org.skills.utils.xseries.particles.XParticle;

public class NPCHandler {
    private static final String METADATA = "DOPPELGANGER";
    private static final Map<UUID, UUID> DOPPEL = new HashMap<UUID, UUID>();
    private static final Map<EquipmentSlot, Equipment.EquipmentSlot> SLOT_MAPPING = new EnumMap<EquipmentSlot, Equipment.EquipmentSlot>(EquipmentSlot.class);

    private static void attack(NPC nPC, LivingEntity livingEntity) {
        SentinelTrait sentinelTrait = (SentinelTrait)nPC.getOrAddTrait(SentinelTrait.class);
        sentinelTrait.attackHelper.chase(livingEntity);
        sentinelTrait.attackHelper.tryAttack(livingEntity);
    }

    public static NPC getDoppel(Player player) {
        UUID uUID = DOPPEL.get(player.getUniqueId());
        if (uUID == null) {
            return null;
        }
        return CitizensAPI.getNPCRegistry().getByUniqueId(uUID);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onDoppelDespawn(NPCDespawnEvent nPCDespawnEvent) {
        if (nPCDespawnEvent.getReason() == DespawnReason.PENDING_RESPAWN) {
            return;
        }
        Owner owner = (Owner)nPCDespawnEvent.getNPC().getOrAddTrait(Owner.class);
        if (owner != null && owner.getOwnerId() != null) {
            DOPPEL.remove(owner.getOwnerId());
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onHit(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        LivingEntity livingEntity = DamageManager.getDamager(entityDamageByEntityEvent);
        NPC nPC = CitizensAPI.getNPCRegistry().getNPC(entityDamageByEntityEvent.getEntity());
        if (nPC != null && livingEntity.getType() != EntityType.PLAYER) {
            NPCHandler.attack(nPC, livingEntity);
            return;
        }
        if (livingEntity instanceof Player && entityDamageByEntityEvent.getEntity() instanceof LivingEntity) {
            nPC = NPCHandler.getDoppel((Player)livingEntity);
            if (nPC != null) {
                NPCHandler.attack(nPC, (LivingEntity)entityDamageByEntityEvent.getEntity());
            }
        } else if (entityDamageByEntityEvent.getEntity() instanceof Player && livingEntity != null && (nPC = NPCHandler.getDoppel((Player)entityDamageByEntityEvent.getEntity())) != null) {
            NPCHandler.attack(nPC, livingEntity);
        }
    }

    public static void spawnNPC(final Player player, LivingEntity livingEntity) {
        final NPC nPC = CitizensAPI.getNPCRegistry().createNPC(EntityType.PLAYER, player.getName());
        Inventory inventory = (Inventory)nPC.getOrAddTrait(Inventory.class);
        inventory.setContents(player.getInventory().getContents());
        Equipment equipment = (Equipment)nPC.getOrAddTrait(Equipment.class);
        for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
            ItemStack itemStack = player.getInventory().getItem(equipmentSlot);
            if (itemStack == null) continue;
            equipment.set(SLOT_MAPPING.get(equipmentSlot), itemStack);
        }
        equipment.run();
        Owner owner = (Owner)nPC.getOrAddTrait(Owner.class);
        owner.setOwner((CommandSender)player);
        NavigatorParameters navigatorParameters = nPC.getNavigator().getDefaultParameters();
        navigatorParameters.distanceMargin(5.0);
        nPC.spawn(player.getLocation());
        nPC.getEntity().setMetadata(METADATA, (MetadataValue)new FixedMetadataValue((Plugin)SkillsPro.get(), (Object)player.getUniqueId()));
        final SentinelTrait sentinelTrait = (SentinelTrait)nPC.getOrAddTrait(SentinelTrait.class);
        sentinelTrait.respawnTime = -1L;
        sentinelTrait.damage = 5.0;
        sentinelTrait.attackRate = 20;
        sentinelTrait.healRate = 0;
        sentinelTrait.realistic = true;
        NPCHandler.attack(nPC, livingEntity);
        new BukkitRunnable(){

            public void run() {
                if (!DOPPEL.containsKey(player.getUniqueId())) {
                    this.cancel();
                    return;
                }
                if (sentinelTrait.chasing != null || !sentinelTrait.targetingHelper.currentTargets.isEmpty()) {
                    return;
                }
                Navigator navigator = nPC.getNavigator();
                if (navigator.isNavigating()) {
                    return;
                }
                double d = LocationUtils.distanceSquared(nPC.getEntity().getLocation(), player.getLocation());
                if (d > 5.0) {
                    navigator.getDefaultParameters().speedModifier(d > 40.0 ? 2.0f : 1.0f);
                    navigator.setTarget(player.getLocation().clone());
                } else {
                    double d2 = -45.0;
                    double d3 = 45.0;
                    double d4 = 0.0;
                    double d5 = 360.0;
                    float f = Util.getFastRandom().doubles(d2, d3).iterator().next().floatValue();
                    float f2 = Util.getFastRandom().doubles(d4, d5).iterator().next().floatValue();
                    ((RotationTrait)nPC.getOrAddTrait(RotationTrait.class)).getPhysicalSession().rotateToHave(f2, f);
                }
            }
        }.runTaskTimer((Plugin)SkillsPro.get(), 0L, 40L);
        DOPPEL.put(player.getUniqueId(), nPC.getUniqueId());
        Bukkit.getScheduler().runTaskLater((Plugin)SkillsPro.get(), () -> {
            if (!nPC.isSpawned()) {
                return;
            }
            ParticleDisplay.of(XParticle.CLOUD).offset(1.0).spawn(nPC.getEntity().getLocation());
            nPC.despawn(DespawnReason.PLUGIN);
        }, 1200L);
    }

    static {
        SLOT_MAPPING.put(EquipmentSlot.HEAD, Equipment.EquipmentSlot.HELMET);
        SLOT_MAPPING.put(EquipmentSlot.CHEST, Equipment.EquipmentSlot.CHESTPLATE);
        SLOT_MAPPING.put(EquipmentSlot.LEGS, Equipment.EquipmentSlot.LEGGINGS);
        SLOT_MAPPING.put(EquipmentSlot.FEET, Equipment.EquipmentSlot.BOOTS);
        SLOT_MAPPING.put(EquipmentSlot.HAND, Equipment.EquipmentSlot.HAND);
        SLOT_MAPPING.put(EquipmentSlot.OFF_HAND, Equipment.EquipmentSlot.OFF_HAND);
    }
}

