/*
 * Decompiled with CFR 0.152.
 */
package org.skills.utils;

import com.google.common.base.Strings;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.skills.utils.MathEval;
import org.skills.utils.StringUtils;

public class MathUtils {
    private static final DecimalFormat SHORT_DOUBLE = new DecimalFormat("#");
    private static final Pattern TIME_PATTERN = Pattern.compile("(\\d+)(\\S*)");

    public static double evaluateEquation(String string) {
        return MathEval.evaluate(string);
    }

    public static boolean isInteger(double d) {
        return d % 1.0 == 0.0;
    }

    public static Long calcMillis(String string, TimeUnit timeUnit) {
        long l;
        if (Strings.isNullOrEmpty((String)string)) {
            return null;
        }
        Matcher matcher = TIME_PATTERN.matcher(string = StringUtils.deleteWhitespace(string).toLowerCase(Locale.ENGLISH));
        if (!matcher.matches()) {
            return null;
        }
        if (matcher.groupCount() > 1) {
            String string2 = matcher.group(2);
            if (string2.length() > 8) {
                return null;
            }
            if (StringUtils.isOneOf(string2, "d", "day", "days")) {
                timeUnit = TimeUnit.DAYS;
            } else if (StringUtils.isOneOf(string2, "h", "hr", "hrs", "hour", "hours")) {
                timeUnit = TimeUnit.HOURS;
            } else if (StringUtils.isOneOf(string2, "m", "min", "mins", "minute", "minutes")) {
                timeUnit = TimeUnit.MINUTES;
            } else if (StringUtils.isOneOf(string2, "s", "sec", "secs", "second", "seconds")) {
                timeUnit = TimeUnit.SECONDS;
            }
        }
        if ((l = Long.parseUnsignedLong(matcher.group(1))) < 1L) {
            return 0L;
        }
        return timeUnit.toMillis(l);
    }

    public static boolean hasChance(int n) {
        return MathUtils.hasChance(n, 100);
    }

    public static boolean hasChance(int n, int n2) {
        return MathUtils.randInt(0, n2) <= n;
    }

    public static int randInt(int n, int n2) {
        return ThreadLocalRandom.current().nextInt(n, n2 + 1);
    }

    public static double rand(double d, double d2) {
        return ThreadLocalRandom.current().nextDouble(d, d2 + 1.0);
    }

    public static double getPercent(double d, double d2) {
        return MathUtils.getAmountFromAmount(d, d2, 100.0);
    }

    public static double getAmountFromAmount(double d, double d2, double d3) {
        return d / d2 * d3;
    }

    public static double percentOfAmount(double d, double d2) {
        return d2 * d / 100.0;
    }

    public static double percentOfComplexAmount(double d, double d2, double d3) {
        return d2 * d / d3;
    }

    public static Double getIfNumber(String string) {
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static double roundToDigits(double d, int n) {
        if (n <= 0) {
            return Math.round(d);
        }
        double d2 = Math.pow(10.0, n);
        return (double)Math.round(d * d2) / d2;
    }

    public static String getShortNumber(double d) {
        double d2 = 1.0E15;
        double d3 = 1.0E12;
        double d4 = 1.0E9;
        double d5 = 1000000.0;
        double d6 = 1000.0;
        if (d < d6) {
            return String.valueOf(d);
        }
        if (d >= d2) {
            return MathUtils.createShortNumber(d) + 'Q';
        }
        if (d >= d3) {
            return MathUtils.createShortNumber(d) + 'T';
        }
        if (d >= d4) {
            return MathUtils.createShortNumber(d) + 'B';
        }
        if (d >= d5) {
            return MathUtils.createShortNumber(d) + 'M';
        }
        return MathUtils.createShortNumber(d) + 'K';
    }

    private static String createShortNumber(double d) {
        String string = SHORT_DOUBLE.format(d);
        int n = string.length() % 3;
        if (n == 0) {
            n = 3;
        }
        return string.substring(0, n) + '.' + string.charAt(n);
    }

    public static int increasingRandInt(int n, int n2) {
        int n3;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (n3 = n; n3 < n2; ++n3) {
            for (int i = n3; i >= 0; --i) {
                arrayList.add(i);
            }
        }
        n3 = MathUtils.randInt(0, arrayList.size() - 1);
        return (Integer)arrayList.get(n3);
    }

    public static int decreasingRandInt(int n, int n2) {
        int n3;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (n3 = n; n3 < n2; ++n3) {
            for (int i = n2 - n3 + 1; i >= 0; --i) {
                arrayList.add(n3);
            }
        }
        n3 = MathUtils.randInt(0, arrayList.size() - 1);
        return (Integer)arrayList.get(n3);
    }

    public static boolean isEven(long l) {
        return (l & 1L) == 0L;
    }

    public static boolean isPrime(long l) {
        if (l > 2L && MathUtils.isEven(l)) {
            return false;
        }
        int n = 3;
        while ((long)n * (long)n <= l) {
            if (l % (long)n == 0L) {
                return false;
            }
            n += 2;
        }
        return true;
    }
}

