/*
 * Decompiled with CFR 0.152.
 */
package org.skills.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;

public final class MathEval {
    private static final Map<String, Double> CONSTANTS = new HashMap<String, Double>(8);
    private static final Map<String, QuantumFunction> FUNCTIONS = new HashMap<String, QuantumFunction>(44);
    private static final Operator[] OPERATORS = new Operator[127];
    private static final Operator OPERAND = new Operator('\u0000', 0, 0, Side.NONE, null);
    private static final Operator OPERATOR_EQUAL = new Operator('=', 127, 127, Side.RIGHT, (d, d2) -> d2);
    private final String expression;
    private int offset;

    private MathEval(String string) {
        this.expression = string;
    }

    public static void setOperator(Operator operator) {
        if (operator.symbol >= OPERATORS.length) {
            throw new IllegalArgumentException("Operator handler cannot handle char '" + operator.symbol + "' with char code: " + operator.symbol);
        }
        MathEval.OPERATORS[((Operator)operator).symbol] = operator;
    }

    private static void validateName(String string) {
        char c = string.charAt(0);
        if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z')) {
            throw new IllegalArgumentException("Names for constants, variables and functions must start with a letter");
        }
        if (string.indexOf(40) != -1 || string.indexOf(41) != -1) {
            throw new IllegalArgumentException("Names for constants, variables and functions may not contain a parenthesis");
        }
    }

    private static void registerConstants() {
        CONSTANTS.put("E", Math.E);
        CONSTANTS.put("Euler", 0.5772156649015329);
        CONSTANTS.put("LN2", 0.693147180559945);
        CONSTANTS.put("LN10", 2.302585092994046);
        CONSTANTS.put("LOG2E", 1.442695040888963);
        CONSTANTS.put("LOG10E", 0.434294481903252);
        CONSTANTS.put("PHI", 1.618033988749895);
        CONSTANTS.put("PI", Math.PI);
    }

    private static void registerOperators() {
        MathEval.setOperator(OPERATOR_EQUAL);
        MathEval.setOperator(new Operator('^', 12, 13, Side.NONE, Math::pow));
        MathEval.setOperator(new Operator('*', 10, (d, d2) -> d * d2));
        MathEval.setOperator(new Operator('(', 10, (d, d2) -> d * d2));
        MathEval.setOperator(new Operator('/', 10, (d, d2) -> d / d2));
        MathEval.setOperator(new Operator('%', 10, (d, d2) -> d % d2));
        MathEval.setOperator(new Operator('+', 9, Double::sum));
        MathEval.setOperator(new Operator('-', 9, (d, d2) -> d - d2));
        MathEval.setOperator(new Operator('~', 10, (d, d2) -> (long)d2 ^ 0xFFFFFFFFFFFFFFFFL));
        MathEval.setOperator(new Operator('@', 8, (d, d2) -> Long.rotateLeft((long)d, (int)d2)));
        MathEval.setOperator(new Operator('#', 8, (d, d2) -> Long.rotateRight((long)d, (int)d2)));
        MathEval.setOperator(new Operator('>', 8, (d, d2) -> (long)d >> (int)d2));
        MathEval.setOperator(new Operator('<', 8, (d, d2) -> (long)d << (int)d2));
        MathEval.setOperator(new Operator('$', 8, (d, d2) -> (long)d >>> (int)d2));
        MathEval.setOperator(new Operator('&', 7, (d, d2) -> (long)d & (long)d2));
        MathEval.setOperator(new Operator('!', 6, (d, d2) -> (long)d ^ (long)d2));
        MathEval.setOperator(new Operator('|', 5, (d, d2) -> (long)d | (long)d2));
    }

    private static void registerFunctions() {
        FUNCTIONS.put("abs", argParser -> Math.abs(argParser.next()));
        FUNCTIONS.put("acos", argParser -> Math.acos(argParser.next()));
        FUNCTIONS.put("asin", argParser -> Math.asin(argParser.next()));
        FUNCTIONS.put("atan", argParser -> Math.atan(argParser.next()));
        FUNCTIONS.put("cbrt", argParser -> Math.cbrt(argParser.next()));
        FUNCTIONS.put("ceil", argParser -> Math.ceil(argParser.next()));
        FUNCTIONS.put("cos", argParser -> Math.cos(argParser.next()));
        FUNCTIONS.put("cosh", argParser -> Math.cosh(argParser.next()));
        FUNCTIONS.put("exp", argParser -> Math.exp(argParser.next()));
        FUNCTIONS.put("expm1", argParser -> Math.expm1(argParser.next()));
        FUNCTIONS.put("floor", argParser -> Math.floor(argParser.next()));
        FUNCTIONS.put("getExponent", argParser -> Math.getExponent(argParser.next()));
        FUNCTIONS.put("log", argParser -> Math.log(argParser.next()));
        FUNCTIONS.put("log10", argParser -> Math.log10(argParser.next()));
        FUNCTIONS.put("log1p", argParser -> Math.log1p(argParser.next()));
        FUNCTIONS.put("max", argParser -> {
            double d;
            double d2 = argParser.next();
            return d2 >= (d = argParser.next()) ? d2 : d;
        });
        FUNCTIONS.put("min", argParser -> {
            double d;
            double d2 = argParser.next();
            return d2 <= (d = argParser.next()) ? d2 : d;
        });
        FUNCTIONS.put("nextUp", argParser -> Math.nextUp(argParser.next()));
        FUNCTIONS.put("nextDown", argParser -> Math.nextDown(argParser.next()));
        FUNCTIONS.put("nextAfter", argParser -> Math.nextAfter(argParser.next(), argParser.next()));
        FUNCTIONS.put("random", argParser -> ThreadLocalRandom.current().nextDouble(argParser.next(), argParser.next() + 1.0));
        FUNCTIONS.put("randInt", argParser -> ThreadLocalRandom.current().nextInt((int)argParser.next(), (int)argParser.next() + 1));
        FUNCTIONS.put("round", argParser -> Math.round(argParser.next()));
        FUNCTIONS.put("rint", argParser -> Math.rint(argParser.next()));
        FUNCTIONS.put("signum", argParser -> Math.signum(argParser.next()));
        FUNCTIONS.put("whatPercentOf", argParser -> argParser.next() / argParser.next() * 100.0);
        FUNCTIONS.put("percentOf", argParser -> argParser.next() / 100.0 * argParser.next());
        FUNCTIONS.put("sin", argParser -> Math.sin(argParser.next()));
        FUNCTIONS.put("sinh", argParser -> Math.sinh(argParser.next()));
        FUNCTIONS.put("bits", argParser -> Double.doubleToRawLongBits(argParser.next()));
        FUNCTIONS.put("hash", argParser -> Double.hashCode(argParser.next()));
        FUNCTIONS.put("identityHash", argParser -> System.identityHashCode(argParser.next()));
        FUNCTIONS.put("time", argParser -> System.currentTimeMillis());
        FUNCTIONS.put("sqrt", argParser -> Math.sqrt(argParser.next()));
        FUNCTIONS.put("tan", argParser -> Math.tan(argParser.next()));
        FUNCTIONS.put("tanh", argParser -> Math.tanh(argParser.next()));
        FUNCTIONS.put("toDegrees", argParser -> Math.toDegrees(argParser.next()));
        FUNCTIONS.put("toRadians", argParser -> Math.toRadians(argParser.next()));
        FUNCTIONS.put("ulp", argParser -> Math.ulp(argParser.next()));
        FUNCTIONS.put("scalb", argParser -> Math.scalb(argParser.next(), (int)argParser.next()));
        FUNCTIONS.put("hypot", argParser -> Math.hypot(argParser.next(), argParser.next()));
        FUNCTIONS.put("copySign", argParser -> Math.copySign(argParser.next(), argParser.next()));
        FUNCTIONS.put("IEEEremainder", argParser -> Math.IEEEremainder(argParser.next(), argParser.next()));
        FUNCTIONS.put("naturalSum", argParser -> {
            int n = (int)argParser.next();
            return (double)(n * (n + 1)) / 2.0;
        });
        FUNCTIONS.put("reverse", argParser -> Long.reverse((long)argParser.next()));
        FUNCTIONS.put("reverseBytes", argParser -> Long.reverseBytes((long)argParser.next()));
    }

    public static double evaluate(String string) {
        return new MathEval(string).evaluate(0, string.length() - 1);
    }

    private static Operator getOperator(char c) {
        if (c >= OPERATORS.length) {
            return OPERAND;
        }
        Operator operator = OPERATORS[c];
        return operator == null ? OPERAND : operator;
    }

    private static boolean isHexDecimal(String string, int n) {
        return string.length() > n + 2 && string.charAt(n) == '0' && string.charAt(n + 1) == 'x';
    }

    private static int skipWhitespace(String string, int n, int n2) {
        while (n <= n2 && string.charAt(n) == ' ') {
            ++n;
        }
        return n;
    }

    private double evaluate(int n, int n2) {
        return this.evaluate(n, n2, 0.0, OPERAND, OPERATOR_EQUAL);
    }

    private boolean isScientificNotation(int n) {
        char c = this.expression.charAt(n);
        return c == 'E' || c == 'e';
    }

    /*
     * Unable to fully structure code
     */
    private double evaluate(int var1_1, int var2_2, double var3_3, Operator var5_4, Operator var6_5) {
        var7_6 = MathEval.OPERAND;
        var8_7 = var1_1;
        while ((var8_7 = MathEval.skipWhitespace(this.expression, var8_7, var2_2)) <= var2_2) {
            var9_8 = 0;
            var10_9 = true;
            var11_10 = true;
            var1_1 = var8_7;
            while (var8_7 <= var2_2) {
                block24: {
                    var12_11 = this.expression.charAt(var8_7);
                    v0 = var13_13 = var12_11 == '-' || var12_11 == '+';
                    if (var13_13 && var8_7 != 0 && this.isScientificNotation(var8_7 - 1)) break block24;
                    if (!var11_10) ** GOTO lbl18
                    if (var13_13) {
                        var10_9 = var10_9 ? var12_11 == '+' : var12_11 == '-';
                        ++var9_8;
                    } else {
                        var11_10 = false;
lbl18:
                        // 2 sources

                        if ((var7_6 = MathEval.getOperator(var12_11)) != MathEval.OPERAND) {
                            if (var7_6 != MathEval.OPERATOR_EQUAL) break;
                            var7_6 = MathEval.OPERAND;
                        } else if (var12_11 == ')' || var12_11 == ',' || var12_11 == ';') break;
                    }
                }
                ++var8_7;
            }
            var12_11 = this.expression.charAt(var1_1);
            if (var1_1 == var8_7 && (Operator.access$100(var6_5) == Side.LEFT || Operator.access$100(var7_6) == Side.RIGHT)) {
                var13_12 = NaN;
            } else if (var12_11 == '(') {
                var13_12 = this.evaluate(var1_1 + 1, var2_2);
                var8_7 = MathEval.skipWhitespace(this.expression, this.offset + 1, var2_2);
                var7_6 = var8_7 <= var2_2 ? MathEval.getOperator(this.expression.charAt(var8_7)) : MathEval.OPERAND;
            } else if (var12_11 != '-' && (var12_11 < '0' || var12_11 > '9')) {
                if (Operator.access$000(var7_6) == '(') {
                    var13_12 = this.doFunction(var1_1, var2_2);
                    var8_7 = MathEval.skipWhitespace(this.expression, this.offset + 1, var2_2);
                    var7_6 = var8_7 <= var2_2 ? MathEval.getOperator(this.expression.charAt(var8_7)) : MathEval.OPERAND;
                } else {
                    var13_12 = this.getVariable(var1_1, var8_7 - 1);
                }
            } else {
                var15_14 = null;
                try {
                    var16_15 = var1_1 + var9_8;
                    if (MathEval.isHexDecimal(this.expression, var1_1)) {
                        var15_14 = this.expression.substring(var16_15 += 2, var8_7).trim();
                        var13_12 = Long.parseLong(var15_14, 16);
                    } else {
                        var15_14 = this.expression.substring(var16_15, var8_7);
                        var13_12 = Double.parseDouble(var15_14);
                    }
                    if (!var10_9) {
                        var13_12 = -var13_12;
                    }
                }
                catch (NumberFormatException var16_16) {
                    throw this.exception(var1_1, "Invalid numeric value \"" + var15_14 + '\"');
                }
            }
            if (Operator.access$200(var6_5, Side.LEFT) < Operator.access$200(var7_6, Side.RIGHT)) {
                var13_12 = this.evaluate(var8_7 + 1, var2_2, var13_12, var6_5, var7_6);
                var8_7 = this.offset;
                var7_6 = var8_7 <= var2_2 ? MathEval.getOperator(this.expression.charAt(var8_7)) : MathEval.OPERAND;
            }
            var3_3 = this.doOperation(var1_1, var3_3, var6_5, var13_12);
            var6_5 = var7_6;
            if (Operator.access$200(var5_4, Side.LEFT) >= Operator.access$200(var6_5, Side.RIGHT)) break;
            if (Operator.access$000(var6_5) == '(') {
                --var8_7;
            }
            ++var8_7;
        }
        if (var8_7 > var2_2 && var6_5 != MathEval.OPERAND) {
            if (Operator.access$100(var6_5) == Side.LEFT) {
                var3_3 = this.doOperation(var1_1, var3_3, var6_5, NaN);
            } else {
                throw this.exception(var8_7, "Expression ends with a blank operand after operator '" + Operator.access$000(var7_6) + '\'');
            }
        }
        this.offset = var8_7;
        return var3_3;
    }

    private double doOperation(int n, double d, Operator operator, double d2) {
        if (operator.unary != Side.RIGHT && Double.isNaN(d)) {
            throw this.exception(n, "Mathematical NaN detected in right-operand");
        }
        if (operator.unary != Side.LEFT && Double.isNaN(d2)) {
            throw this.exception(n, "Mathematical NaN detected in left-operand");
        }
        try {
            return operator.function.apply(d, d2);
        }
        catch (ArithmeticException arithmeticException) {
            throw this.exception(n, "Mathematical expression \"" + this.expression + "\" failed to evaluate", arithmeticException);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            int n2;
            for (n2 = n; n2 > 0 && MathEval.getOperator(this.expression.charAt(n2)) == null; --n2) {
            }
            throw this.exception(n2, "Operator \"" + operator.symbol + "\" not handled by math engine (Programmer error: The list of operators is inconsistent within the engine)");
        }
    }

    private double doFunction(int n, int n2) {
        int n3 = this.expression.indexOf(40, n);
        if (n3 == -1) {
            throw this.exception(n, "Could not find the start of parathensis '(' for function");
        }
        String string = this.expression.substring(n, n3).trim();
        QuantumFunction quantumFunction = FUNCTIONS.get(string);
        if (quantumFunction == null) {
            throw this.exception(n, "Function \"" + string + "\" not recognized");
        }
        ArgParser argParser = new ArgParser(n3, n2);
        try {
            double d = quantumFunction.apply(argParser);
            if (argParser.hasNext()) {
                throw this.exception(argParser.index, "Function has too many arguments");
            }
            this.offset = argParser.index;
            return d;
        }
        catch (NoSuchMethodError noSuchMethodError) {
            throw this.exception(n, "Function not supported in this JVM: \"" + string + '\"');
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw this.exception(n, unsupportedOperationException.getMessage());
        }
        catch (Throwable throwable) {
            throw this.exception(n, "Unexpected exception parsing function arguments", throwable);
        }
    }

    private double getVariable(int n, int n2) {
        while (n < n2 && this.expression.charAt(n2) == ' ') {
            --n2;
        }
        String string = this.expression.substring(n, n2 + 1);
        Double d = CONSTANTS.get(string);
        if (d != null) {
            return d;
        }
        throw this.exception(n, n + " Unrecognized constant or variable \"" + string + '\"');
    }

    private ArithmeticException exception(int n, String string) {
        return new ArithmeticException(string + " at offset " + n + " in expression \"" + this.expression + '\"');
    }

    private ArithmeticException exception(int n, String string, Throwable throwable) {
        return new ArithmeticException(string + " at offset " + n + " in expression \"" + this.expression + '\"' + " (Cause: " + (throwable.getMessage() != null ? throwable.getMessage() : throwable.toString()) + ')');
    }

    static {
        MathEval.registerOperators();
        MathEval.registerFunctions();
        MathEval.registerConstants();
    }

    private static final class Operator {
        private final char symbol;
        private final byte precedenceLeft;
        private final byte precedenceRight;
        private final Side unary;
        private final TriFunction function;

        protected Operator(char c, int n, TriFunction triFunction) {
            this(c, n, n, Side.NONE, triFunction);
        }

        Operator(char c, int n, int n2, Side side, TriFunction triFunction) {
            this.symbol = c;
            this.precedenceLeft = (byte)n;
            this.precedenceRight = (byte)n2;
            this.unary = side;
            this.function = triFunction;
        }

        public String toString() {
            return "MathOperator['" + this.symbol + "']";
        }

        private byte opPrecedence(Side side) {
            if (this.unary == Side.NONE || this.unary != side) {
                return side == Side.LEFT ? this.precedenceLeft : this.precedenceRight;
            }
            return 127;
        }

        static /* synthetic */ byte access$200(Operator operator, Side side) {
            return operator.opPrecedence(side);
        }
    }

    private static enum Side {
        RIGHT,
        LEFT,
        NONE;

    }

    @FunctionalInterface
    private static interface TriFunction {
        public double apply(double var1, double var3);
    }

    @FunctionalInterface
    private static interface QuantumFunction {
        public double apply(ArgParser var1);
    }

    private final class ArgParser {
        private final int end;
        private int index;

        ArgParser(int n, int n2) {
            this.end = n2;
            this.index = MathEval.skipWhitespace(MathEval.this.expression, n + 1, n2 - 1);
        }

        public double next() {
            char c = MathEval.this.expression.charAt(this.index);
            if (c == ')') {
                throw MathEval.this.exception(this.index, "Function has too few arguments");
            }
            if (c == ',' || c == ';') {
                ++this.index;
            }
            double d = MathEval.this.evaluate(this.index, this.end);
            this.index = MathEval.this.offset;
            return d;
        }

        public double next(int n) {
            double d = 0.0;
            for (int i = 0; i < n; ++i) {
                d = this.next();
            }
            return d;
        }

        private boolean hasNext() {
            return MathEval.this.expression.charAt(this.index) != ')';
        }
    }

    @FunctionalInterface
    public static interface VariableFunction {
        public double apply(String var1);
    }
}

