/*
 * Decompiled with CFR 0.152.
 */
package org.skills.utils;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.NumberConversions;
import org.bukkit.util.Vector;
import org.skills.main.SkillsPro;
import org.skills.utils.MathUtils;
import org.skills.utils.xseries.particles.ParticleDisplay;

public class LocationUtils {
    public static final BlockFace[] AXIS = new BlockFace[]{BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST};
    public static final BlockFace[] RADIAL = new BlockFace[]{BlockFace.NORTH, BlockFace.NORTH_EAST, BlockFace.EAST, BlockFace.SOUTH_EAST, BlockFace.SOUTH, BlockFace.SOUTH_WEST, BlockFace.WEST, BlockFace.NORTH_WEST};
    private static final double ROUND_SCALING = Math.pow(10.0, 1.0);

    public static void faceOther(Entity entity, Entity entity2) {
        entity.teleport(entity.getLocation().setDirection(entity.getLocation().toVector().subtract(entity2.getLocation().toVector())));
    }

    public static Location getArmorStandHandLocation(ArmorStand armorStand) {
        Location location = armorStand.getLocation().clone();
        location.setYaw(location.getYaw() + 90.0f);
        Vector vector = location.getDirection();
        location.setX(location.getX() + 0.3125 * vector.getX());
        location.setY(location.getY() + 1.375);
        location.setZ(location.getZ() + 0.3125 * vector.getZ());
        EulerAngle eulerAngle = armorStand.getRightArmPose();
        Vector vector2 = LocationUtils.getDirection(eulerAngle.getX(), eulerAngle.getY(), -eulerAngle.getZ());
        vector2 = ParticleDisplay.rotateAround(vector2, ParticleDisplay.Axis.Y, -Math.toRadians(location.getYaw() - 90.0f));
        location.setX(location.getX() + 0.625 * vector2.getX());
        location.setY(location.getY() + 0.625 * vector2.getY());
        location.setZ(location.getZ() + 0.625 * vector2.getZ());
        return location;
    }

    private static Vector getDirection(double d, double d2, double d3) {
        return ParticleDisplay.rotateAround(new Vector(-(Math.abs(Math.toDegrees(d)) * 0.00663), -1.0, 0.0), d, d2, d3);
    }

    private static double roundToDigits(double d) {
        return (double)Math.round(d * ROUND_SCALING) / ROUND_SCALING;
    }

    public static Location roundLocationPrecision(Location location) {
        return new Location(location.getWorld(), LocationUtils.roundToDigits(location.getX()), LocationUtils.roundToDigits(location.getY()), LocationUtils.roundToDigits(location.getZ()), (float)LocationUtils.roundToDigits(location.getYaw()), (float)LocationUtils.roundToDigits(location.getPitch()));
    }

    public static double distanceSquared(Location location, Location location2) {
        return Math.sqrt(LocationUtils.distance(location, location2));
    }

    public static double distance(Location location, Location location2) {
        return NumberConversions.square((double)(location.getX() - location2.getX())) + NumberConversions.square((double)(location.getY() - location2.getY())) + NumberConversions.square((double)(location.getZ() - location2.getZ()));
    }

    public static Vector getDirection(Location location, double d, double d2) {
        Vector vector = new Vector();
        double d3 = Math.toRadians((double)location.getYaw() + d2);
        double d4 = Math.cos(Math.toRadians(d));
        vector.setX(-d4 * Math.sin(d3));
        vector.setZ(d4 * Math.cos(d3));
        return vector;
    }

    public static String toReadableLocation(Location location) {
        return location.getBlockX() + ", " + location.getBlockY() + ", " + location.getBlockZ();
    }

    public static String toReadableWorldLocation(Location location) {
        return location.getWorld().getName() + ", " + LocationUtils.toReadableLocation(location);
    }

    public static void whoooosh(Entity entity, Location location, double d, double d2, double d3) {
        Location location2 = entity.getLocation();
        location2.setY(location2.getY() + 0.5);
        double d4 = -0.1;
        double d5 = location.distance(location2);
        double d6 = (1.0 + d * d5) * (location.getX() - location2.getX()) / d5;
        double d7 = (1.0 + d2 * d5) * (location.getY() - location2.getY()) / d5 - 0.5 * d4 * d5;
        double d8 = (1.0 + d3 * d5) * (location.getZ() - location2.getZ()) / d5;
        Vector vector = new Vector(d6, d7, d8);
        entity.setVelocity(vector);
    }

    public static Location getHandLocation(LivingEntity livingEntity, boolean bl) {
        Location location = livingEntity.getLocation();
        double d = bl ? -1.0 : 1.0;
        double d2 = Math.toRadians(d * (double)location.getYaw() - 45.0);
        double d3 = 0.5 * Math.sin(d2) + location.getX();
        double d4 = location.getY() + 0.7;
        double d5 = 0.5 * Math.cos(d2) + location.getZ();
        return new Location(livingEntity.getWorld(), d3, d4, d5);
    }

    public static BukkitTask rotate(final Entity entity, final float f, final boolean bl, final boolean bl2, final int n) {
        return new BukkitRunnable(){
            int times;
            float yawF;
            float pitchF;
            {
                this.times = n;
                this.yawF = entity.getLocation().getYaw();
                this.pitchF = entity.getLocation().getPitch();
            }

            public void run() {
                Location location = entity.getLocation();
                --this.times;
                if (bl) {
                    this.yawF += f;
                    location.setYaw(this.yawF);
                }
                if (bl2) {
                    this.pitchF += f;
                    location.setPitch(this.pitchF);
                }
                entity.teleport(location);
                if (this.times <= 0) {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)SkillsPro.get(), 0L, 1L);
    }

    public static Location centerAxis(Location location) {
        Location location2 = location.clone();
        location2.setX((double)location2.getBlockX() + 0.5);
        location2.setY((double)location2.getBlockY());
        location2.setZ((double)location2.getBlockZ() + 0.5);
        return location2;
    }

    public static Location centerView(Location location) {
        Location location2 = location.clone();
        location2.setYaw(LocationUtils.centerYaw(location2.getYaw()));
        location2.setPitch(0.0f);
        return location2;
    }

    public static Location cleanLocation(Location location) {
        Location location2 = location.clone();
        location2.setX((double)location2.getBlockX() + 0.5);
        location2.setY((double)location2.getBlockY());
        location2.setZ((double)location2.getBlockZ() + 0.5);
        location2.setYaw(LocationUtils.centerYaw(location2.getYaw()));
        location2.setPitch(0.0f);
        return location2;
    }

    public static Location getSafeLocation(Location location) {
        Location location2 = location.clone();
        location2 = LocationUtils.centerAxis(location2);
        location2.setYaw((float)MathUtils.roundToDigits(location2.getYaw(), 1));
        location2.setPitch((float)MathUtils.roundToDigits(location2.getPitch(), 1));
        return location2;
    }

    public static boolean hasMoved(Location location, Location location2) {
        return location.getX() != location2.getX() || location.getY() != location2.getY() || location.getZ() != location2.getZ();
    }

    public static boolean hasMovedABlock(Location location, Location location2) {
        return location.getBlockX() != location2.getBlockX() || location.getBlockY() != location2.getBlockY() || location.getBlockZ() != location2.getBlockZ();
    }

    public static BlockFace yawToFaceRadial(float f) {
        return RADIAL[Math.round(f / 45.0f) & 7];
    }

    public static BlockFace yawToFace(float f) {
        return AXIS[Math.round(f / 90.0f) & 3];
    }

    public static float centerYaw(float f) {
        return LocationUtils.faceToYaw(LocationUtils.yawToFace(f));
    }

    public static float faceToYaw(BlockFace blockFace) {
        switch (blockFace) {
            case NORTH_EAST: {
                return 45.0f;
            }
            case EAST: {
                return 90.0f;
            }
            case SOUTH_EAST: {
                return 135.0f;
            }
            case SOUTH: {
                return 180.0f;
            }
            case SOUTH_WEST: {
                return 225.0f;
            }
            case WEST: {
                return 270.0f;
            }
            case NORTH_WEST: {
                return 315.0f;
            }
        }
        return 0.0f;
    }

    public static BlockFace pitchToFace(float f) {
        return f < -25.0f ? BlockFace.UP : (f > 25.0f ? BlockFace.DOWN : null);
    }

    public static float compareDirection(Location location, Location location2) {
        return (float)Math.toDegrees(Math.atan2((double)location.getBlockX() - location2.getX(), location2.getZ() - (double)location.getBlockZ()));
    }

    public static BlockFace getEntityBlockFace(LivingEntity livingEntity) {
        List list = livingEntity.getLastTwoTargetBlocks(null, 6);
        if (list.size() != 2) {
            return null;
        }
        Block block = (Block)list.get(1);
        Block block2 = (Block)list.get(0);
        return block.getFace(block2);
    }

    public static BlockFace getyawToFace(float f) {
        if ((f %= 360.0f) < 0.0f) {
            f += 360.0f;
        }
        f = Math.round(f / 45.0f);
        switch ((int)f) {
            case 1: {
                return BlockFace.NORTH_WEST;
            }
            case 2: {
                return BlockFace.NORTH;
            }
            case 3: {
                return BlockFace.NORTH_EAST;
            }
            case 4: {
                return BlockFace.EAST;
            }
            case 5: {
                return BlockFace.SOUTH_EAST;
            }
            case 6: {
                return BlockFace.SOUTH;
            }
            case 7: {
                return BlockFace.SOUTH_WEST;
            }
        }
        return BlockFace.WEST;
    }

    public static List<Chunk> getChunksAround(Location location, int n) {
        World world = location.getWorld();
        int n2 = location.getChunk().getX();
        int n3 = location.getChunk().getZ();
        ArrayList<Chunk> arrayList = new ArrayList<Chunk>();
        for (int i = n2 - n; i < n2 + n; ++i) {
            for (int j = n3 - n; j < n3 + n; ++j) {
                arrayList.add(world.getChunkAt(i, j));
            }
        }
        return arrayList;
    }
}

