/*
 * Decompiled with CFR 0.152.
 */
package org.skills.utils;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.NumberConversions;
import org.skills.utils.xseries.reflection.XReflection;
import org.skills.utils.xseries.reflection.minecraft.MinecraftConnection;

public final class Laser {
    private static final String TEAM = "skills";
    private static final String COLLISION_RULE = "never";
    private static final AtomicInteger TEAM_ID = new AtomicInteger();
    private static final AtomicInteger LAST_ISSUED_EID = new AtomicInteger(2000000000);
    private final int duration;
    private final int distanceSquared;
    private final Object createGuardianPacket;
    private final Object createSquidPacket;
    private final Object destroyPacket;
    private final Object metadataPacketGuardian;
    private final Object metadataPacketSquid;
    private final Object fakeGuardianDataWatcher;
    private final Object teamCreatePacket;
    private final Map<UUID, Player> players = new ConcurrentHashMap<UUID, Player>(10);
    private final Set<Integer> seen = new HashSet<Integer>();
    private final NMSEntityInfo squid;
    private final NMSEntityInfo guardian;
    private Location start;
    private Location lastEndLocation;
    private Supplier<Location> endLocationTracker;
    private BukkitRunnable run;

    public Laser(Location location, Supplier<Location> supplier, int n, int n2) {
        Object object;
        Object object2;
        Location location2 = supplier.get();
        if (location.getWorld() != location2.getWorld()) {
            throw new IllegalArgumentException("Laser start world is different from the end location: " + location.getWorld() + " - " + location2.getWorld());
        }
        this.start = location;
        this.endLocationTracker = supplier;
        this.duration = n;
        this.distanceSquared = n2 * n2;
        if (XReflection.supports(17)) {
            object2 = NMSReflection.createSquid(location2);
            this.createSquidPacket = NMSReflection.createPacketEntitySpawn(object2);
        } else {
            object2 = null;
            this.createSquidPacket = NMSReflection.createSpawnPacket(location2, NMSReflection.SQUID_TYPE);
        }
        String string = XReflection.v(19, "d").orElse("b");
        String string2 = XReflection.v(19, "c").orElse("a");
        UUID uUID = (UUID)NMSReflection.getField(string, this.createSquidPacket);
        int n3 = (Integer)NMSReflection.getField(string2, this.createSquidPacket);
        this.squid = new NMSEntityInfo(object2, uUID, n3);
        this.metadataPacketSquid = NMSReflection.createPacketMetadata(n3, NMSReflection.fakeSquidWatcher);
        NMSReflection.setDirtyWatcher(NMSReflection.fakeSquidWatcher);
        this.fakeGuardianDataWatcher = NMSReflection.createFakeDataWatcher();
        NMSReflection.initGuardianWatcher(this.fakeGuardianDataWatcher, n3);
        if (XReflection.supports(17)) {
            object = NMSReflection.createGuardian(location);
            this.createGuardianPacket = NMSReflection.createPacketEntitySpawn(object);
        } else {
            object = null;
            this.createGuardianPacket = NMSReflection.createSpawnPacket(location, NMSReflection.GUARDIAN_TYPE);
        }
        UUID uUID2 = (UUID)NMSReflection.getField(string, this.createGuardianPacket);
        int n4 = (Integer)NMSReflection.getField(string2, this.createGuardianPacket);
        this.guardian = new NMSEntityInfo(object, uUID2, n4);
        this.metadataPacketGuardian = NMSReflection.createPacketMetadata(n4, this.fakeGuardianDataWatcher);
        this.teamCreatePacket = NMSReflection.createPacketTeamAddEntities(uUID, uUID2);
        this.destroyPacket = NMSReflection.createPacketRemoveEntities(n3, n4);
    }

    private static double distanceSquared(Location location, Location location2) {
        return NumberConversions.square((double)(location.getX() - location2.getX())) + NumberConversions.square((double)(location.getY() - location2.getY())) + NumberConversions.square((double)(location.getZ() - location2.getZ()));
    }

    public void start(final Plugin plugin) {
        if (this.run != null) {
            throw new IllegalStateException("Laser is already started");
        }
        this.run = new BukkitRunnable(){
            final World world;
            int time;
            {
                this.world = Laser.this.start.getWorld();
                this.time = Laser.this.duration;
            }

            public void run() {
                for (Object object : this.world.getPlayers()) {
                    if (Laser.this.isCloseEnough(object.getLocation())) {
                        if (Laser.this.players.put(object.getUniqueId(), object) != null) continue;
                        Laser.this.sendStartPackets(plugin, object, !Laser.this.seen.add(object.getEntityId()));
                        continue;
                    }
                    if (Laser.this.players.remove(object.getUniqueId()) == null) continue;
                    Laser.this.destroy((Player)object);
                }
                if (--this.time == 0) {
                    this.cancel();
                }
                try {
                    Location location = Laser.this.getEndLocation();
                    if (location != null) {
                        Object object;
                        object = NMSReflection.teleport(Laser.this.squid, location);
                        for (Player player : Laser.this.players.values()) {
                            MinecraftConnection.sendPacket(player, object);
                        }
                    }
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    throw new RuntimeException(reflectiveOperationException);
                }
            }

            public synchronized void cancel() {
                super.cancel();
                Laser.this.run = null;
                for (Player player : Laser.this.players.values()) {
                    Laser.this.destroy(player);
                }
                Laser.this.players.clear();
            }
        };
        this.run.runTaskTimerAsynchronously(plugin, 0L, 20L);
    }

    public void destroy(Player player) {
        MinecraftConnection.sendPacket(player, this.destroyPacket);
    }

    public void clear() {
        this.players.clear();
    }

    public void stop() {
        Validate.isTrue((this.run != null ? 1 : 0) != 0, (String)"Laser not started");
        this.run.cancel();
    }

    public void moveStart(Location location) {
        this.start = location;
        Object object = NMSReflection.teleport(this.guardian, this.start);
        for (Player player : this.players.values()) {
            MinecraftConnection.sendPacket(player, object);
        }
    }

    public Location getStart() {
        return this.start;
    }

    public void moveEnd(Supplier<Location> supplier) {
        this.endLocationTracker = supplier;
    }

    public void callColorChange() {
        for (Player player : this.players.values()) {
            MinecraftConnection.sendPacket(player, this.metadataPacketGuardian);
        }
    }

    public boolean isStarted() {
        return this.run != null;
    }

    private void sendStartPackets(Plugin plugin, Player player, boolean bl) {
        ArrayList<Object> arrayList = new ArrayList<Object>(6);
        Bukkit.getScheduler().runTaskLaterAsynchronously(plugin, () -> {
            Location location;
            arrayList.clear();
            arrayList.add(this.createGuardianPacket);
            if (XReflection.supports(15)) {
                arrayList.add(this.metadataPacketGuardian);
            }
            if (!bl) {
                arrayList.add(this.teamCreatePacket);
            }
            if ((location = this.getEndLocation()) != null) {
                try {
                    arrayList.add(NMSReflection.teleport(this.squid, location));
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    throw new RuntimeException(reflectiveOperationException);
                }
            }
            MinecraftConnection.sendPacket(player, arrayList.toArray());
        }, 5L);
        arrayList.add(this.createSquidPacket);
        if (XReflection.supports(15)) {
            arrayList.add(this.metadataPacketSquid);
        }
        MinecraftConnection.sendPacket(player, arrayList.toArray());
    }

    private boolean isCloseEnough(Location location) {
        return Laser.distanceSquared(this.start, location) <= (double)this.distanceSquared || this.lastEndLocation != null && Laser.distanceSquared(this.lastEndLocation, location) <= (double)this.distanceSquared;
    }

    private Location getEndLocation() {
        Location location = this.endLocationTracker.get();
        return location == null ? this.lastEndLocation : (this.lastEndLocation = location);
    }

    private static final class NMSEntityInfo {
        private final Object entity;
        private final UUID uuid;
        private final int id;

        private NMSEntityInfo(Object object, UUID uUID, int n) {
            this.entity = object;
            this.uuid = uUID;
            this.id = n;
        }
    }

    private static final class NMSReflection {
        private static final MethodHandle PACKET_SPAWN;
        private static final MethodHandle SET_LOCATION;
        private static final Object NMS_WORLD;
        private static final int TEAM_METHOD_ADD = 3;
        private static final Class<?> packetRemove;
        private static final Class<?> packetTeleport;
        private static final Class<?> packetTeam;
        private static final Class<?> packetMetadata;
        private static Constructor<?> watcherConstructor;
        private static Method watcherSet;
        private static Method watcherRegister;
        private static Method watcherDirty;
        private static Method watcherPack;
        private static Object WATCHER_INVISILIBITY;
        private static Object WATCHER_SPIKES;
        private static Object WATCHER_ATTACK_ID;
        private static Object SQUID_TYPE;
        private static Object GUARDIAN_TYPE;
        private static Object fakeSquid;
        private static Object fakeSquidWatcher;

        private NMSReflection() {
        }

        private static int generateEID() {
            return LAST_ISSUED_EID.getAndIncrement();
        }

        public static Object createFakeDataWatcher() {
            Object obj = watcherConstructor.newInstance(fakeSquid);
            if (XReflection.supports(14)) {
                NMSReflection.setField(obj, "registrationLocked", false);
            }
            return obj;
        }

        public static void setDirtyWatcher(Object object) {
            if (XReflection.supports(15)) {
                watcherDirty.invoke(object, WATCHER_INVISILIBITY);
            }
        }

        public static Object createSquid(Location location) {
            Object obj = XReflection.getNMSClass("world.entity.animal", "EntitySquid").getDeclaredConstructors()[0].newInstance(SQUID_TYPE, NMS_WORLD);
            NMSReflection.setLocation(obj, location);
            return obj;
        }

        public static Object createGuardian(Location location) {
            Object obj = XReflection.getNMSClass("world.entity.monster", "EntityGuardian").getDeclaredConstructors()[0].newInstance(GUARDIAN_TYPE, NMS_WORLD);
            NMSReflection.setLocation(obj, location);
            return obj;
        }

        public static Object createSpawnPacket(Location location, Object object) {
            try {
                Object object2 = PACKET_SPAWN.invoke();
                NMSReflection.setField(object2, "a", NMSReflection.generateEID());
                NMSReflection.setField(object2, "b", UUID.randomUUID());
                NMSReflection.setField(object2, "c", object);
                NMSReflection.setField(object2, "d", location.getX());
                NMSReflection.setField(object2, "e", location.getY());
                NMSReflection.setField(object2, "f", location.getZ());
                NMSReflection.setField(object2, "j", (byte)(location.getYaw() * 256.0f / 360.0f));
                NMSReflection.setField(object2, "k", (byte)(location.getPitch() * 256.0f / 360.0f));
                if (!XReflection.supports(15)) {
                    NMSReflection.setField(object2, "m", fakeSquidWatcher);
                }
                return object2;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }

        public static void initGuardianWatcher(Object object, int n) {
            NMSReflection.tryWatcherSet(object, WATCHER_INVISILIBITY, (byte)32);
            NMSReflection.tryWatcherSet(object, WATCHER_SPIKES, false);
            NMSReflection.tryWatcherSet(object, WATCHER_ATTACK_ID, n);
        }

        public static Object createPacketEntitySpawn(Object object) {
            try {
                return PACKET_SPAWN.invoke(object);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }

        public static Object createPacketRemoveEntities(int n, int n2) {
            if (XReflection.supports(17)) {
                Constructor<?> constructor = packetRemove.getConstructor(int[].class);
                return constructor.newInstance(new Object[]{new int[]{n, n2}});
            }
            Object obj = packetRemove.newInstance();
            NMSReflection.setField(obj, "a", new int[]{n, n2});
            return obj;
        }

        public static void setLocation(Object object, Location location) {
            try {
                SET_LOCATION.invoke(object, location.getX(), location.getY(), location.getZ(), location.getPitch(), location.getYaw());
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }

        public static Object createPacketTeamAddEntities(UUID uUID, UUID uUID2) {
            Object obj;
            String string = Laser.TEAM + TEAM_ID.getAndIncrement();
            if (XReflection.supports(17)) {
                ArrayList<String> arrayList = new ArrayList<String>(2);
                arrayList.add(uUID.toString());
                arrayList.add(uUID2.toString());
                Constructor<?> constructor = packetTeam.getDeclaredConstructor(String.class, Integer.TYPE, Optional.class, Collection.class);
                constructor.setAccessible(true);
                obj = constructor.newInstance(string, 3, Optional.empty(), arrayList);
            } else {
                obj = packetTeam.newInstance();
                NMSReflection.setField(obj, "a", string);
                NMSReflection.setField(obj, "f", Laser.COLLISION_RULE);
                NMSReflection.setField(obj, "i", 3);
                Collection collection = (Collection)NMSReflection.getField(packetTeam, "h", obj);
                collection.add(uUID.toString());
                collection.add(uUID2.toString());
            }
            return obj;
        }

        public static Object teleport(NMSEntityInfo nMSEntityInfo, Location location) {
            Object obj;
            if (XReflection.supports(17)) {
                try {
                    NMSReflection.setLocation(nMSEntityInfo.entity, location);
                    obj = packetTeleport.getConstructor(XReflection.getNMSClass("world.entity", "Entity")).newInstance(nMSEntityInfo.entity);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    return null;
                }
            } else {
                obj = packetTeleport.newInstance();
                NMSReflection.setField(obj, "a", nMSEntityInfo.id);
                NMSReflection.setField(obj, "b", location.getX());
                NMSReflection.setField(obj, "c", location.getY());
                NMSReflection.setField(obj, "d", location.getZ());
                NMSReflection.setField(obj, "e", (byte)(location.getYaw() * 256.0f / 360.0f));
                NMSReflection.setField(obj, "f", (byte)(location.getPitch() * 256.0f / 360.0f));
                NMSReflection.setField(obj, "g", true);
            }
            return obj;
        }

        private static Object createPacketMetadata(int n, Object object) {
            if (XReflection.supports(19)) {
                return packetMetadata.getConstructor(Integer.TYPE, List.class).newInstance(n, watcherPack.invoke(object, new Object[0]));
            }
            return packetMetadata.getConstructor(Integer.TYPE, object.getClass(), Boolean.TYPE).newInstance(n, object, false);
        }

        private static void tryWatcherSet(Object object, Object object2, Object object3) {
            block2: {
                try {
                    watcherSet.invoke(object, object2, object3);
                }
                catch (InvocationTargetException invocationTargetException) {
                    watcherRegister.invoke(object, object2, object3);
                    if (!XReflection.supports(15)) break block2;
                    watcherDirty.invoke(object, object2);
                }
            }
        }

        private static Method getMethodIgnoreParams(Class<?> clazz, String string) {
            for (Method method : clazz.getDeclaredMethods()) {
                if (!method.getName().equals(string)) continue;
                return method;
            }
            return null;
        }

        private static Method getMethodStarting(Class<?> clazz, String string, MethodType methodType) {
            for (Method method : clazz.getDeclaredMethods()) {
                if (!method.getName().equals(string) || method.getReturnType() != methodType.returnType()) continue;
                if (methodType.parameterCount() != 0 && methodType.parameterCount() <= method.getParameterCount()) {
                    int n = 0;
                    Parameter[] parameterArray = method.getParameters();
                    for (Class<?> clazz2 : methodType.parameterArray()) {
                        if (parameterArray[n++].getType() == clazz2) continue;
                        n = -1;
                        break;
                    }
                    if (n == -1) continue;
                }
                method.setAccessible(true);
                return method;
            }
            return null;
        }

        private static void setField(Object object, String string, Object object2) {
            Field field = object.getClass().getDeclaredField(string);
            field.setAccessible(true);
            field.set(object, object2);
        }

        private static Object getField(Class<?> clazz, String string, Object object) {
            Field field = clazz.getDeclaredField(string);
            field.setAccessible(true);
            return field.get(object);
        }

        private static Object getField(String string, Object object) {
            return NMSReflection.getField(object.getClass(), string, object);
        }

        static {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            Object object = null;
            MethodHandle methodHandle = null;
            MethodHandle methodHandle2 = null;
            Class<?> clazz = XReflection.getCraftClass("CraftWorld");
            Class<?> clazz2 = XReflection.getNMSClass("world.entity", "Entity");
            Class<?> clazz3 = XReflection.getNMSClass("world.entity", "EntityLiving");
            Class<?> clazz4 = XReflection.getNMSClass("world.entity.monster", "EntityGuardian");
            Class<?> clazz5 = XReflection.getNMSClass("world.entity.animal", "EntitySquid");
            Class<?> clazz6 = XReflection.getCraftClass("entity.CraftSquid");
            Class<?> clazz7 = XReflection.getNMSClass("network.syncher", "DataWatcher");
            Class<?> clazz8 = XReflection.getNMSClass("network.syncher", "DataWatcherObject");
            Class<?> clazz9 = XReflection.getNMSClass("world.entity", "EntityTypes");
            Class<?> clazz10 = XReflection.getNMSClass("network.protocol.game", XReflection.v(19, "PacketPlayOutSpawnEntity").orElse("PacketPlayOutSpawnEntityLiving"));
            packetRemove = XReflection.getNMSClass("network.protocol.game", "PacketPlayOutEntityDestroy");
            packetTeleport = XReflection.getNMSClass("network.protocol.game", "PacketPlayOutEntityTeleport");
            packetTeam = XReflection.getNMSClass("network.protocol.game", "PacketPlayOutScoreboardTeam");
            packetMetadata = XReflection.getNMSClass("network.protocol.game", "PacketPlayOutEntityMetadata");
            try {
                Object[] objectArray;
                String string;
                String string2;
                String string3;
                if (XReflection.MINOR_NUMBER < 13) {
                    string3 = "Z";
                    string2 = "bA";
                    string = "bB";
                    SQUID_TYPE = 94;
                    GUARDIAN_TYPE = 68;
                } else if (XReflection.MINOR_NUMBER == 13) {
                    string3 = "ac";
                    string2 = "bF";
                    string = "bG";
                    SQUID_TYPE = 70;
                    GUARDIAN_TYPE = 28;
                } else if (XReflection.MINOR_NUMBER == 14) {
                    string3 = "W";
                    string2 = "b";
                    string = "bD";
                    SQUID_TYPE = 73;
                    GUARDIAN_TYPE = 30;
                } else if (XReflection.MINOR_NUMBER == 15) {
                    string3 = "T";
                    string2 = "b";
                    string = "bA";
                    SQUID_TYPE = 74;
                    GUARDIAN_TYPE = 31;
                } else if (XReflection.MINOR_NUMBER == 16) {
                    string3 = "S";
                    string2 = "b";
                    string = "d";
                    SQUID_TYPE = 74;
                    GUARDIAN_TYPE = 31;
                } else if (XReflection.MINOR_NUMBER == 17) {
                    string3 = "Z";
                    string2 = "b";
                    string = "e";
                    SQUID_TYPE = clazz9.getDeclaredField("aJ").get(null);
                    GUARDIAN_TYPE = clazz9.getDeclaredField("K").get(null);
                } else if (XReflection.MINOR_NUMBER == 18) {
                    string3 = "Z";
                    string2 = "b";
                    string = "e";
                    SQUID_TYPE = clazz9.getDeclaredField("aJ").get(null);
                    GUARDIAN_TYPE = clazz9.getDeclaredField("K").get(null);
                } else {
                    string3 = "an";
                    string2 = "b";
                    string = "e";
                    SQUID_TYPE = clazz9.getDeclaredField("aT").get(null);
                    GUARDIAN_TYPE = clazz9.getDeclaredField("V").get(null);
                }
                WATCHER_INVISILIBITY = NMSReflection.getField(clazz2, string3, null);
                WATCHER_SPIKES = NMSReflection.getField(clazz4, string2, null);
                WATCHER_ATTACK_ID = NMSReflection.getField(clazz4, string, null);
                object = clazz.getDeclaredMethod("getHandle", new Class[0]).invoke(Bukkit.getWorlds().get(0), new Object[0]);
                watcherConstructor = clazz7.getDeclaredConstructor(clazz2);
                watcherSet = NMSReflection.getMethodStarting(clazz7, XReflection.v(18, "b").orElse("set"), MethodType.methodType(Void.TYPE, clazz8));
                watcherRegister = NMSReflection.getMethodStarting(clazz7, XReflection.v(18, "a").orElse("register"), MethodType.methodType(Void.TYPE, clazz8));
                if (XReflection.supports(15)) {
                    watcherDirty = NMSReflection.getMethodIgnoreParams(clazz7, "markDirty");
                }
                if (XReflection.supports(19)) {
                    watcherPack = clazz7.getDeclaredMethod("b", new Class[0]);
                }
                methodHandle2 = lookup.findConstructor(clazz10, XReflection.v(19, MethodType.methodType(Void.TYPE, clazz2)).v(17, MethodType.methodType(Void.TYPE, clazz3)).orElse(MethodType.methodType(Void.TYPE)));
                if (XReflection.supports(17)) {
                    methodHandle = lookup.findVirtual(clazz2, XReflection.v(18, "a").orElse("setLocation"), MethodType.methodType(Void.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE, Float.TYPE));
                }
                if (XReflection.supports(14)) {
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = XReflection.supports(17) ? SQUID_TYPE : clazz9.getDeclaredField("SQUID").get(null);
                    objectArray = objectArray2;
                    objectArray2[1] = object;
                } else {
                    Object[] objectArray3 = new Object[1];
                    objectArray = objectArray3;
                    objectArray3[0] = object;
                }
                Object[] objectArray4 = objectArray;
                fakeSquid = XReflection.getNMSClass("world.entity.animal", "EntitySquid").getDeclaredConstructors()[0].newInstance(objectArray4);
                fakeSquidWatcher = NMSReflection.createFakeDataWatcher();
                NMSReflection.tryWatcherSet(fakeSquidWatcher, WATCHER_INVISILIBITY, (byte)32);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                reflectiveOperationException.printStackTrace();
            }
            NMS_WORLD = object;
            SET_LOCATION = methodHandle;
            PACKET_SPAWN = methodHandle2;
        }
    }
}

