/*
 * Decompiled with CFR 0.152.
 */
package org.skills.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.player.PlayerArmorStandManipulateEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import org.skills.main.SkillsConfig;
import org.skills.main.locale.MessageHandler;
import org.skills.utils.xseries.XPotion;

public class Hologram
implements Listener {
    private static final String HOLOGRAM = "HOLOGRAM";
    private static final Set<Entity> ARMORSTANDS = new HashSet<Entity>();
    private static double maxx;
    private static double minx;
    private static double maxy;
    private static double miny;
    private static double maxz;
    private static double minz;
    private static JavaPlugin plugin;

    public Hologram(JavaPlugin javaPlugin) {
        plugin = javaPlugin;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)javaPlugin);
        Hologram.load();
    }

    public static void load() {
        ConfigurationSection configurationSection = SkillsConfig.HOLOGRAM_OFFSET.getSection();
        String string = configurationSection.getString("x");
        String[] stringArray = StringUtils.split((String)string, (char)',');
        minx = NumberUtils.toDouble((String)stringArray[0], (double)0.7);
        maxx = NumberUtils.toDouble((String)stringArray[1], (double)-0.7);
        string = configurationSection.getString("y");
        stringArray = StringUtils.split((String)string, (char)',');
        miny = NumberUtils.toDouble((String)stringArray[0], (double)1.0);
        maxy = NumberUtils.toDouble((String)stringArray[1], (double)0.8);
        string = configurationSection.getString("z");
        stringArray = StringUtils.split((String)string, (char)',');
        minz = NumberUtils.toDouble((String)stringArray[0], (double)0.7);
        maxz = NumberUtils.toDouble((String)stringArray[1], (double)-0.7);
    }

    public static List<ArmorStand> spawn(Location location, List<String> list, Object ... objectArray) {
        ArrayList<ArmorStand> arrayList = new ArrayList<ArmorStand>();
        ThreadLocalRandom threadLocalRandom = ThreadLocalRandom.current();
        boolean bl = SkillsConfig.HOLOGRAM_STATIC.getBoolean();
        XPotion.Effect effect = XPotion.parseEffect(SkillsConfig.HOLOGRAM_EFFECT.getString());
        for (String string : list) {
            Location location2 = bl ? location.clone().add(threadLocalRandom.nextDouble(minx, maxx), threadLocalRandom.nextDouble(miny, maxy), threadLocalRandom.nextDouble(minz, maxz)) : location;
            ArmorStand armorStand = (ArmorStand)location.getWorld().spawnEntity(location2, EntityType.ARMOR_STAND);
            armorStand.setMetadata(HOLOGRAM, (MetadataValue)new FixedMetadataValue((Plugin)plugin, null));
            armorStand.setInvulnerable(true);
            armorStand.setVisible(false);
            armorStand.setCollidable(false);
            armorStand.setCustomNameVisible(true);
            if (bl) {
                armorStand.setMarker(true);
            } else {
                armorStand.setVelocity(new Vector(threadLocalRandom.nextDouble(minx, maxx), threadLocalRandom.nextDouble(miny, maxy), threadLocalRandom.nextDouble(minz, maxz)));
            }
            if (effect != null && effect.hasChance()) {
                armorStand.addPotionEffect(effect.getEffect());
            }
            for (int i = objectArray.length; i > 0; i -= 2) {
                String string2 = String.valueOf(objectArray[i - 2]);
                String string3 = String.valueOf(objectArray[i - 1]);
                string = StringUtils.replace((String)string, (String)string2, (String)string3);
            }
            armorStand.setCustomName(MessageHandler.colorize(string));
            arrayList.add(armorStand);
        }
        return arrayList;
    }

    public static void spawn(Location location, long l, List<String> list, Object ... objectArray) {
        final List<ArmorStand> list2 = Hologram.spawn(location, list, objectArray);
        ARMORSTANDS.addAll(list2);
        new BukkitRunnable(){

            public void run() {
                for (ArmorStand armorStand : list2) {
                    armorStand.remove();
                }
                list2.forEach(ARMORSTANDS::remove);
            }
        }.runTaskLater((Plugin)plugin, l);
    }

    public static void onDisable() {
        ARMORSTANDS.forEach(Entity::remove);
    }

    public static boolean isHologram(Entity entity) {
        return entity.hasMetadata(HOLOGRAM);
    }

    @EventHandler
    public void onChunkUnload(ChunkUnloadEvent chunkUnloadEvent) {
        for (Entity entity : chunkUnloadEvent.getChunk().getEntities()) {
            if (!entity.hasMetadata(HOLOGRAM)) continue;
            entity.remove();
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void hologramFire(EntityCombustEvent entityCombustEvent) {
        if (entityCombustEvent.getEntity().hasMetadata(HOLOGRAM)) {
            entityCombustEvent.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void manipulate(PlayerArmorStandManipulateEvent playerArmorStandManipulateEvent) {
        if (playerArmorStandManipulateEvent.getRightClicked().hasMetadata(HOLOGRAM)) {
            playerArmorStandManipulateEvent.setCancelled(true);
        }
    }
}

