/*
 * Decompiled with CFR 0.152.
 */
package org.skills.utils;

import java.util.Arrays;
import java.util.UUID;
import org.apache.commons.lang.math.NumberUtils;

public final class FastUUID {
    private static final boolean USE_JDK_UUID_TO_STRING;
    private static final int UUID_STRING_LENGTH = 36;
    private static final char[] HEX_DIGITS;
    private static final long[] HEX_VALUES;

    public static UUID fromString(CharSequence charSequence) {
        long l = FastUUID.getHexValueForChar(charSequence.charAt(0)) << 60;
        l |= FastUUID.getHexValueForChar(charSequence.charAt(1)) << 56;
        l |= FastUUID.getHexValueForChar(charSequence.charAt(2)) << 52;
        l |= FastUUID.getHexValueForChar(charSequence.charAt(3)) << 48;
        l |= FastUUID.getHexValueForChar(charSequence.charAt(4)) << 44;
        l |= FastUUID.getHexValueForChar(charSequence.charAt(5)) << 40;
        l |= FastUUID.getHexValueForChar(charSequence.charAt(6)) << 36;
        l |= FastUUID.getHexValueForChar(charSequence.charAt(7)) << 32;
        l |= FastUUID.getHexValueForChar(charSequence.charAt(9)) << 28;
        l |= FastUUID.getHexValueForChar(charSequence.charAt(10)) << 24;
        l |= FastUUID.getHexValueForChar(charSequence.charAt(11)) << 20;
        l |= FastUUID.getHexValueForChar(charSequence.charAt(12)) << 16;
        l |= FastUUID.getHexValueForChar(charSequence.charAt(14)) << 12;
        l |= FastUUID.getHexValueForChar(charSequence.charAt(15)) << 8;
        l |= FastUUID.getHexValueForChar(charSequence.charAt(16)) << 4;
        l |= FastUUID.getHexValueForChar(charSequence.charAt(17));
        long l2 = FastUUID.getHexValueForChar(charSequence.charAt(19)) << 60;
        l2 |= FastUUID.getHexValueForChar(charSequence.charAt(20)) << 56;
        l2 |= FastUUID.getHexValueForChar(charSequence.charAt(21)) << 52;
        l2 |= FastUUID.getHexValueForChar(charSequence.charAt(22)) << 48;
        l2 |= FastUUID.getHexValueForChar(charSequence.charAt(24)) << 44;
        l2 |= FastUUID.getHexValueForChar(charSequence.charAt(25)) << 40;
        l2 |= FastUUID.getHexValueForChar(charSequence.charAt(26)) << 36;
        l2 |= FastUUID.getHexValueForChar(charSequence.charAt(27)) << 32;
        l2 |= FastUUID.getHexValueForChar(charSequence.charAt(28)) << 28;
        l2 |= FastUUID.getHexValueForChar(charSequence.charAt(29)) << 24;
        l2 |= FastUUID.getHexValueForChar(charSequence.charAt(30)) << 20;
        l2 |= FastUUID.getHexValueForChar(charSequence.charAt(31)) << 16;
        l2 |= FastUUID.getHexValueForChar(charSequence.charAt(32)) << 12;
        l2 |= FastUUID.getHexValueForChar(charSequence.charAt(33)) << 8;
        l2 |= FastUUID.getHexValueForChar(charSequence.charAt(34)) << 4;
        return new UUID(l, l2 |= FastUUID.getHexValueForChar(charSequence.charAt(35)));
    }

    public static String toString(UUID uUID) {
        if (USE_JDK_UUID_TO_STRING) {
            return uUID.toString();
        }
        long l = uUID.getMostSignificantBits();
        long l2 = uUID.getLeastSignificantBits();
        char[] cArray = new char[]{HEX_DIGITS[(int)((l & 0xF000000000000000L) >>> 60)], HEX_DIGITS[(int)((l & 0xF00000000000000L) >>> 56)], HEX_DIGITS[(int)((l & 0xF0000000000000L) >>> 52)], HEX_DIGITS[(int)((l & 0xF000000000000L) >>> 48)], HEX_DIGITS[(int)((l & 0xF00000000000L) >>> 44)], HEX_DIGITS[(int)((l & 0xF0000000000L) >>> 40)], HEX_DIGITS[(int)((l & 0xF000000000L) >>> 36)], HEX_DIGITS[(int)((l & 0xF00000000L) >>> 32)], '-', HEX_DIGITS[(int)((l & 0xF0000000L) >>> 28)], HEX_DIGITS[(int)((l & 0xF000000L) >>> 24)], HEX_DIGITS[(int)((l & 0xF00000L) >>> 20)], HEX_DIGITS[(int)((l & 0xF0000L) >>> 16)], '-', HEX_DIGITS[(int)((l & 0xF000L) >>> 12)], HEX_DIGITS[(int)((l & 0xF00L) >>> 8)], HEX_DIGITS[(int)((l & 0xF0L) >>> 4)], HEX_DIGITS[(int)(l & 0xFL)], '-', HEX_DIGITS[(int)((l2 & 0xF000000000000000L) >>> 60)], HEX_DIGITS[(int)((l2 & 0xF00000000000000L) >>> 56)], HEX_DIGITS[(int)((l2 & 0xF0000000000000L) >>> 52)], HEX_DIGITS[(int)((l2 & 0xF000000000000L) >>> 48)], '-', HEX_DIGITS[(int)((l2 & 0xF00000000000L) >>> 44)], HEX_DIGITS[(int)((l2 & 0xF0000000000L) >>> 40)], HEX_DIGITS[(int)((l2 & 0xF000000000L) >>> 36)], HEX_DIGITS[(int)((l2 & 0xF00000000L) >>> 32)], HEX_DIGITS[(int)((l2 & 0xF0000000L) >>> 28)], HEX_DIGITS[(int)((l2 & 0xF000000L) >>> 24)], HEX_DIGITS[(int)((l2 & 0xF00000L) >>> 20)], HEX_DIGITS[(int)((l2 & 0xF0000L) >>> 16)], HEX_DIGITS[(int)((l2 & 0xF000L) >>> 12)], HEX_DIGITS[(int)((l2 & 0xF00L) >>> 8)], HEX_DIGITS[(int)((l2 & 0xF0L) >>> 4)], HEX_DIGITS[(int)(l2 & 0xFL)]};
        return new String(cArray);
    }

    private static long getHexValueForChar(char c) {
        try {
            long l = HEX_VALUES[c];
            if (l < 0L) {
                throw new IllegalArgumentException("Illegal hexadecimal digit: " + c);
            }
            return l;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("Illegal hexadecimal digit: " + c);
        }
    }

    static {
        HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        HEX_VALUES = new long[128];
        String string = System.getProperty("java.specification.version");
        int n = NumberUtils.toInt((String)string);
        USE_JDK_UUID_TO_STRING = n >= 14;
        Arrays.fill(HEX_VALUES, -1L);
        FastUUID.HEX_VALUES[48] = 0L;
        FastUUID.HEX_VALUES[49] = 1L;
        FastUUID.HEX_VALUES[50] = 2L;
        FastUUID.HEX_VALUES[51] = 3L;
        FastUUID.HEX_VALUES[52] = 4L;
        FastUUID.HEX_VALUES[53] = 5L;
        FastUUID.HEX_VALUES[54] = 6L;
        FastUUID.HEX_VALUES[55] = 7L;
        FastUUID.HEX_VALUES[56] = 8L;
        FastUUID.HEX_VALUES[57] = 9L;
        FastUUID.HEX_VALUES[97] = 10L;
        FastUUID.HEX_VALUES[98] = 11L;
        FastUUID.HEX_VALUES[99] = 12L;
        FastUUID.HEX_VALUES[100] = 13L;
        FastUUID.HEX_VALUES[101] = 14L;
        FastUUID.HEX_VALUES[102] = 15L;
        FastUUID.HEX_VALUES[65] = 10L;
        FastUUID.HEX_VALUES[66] = 11L;
        FastUUID.HEX_VALUES[67] = 12L;
        FastUUID.HEX_VALUES[68] = 13L;
        FastUUID.HEX_VALUES[69] = 14L;
        FastUUID.HEX_VALUES[70] = 15L;
    }
}

