/*
 * Decompiled with CFR 0.152.
 */
package org.skills.utils;

import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.NPC;
import org.bukkit.entity.Player;
import org.bukkit.entity.Tameable;
import org.bukkit.util.Vector;
import org.skills.services.manager.ServiceHandler;
import org.skills.utils.xseries.XEntityType;

public class EntityUtil {
    private static final double MAX_VELOCITY_CHANGE = 4.0;

    public static boolean isInvalidEntity(Entity entity) {
        EntityType entityType = entity.getType();
        if (entityType == EntityType.ARMOR_STAND || entityType == XEntityType.SNOW_GOLEM.get()) {
            return true;
        }
        if (!(entity instanceof LivingEntity)) {
            return true;
        }
        if (entity instanceof NPC || entity.hasMetadata("NPC")) {
            return true;
        }
        if (entity.isDead() || entity.isInvulnerable()) {
            return true;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            GameMode gameMode = player.getGameMode();
            return gameMode == GameMode.CREATIVE || gameMode == GameMode.SPECTATOR;
        }
        return false;
    }

    public static boolean filterEntity(Player player, Entity entity) {
        return EntityUtil.isInvalidEntity(entity) || !ServiceHandler.canFight((Entity)player, entity) || EntityUtil.isPetOf(player, entity);
    }

    public static boolean isPetOf(Player player, Entity entity) {
        if (!(entity instanceof Tameable)) {
            return false;
        }
        Tameable tameable = (Tameable)entity;
        return player == tameable.getOwner();
    }

    public static void knockBack(Entity entity, Location location, double d) {
        entity.setVelocity(entity.getLocation().toVector().subtract(location.toVector()).multiply(d));
    }

    public static void knockBack(Entity entity, Vector vector, double d) {
        entity.setVelocity(vector.multiply(d));
    }

    public static Vector validateExcessiveVelocity(Vector vector) {
        double d = vector.getX();
        double d2 = vector.getY();
        double d3 = vector.getZ();
        if (d > 4.0) {
            vector.setX(4.0);
        }
        if (d < -4.0) {
            vector.setX(-4.0);
        }
        if (d2 > 4.0) {
            vector.setY(4.0);
        }
        if (d2 < -4.0) {
            vector.setY(-4.0);
        }
        if (d3 > 4.0) {
            vector.setZ(4.0);
        }
        if (d3 < -4.0) {
            vector.setZ(-4.0);
        }
        return vector;
    }
}

