/*
 * Decompiled with CFR 0.152.
 */
package org.skills.utils;

import org.bukkit.Location;
import org.bukkit.entity.Bee;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.skills.utils.Reflect;
import org.skills.utils.xseries.XPotion;

public final class BeeUtils {
    public static final boolean SUPPORTS_BEES = Reflect.classExists("org.bukkit.entity.Bee");

    public static LivingEntity spawn(Location location, LivingEntity livingEntity) {
        Bee bee = (Bee)location.getWorld().spawnEntity(location, EntityType.BEE);
        bee.setCannotEnterHiveTicks(Integer.MAX_VALUE);
        bee.setHive(null);
        bee.setFlower(null);
        bee.setHasNectar(false);
        bee.setHasStung(false);
        bee.setAnger(Integer.MAX_VALUE);
        bee.setTarget(livingEntity);
        bee.addPotionEffect(XPotion.SPEED.buildPotionEffect(1000000, 6));
        return bee;
    }

    public static void setHasStung(Entity entity, boolean bl) {
        ((Bee)entity).setHasStung(bl);
    }

    public static boolean isBee(Entity entity) {
        return SUPPORTS_BEES && entity instanceof Bee;
    }
}

