/*
 * Decompiled with CFR 0.152.
 */
package org.skills.types;

import org.bukkit.configuration.ConfigurationSection;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsPro;
import org.skills.types.Stat;
import org.skills.utils.MathUtils;
import org.skills.utils.StringUtils;

public enum StatType {
    DAMAGE,
    DEFENSE,
    CRITICAL_DAMAGE,
    CRITICAL_CHANCE,
    SPEED;

    private String equation;

    public static void init(SkillsPro skillsPro) {
        ConfigurationSection configurationSection = skillsPro.getConfig().getConfigurationSection("stats.functional-types");
        for (StatType statType : StatType.values()) {
            statType.equation = configurationSection.getString(StringUtils.configOption(statType));
        }
    }

    public void setEquation(String string) {
        this.equation = string;
    }

    public double evaluate(SkilledPlayer skilledPlayer) {
        return MathUtils.evaluateEquation(Stat.replaceStats(skilledPlayer, this.equation));
    }
}

