/*
 * Decompiled with CFR 0.152.
 */
package org.skills.types;

import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsPro;
import org.skills.main.locale.MessageHandler;
import org.skills.types.StatType;

public class Stat {
    public static final Map<String, Stat> STATS = new HashMap<String, Stat>();
    public static Stat POINTS;
    private final String node;
    private final String upperNode;
    private final String name;
    private final String color;
    private final int maxLevel;

    public Stat(String string, String string2, String string3, int n) {
        this.node = string;
        this.upperNode = string.toUpperCase(Locale.ENGLISH);
        this.name = string2;
        this.color = string3;
        this.maxLevel = n;
    }

    public static String replaceStats(SkilledPlayer skilledPlayer, String string) {
        for (Stat stat : STATS.values()) {
            string = MessageHandler.replace(string, stat.node, () -> String.valueOf(skilledPlayer.getStat(stat)));
        }
        return string;
    }

    public static void init(SkillsPro skillsPro) {
        STATS.clear();
        ConfigurationSection configurationSection = skillsPro.getConfig().getConfigurationSection("stats.types");
        for (String string : configurationSection.getKeys(false)) {
            ConfigurationSection configurationSection2 = configurationSection.getConfigurationSection(string);
            string = string.toLowerCase(Locale.ENGLISH);
            Stat stat = new Stat(string, configurationSection2.getString("name"), configurationSection2.getString("color"), configurationSection2.getInt("max-level"));
            if (string.equalsIgnoreCase("pts")) {
                POINTS = stat;
            }
            STATS.put(string, stat);
        }
        StatType.init(skillsPro);
    }

    public static Stat getStat(String string) {
        return Strings.isNullOrEmpty((String)string) ? null : STATS.get(string);
    }

    public static boolean isPoints(String string) {
        return string.equals(Stat.POINTS.upperNode);
    }

    public String getDataNode() {
        return this.upperNode;
    }

    public String getColor() {
        return this.color;
    }

    public String getName() {
        return this.name;
    }

    public String getNode() {
        return this.node;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }
}

