/*
 * Decompiled with CFR 0.152.
 */
package org.skills.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.Validate;
import org.skills.abilities.Ability;
import org.skills.abilities.AbilityManager;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SLogger;
import org.skills.main.locale.MessageHandler;
import org.skills.services.manager.ServiceHandler;
import org.skills.types.Energy;
import org.skills.types.SkillManager;
import org.skills.types.SkillScaling;
import org.skills.types.Stat;
import org.skills.utils.MathUtils;
import org.skills.utils.StringUtils;
import org.skills.utils.YamlAdapter;

public class Skill {
    private final Map<SkillScaling, String> scaling = new EnumMap<SkillScaling, String>(SkillScaling.class);
    private final String name;
    private Map<String, Ability> abilities = new HashMap<String, Ability>();
    private String displayName;
    private Energy energy;
    private List<Stat> stats;
    private YamlAdapter adapter;

    public Skill(String string) {
        this.name = string;
    }

    public void register() {
        Validate.notEmpty((String)this.name, (String)"Skill name cannot be null or empty");
        SkillManager.register(this);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Skill)) {
            return false;
        }
        Skill skill = (Skill)object;
        return this.name.equals(skill.name);
    }

    public boolean isNone() {
        return this.name.equals("none");
    }

    public boolean hasAbility(Ability ability) {
        return this.hasAbility(ability.getName());
    }

    public boolean hasAbility(String string) {
        return this.abilities.containsKey(string);
    }

    public void unregister() {
        SkillManager.unregister(this.name);
    }

    public double getScaling(SkilledPlayer skilledPlayer, SkillScaling skillScaling) {
        String string = this.scaling.get((Object)skillScaling);
        if (string == null) {
            if (skilledPlayer.hasSkill()) {
                throw new NullPointerException("Accessing null scaling: " + (Object)((Object)skillScaling));
            }
            return 0.0;
        }
        String string2 = StringUtils.replace((String)StringUtils.replace((String)ServiceHandler.translatePlaceholders(skilledPlayer.getOfflinePlayer(), string.toLowerCase(Locale.ENGLISH)), (String)"lvl", (String)String.valueOf(skilledPlayer.getLevel())), (String)"bloodwell", (String)String.valueOf(skilledPlayer.getAbilityLevel(AbilityManager.getAbility("blood_well"))));
        for (Stat stat : Stat.STATS.values()) {
            string2 = MessageHandler.replace(string2, '%' + stat.getNode() + '%', () -> String.valueOf(skilledPlayer.getStat(stat)));
        }
        return MathUtils.evaluateEquation(string2);
    }

    public void addScaling(SkillScaling skillScaling, String string) {
        this.scaling.put(skillScaling, string);
    }

    public String getName() {
        return this.name;
    }

    public List<Stat> getStats() {
        return this.stats;
    }

    public void setStats(List<String> list) {
        ArrayList<Stat> arrayList = new ArrayList<Stat>(list.size());
        for (String string : list) {
            Stat stat = Stat.getStat(string.toLowerCase(Locale.ENGLISH));
            if (stat != null) {
                arrayList.add(stat);
                continue;
            }
            SLogger.error("Unknown stat type '" + string + "' in skill: " + string + " (" + this.displayName + ')');
        }
        this.stats = arrayList;
    }

    public Collection<Ability> getAbilities() {
        return this.abilities.values();
    }

    public void setAbilities(Map<String, Ability> map) {
        this.abilities = map;
    }

    public Ability getAbility(String string) {
        return this.abilities.get(string);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    public Energy getEnergy() {
        return this.energy;
    }

    public void setEnergy(Energy energy) {
        this.energy = energy;
    }

    public YamlAdapter getAdapter() {
        return Objects.requireNonNull(this.adapter, () -> "Adapter of skill " + this.name + " is null");
    }

    public void setAdapter(YamlAdapter yamlAdapter) {
        this.adapter = yamlAdapter;
    }
}

