/*
 * Decompiled with CFR 0.152.
 */
package org.skills.types;

import com.google.common.base.Enums;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.configuration.ConfigurationSection;
import org.skills.main.SkillsPro;

public class Energy {
    public static final List<Energy> ENERGY = new ArrayList<Energy>();
    private final String node;
    private final String name;
    private final String symbol;
    private final String color;
    private final String soundNotEnough;
    private final String soundFull;
    private final Set<ChargingMethod> chargingMethods;
    private final List<String> elements;

    public Energy(String string, String string2, String string3, String string4, Set<ChargingMethod> set, String string5, String string6, List<String> list) {
        this.node = string;
        this.name = string2;
        this.symbol = string3;
        this.color = string4;
        this.chargingMethods = set;
        this.elements = list;
        this.soundNotEnough = string5;
        this.soundFull = string6;
    }

    public static Energy getEnergy(String string) {
        if (Strings.isNullOrEmpty((String)string)) {
            return null;
        }
        return ENERGY.stream().filter(energy -> energy.node.equalsIgnoreCase(string)).findFirst().orElse(null);
    }

    public static void init(SkillsPro skillsPro) {
        ENERGY.clear();
        ConfigurationSection configurationSection = skillsPro.getConfig().getConfigurationSection("energy");
        for (String string2 : configurationSection.getKeys(false)) {
            String string3;
            ConfigurationSection configurationSection2 = configurationSection.getConfigurationSection(string2);
            EnumSet<ChargingMethod> enumSet = EnumSet.noneOf(ChargingMethod.class);
            List list = configurationSection2.getStringList("charging");
            if (list != null && !list.isEmpty()) {
                enumSet.addAll(list.stream().map(string -> Enums.getIfPresent(ChargingMethod.class, (String)string)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()));
            } else {
                string3 = configurationSection2.getString("charging");
                string3 = string3 == null ? "AUTO" : string3.toUpperCase(Locale.ENGLISH);
                enumSet.add((ChargingMethod)((Object)Enums.getIfPresent(ChargingMethod.class, (String)string3).or((Object)ChargingMethod.AUTO)));
            }
            string3 = configurationSection2.getString("sounds.full");
            String string4 = configurationSection2.getString("sounds.not-enough");
            Energy energy = new Energy(string2, configurationSection2.getString("name"), configurationSection2.getString("symbol"), configurationSection2.getString("color"), enumSet, string4, string3, configurationSection2.getStringList("elements"));
            ENERGY.add(energy);
        }
    }

    public List<String> getElements() {
        return this.elements;
    }

    public String getColor() {
        return this.color;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public String getName() {
        return this.name;
    }

    public Set<ChargingMethod> getChargingMethods() {
        return this.chargingMethods;
    }

    public boolean hasChargingMethod(ChargingMethod chargingMethod) {
        return this.chargingMethods.contains((Object)chargingMethod);
    }

    public String getSoundNotEnough() {
        return this.soundNotEnough;
    }

    public String getSoundFull() {
        return this.soundFull;
    }

    public static enum ChargingMethod {
        AUTO,
        AUTO_REVERSE,
        KILL,
        HIT,
        EAT,
        PAIN,
        AUTO_NO_DAMAGE,
        REDUCE_ON_DAMAGE;

    }
}

