/*
 * Decompiled with CFR 0.152.
 */
package org.skills.services.placeholders;

import com.google.common.base.Enums;
import java.util.Locale;
import org.bukkit.OfflinePlayer;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.skills.abilities.vergil.VergilPassive;
import org.skills.api.events.CustomHudChangeEvent;
import org.skills.data.managers.Cosmetic;
import org.skills.data.managers.SkilledPlayer;
import org.skills.events.SkillsBonus;
import org.skills.events.SkillsEventManager;
import org.skills.events.SkillsEventType;
import org.skills.main.SkillsConfig;
import org.skills.main.locale.MessageHandler;
import org.skills.main.locale.SkillsLang;
import org.skills.types.SkillScaling;
import org.skills.types.Stat;
import org.skills.utils.MathUtils;
import org.skills.utils.StringUtils;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.NonNull;
import org.skills.utils.versionsupport.VersionSupport;
import org.skills.utils.xseries.XPotion;

public enum SkillsPlaceholders {
    SKILL,
    SKILL_DISPLAYNAME,
    LEVEL,
    SOUL,
    XP,
    MAXXP,
    RAWXP,
    ENERGY,
    PRECISE_ENERGY,
    ENERGY_REGEN,
    MAX_PRECISE_ENERGY,
    MAX_ENERGY,
    ENERGY_TYPE,
    ENERGY_SYMBOL,
    ENERGY_STRING,
    ENERGY_COLOR,
    SKILL_VERGIL_CONCENTRATION_LEVEL,
    HEALTH,
    MAX_HEALTH,
    STATUS,
    ACTIVE_COOLDOWN,
    LAST_ABILITY_COOLDOWN,
    PARTY_NAME,
    PARTY_MEMBERS,
    PARTY_ONLINE_MEMBERS,
    PARTY_OFFLINE_MEMBERS,
    PARTY_RANK,
    LAST_ABILITY,
    SOUL_EVENT_IS_RUNNING,
    SOUL_EVENT_DURATION,
    SOUL_EVENT_MULTIPLIER,
    XP_EVENT_IS_RUNNING,
    XP_EVENT_DURATION,
    XP_EVENT_MULTIPLIER,
    SOUL_BONUS_IS_RUNNING,
    XP_BONUS_IS_RUNNING,
    XP_BONUS_DURATION,
    SOUL_BONUS_DURATION,
    SOUL_BONUS_MULTIPLIER,
    XP_BONUS_MULTIPLIER;

    protected static final String IDENTIFIER = "skills";
    private static final String IDENTIFY = "%skills_";

    public static @NonNull String translatePlaceholders(@NonNull OfflinePlayer offlinePlayer, @NonNull String string) {
        return SkillsPlaceholders.evaluatePlaceholders(SkilledPlayer.getSkilledPlayer(offlinePlayer), string, IDENTIFIER);
    }

    public static String evaluatePlaceholders(SkilledPlayer skilledPlayer, String string, String string2) {
        char c = '%';
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        StringBuilder stringBuilder2 = new StringBuilder(n / 4);
        char[] cArray = string2.toCharArray();
        int n2 = -1;
        for (char c2 : string.toCharArray()) {
            if (c2 == c) {
                if (n2 == -3) {
                    String string3 = stringBuilder2.toString();
                    String string4 = SkillsPlaceholders.onRequest(skilledPlayer, string3);
                    if (string4 == null) {
                        stringBuilder.append((CharSequence)stringBuilder2).append(c2);
                    } else {
                        stringBuilder.append(string4);
                    }
                    n2 = -1;
                    continue;
                }
                if (n2 == -2) {
                    stringBuilder.append(c).append(cArray).append(c);
                }
                stringBuilder2.setLength(0);
                stringBuilder2.append(c2);
                n2 = 0;
                continue;
            }
            if (n2 >= 0) {
                stringBuilder2.append(c2);
                if (c2 == cArray[n2]) {
                    if (n2 + 1 == cArray.length) {
                        n2 = -2;
                        stringBuilder2.setLength(0);
                        continue;
                    }
                    ++n2;
                    continue;
                }
                stringBuilder.append((CharSequence)stringBuilder2);
                n2 = -1;
                continue;
            }
            if (n2 == -2) {
                if (c2 != '_') {
                    stringBuilder.append(c).append(cArray).append(c2);
                    stringBuilder2.setLength(0);
                    n2 = -1;
                    continue;
                }
                n2 = -3;
                continue;
            }
            if (n2 == -3) {
                stringBuilder2.append(c2);
                continue;
            }
            stringBuilder.append(c2);
        }
        if (n2 == 0) {
            stringBuilder.append((CharSequence)stringBuilder2);
        }
        return stringBuilder.toString();
    }

    public static String onRequest(SkilledPlayer skilledPlayer, String string) {
        Object object;
        String string2;
        boolean bl;
        boolean bl2 = string.startsWith("short_");
        boolean bl3 = bl = !bl2 && string.startsWith("fancy_");
        if (bl2 || bl) {
            string = string.substring(6);
        }
        if (string.startsWith("stat_")) {
            string2 = string.substring(5);
            int n = string2.indexOf(95);
            Stat stat = Stat.getStat(n == -1 ? string2 : string2.substring(n + 1));
            if (n == -1) {
                object = skilledPlayer.getStat(stat);
            } else {
                String string3;
                switch (string3 = string2.substring(0, n).toLowerCase(Locale.ENGLISH)) {
                    case "color": {
                        object = stat.getColor();
                        break;
                    }
                    case "maxlvl": {
                        object = stat.getMaxLevel();
                        break;
                    }
                    case "name": {
                        object = stat.getName();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown stat placeholder parameter: '" + string3 + "' in " + string);
                    }
                }
            }
        } else if (string.startsWith("cosmetic_")) {
            String string4;
            Cosmetic cosmetic;
            String string5;
            Cosmetic cosmetic2;
            int n = string.indexOf(95, 10);
            object = n == -1 ? (string.length() == 9 ? null : ((cosmetic2 = skilledPlayer.getCosmetic(string5 = string.substring(9))) != null ? cosmetic2.getName() : null)) : ((cosmetic = skilledPlayer.getCosmetic(string4 = string.substring(9, n))) != null ? ((string = string.substring(n + 1).toLowerCase(Locale.ENGLISH)).equals("displayname") ? cosmetic.getDisplayname() : (string.equals("color") ? cosmetic.getColor() : null)) : null);
        } else {
            string2 = string.toUpperCase(Locale.ENGLISH);
            SkillsPlaceholders skillsPlaceholders = (SkillsPlaceholders)((Object)Enums.getIfPresent(SkillsPlaceholders.class, (String)string2).orNull());
            Object object2 = object = skillsPlaceholders == null ? null : skillsPlaceholders.translate(skilledPlayer);
        }
        if (object != null) {
            if ((bl2 || bl) && object instanceof Number) {
                double d = ((Number)object).doubleValue();
                if (bl2) {
                    return MathUtils.getShortNumber(d);
                }
                return StringUtils.toFancyNumber(d);
            }
            return object.toString();
        }
        return null;
    }

    public static Object translate(@NonNull SkillsPlaceholders skillsPlaceholders, @NonNull SkilledPlayer skilledPlayer) {
        switch (skillsPlaceholders.ordinal()) {
            case 22: {
                return skilledPlayer.hasParty() ? skilledPlayer.getParty().getName() : "";
            }
            case 23: {
                return skilledPlayer.hasParty() ? skilledPlayer.getParty().getMembers().size() : 0;
            }
            case 24: {
                return skilledPlayer.hasParty() ? skilledPlayer.getParty().getOnlineMembers().size() : 0;
            }
            case 25: {
                return skilledPlayer.hasParty() ? skilledPlayer.getParty().getMembers().size() - skilledPlayer.getParty().getOnlineMembers().size() : 0;
            }
            case 26: {
                return skilledPlayer.hasParty() ? skilledPlayer.getRank().toString() : "";
            }
            case 20: {
                int n = (int)Math.ceil(skilledPlayer.getCooldownTimeLeft());
                if (n <= 0) {
                    return SkillsConfig.ACTIONBAR_COOLDOWN_READY.parse(skilledPlayer.getOfflinePlayer(), new Object[0]);
                }
                return SkillsConfig.ACTIONBAR_COOLDOWN_NOT_READY.parse(skilledPlayer.getOfflinePlayer(), "%time%", (int)Math.ceil((double)n / 1000.0));
            }
            case 21: {
                if (skilledPlayer.getLastAbilityUsed() == null) {
                    return 0;
                }
                return (int)skilledPlayer.getLastAbilityUsed().getCooldown(skilledPlayer);
            }
            case 17: {
                Player player = skilledPlayer.getPlayer();
                if (player == null) {
                    return 0;
                }
                int n = SkillsConfig.PRECISIONS_HEALTHS.getInt();
                if (n <= 0) {
                    return (int)player.getHealth();
                }
                return MathUtils.roundToDigits(player.getHealth(), n);
            }
            case 18: {
                Player player = skilledPlayer.getPlayer();
                if (player == null) {
                    return 0;
                }
                int n = SkillsConfig.PRECISIONS_HEALTHS.getInt();
                if (n <= 0) {
                    return (int)VersionSupport.getMaxHealth((LivingEntity)player);
                }
                return MathUtils.roundToDigits(VersionSupport.getMaxHealth((LivingEntity)player), n);
            }
            case 7: {
                Player player = skilledPlayer.getPlayer();
                if (player == null) {
                    return 0;
                }
                int n = SkillsConfig.PRECISIONS_ENERGY.getInt();
                if (n <= 0) {
                    return (int)skilledPlayer.getEnergy();
                }
                return MathUtils.roundToDigits(skilledPlayer.getEnergy(), n);
            }
            case 8: {
                return skilledPlayer.getEnergy();
            }
            case 27: {
                return skilledPlayer.getLastAbilityUsed() != null ? skilledPlayer.getLastAbilityUsed().getName() : "";
            }
            case 10: {
                return skilledPlayer.getScaling(SkillScaling.MAX_ENERGY);
            }
            case 11: {
                Player player = skilledPlayer.getPlayer();
                if (player == null) {
                    return 0;
                }
                int n = SkillsConfig.PRECISIONS_ENERGY.getInt();
                if (n <= 0) {
                    return (int)skilledPlayer.getScaling(SkillScaling.MAX_ENERGY);
                }
                return MathUtils.roundToDigits(skilledPlayer.getScaling(SkillScaling.MAX_ENERGY), n);
            }
            case 9: {
                return skilledPlayer.getScaling(SkillScaling.ENERGY_REGEN);
            }
            case 14: {
                int n = (int)skilledPlayer.getEnergy();
                int n2 = (int)skilledPlayer.getScaling(SkillScaling.MAX_ENERGY);
                StringBuilder stringBuilder = new StringBuilder();
                int n3 = (int)MathUtils.getAmountFromAmount(20.0, n2, n);
                int n4 = 20 - n3;
                if (n3 != 20) {
                    int n5;
                    for (n5 = n3; n5 > 0; --n5) {
                        stringBuilder.append(SkillsConfig.ACTIONBAR_ENERGY_CHARGED.parse(skilledPlayer.getOfflinePlayer(), new Object[0]));
                    }
                    for (n5 = n4; n5 > 0; --n5) {
                        stringBuilder.append(SkillsConfig.ACTIONBAR_ENERGY_EMPTY.parse(skilledPlayer.getOfflinePlayer(), new Object[0]));
                    }
                } else {
                    boolean bl = CustomHudChangeEvent.isAnimated(skilledPlayer.getId());
                    for (int i = 20; i > 0; --i) {
                        if (bl) {
                            stringBuilder.append(SkillsConfig.ACTIONBAR_ENERGY_FULL.parse(skilledPlayer.getOfflinePlayer(), new Object[0]));
                        } else {
                            stringBuilder.append(SkillsConfig.ACTIONBAR_ENERGY_FULL_SECOND.parse(skilledPlayer.getOfflinePlayer(), new Object[0]));
                        }
                        bl = !bl;
                    }
                }
                return stringBuilder.toString();
            }
            case 15: {
                if (!skilledPlayer.hasSkill()) {
                    return "";
                }
                return MessageHandler.colorize(skilledPlayer.getSkill().getEnergy().getColor());
            }
            case 13: {
                if (!skilledPlayer.hasSkill()) {
                    return "";
                }
                return MessageHandler.colorize(skilledPlayer.getSkill().getEnergy().getSymbol());
            }
            case 12: {
                if (!skilledPlayer.hasSkill()) {
                    return "";
                }
                return MessageHandler.colorize(skilledPlayer.getSkill().getEnergy().getName());
            }
            case 2: {
                return skilledPlayer.getLevel();
            }
            case 5: {
                return MathUtils.roundToDigits(skilledPlayer.getLevelXP(), 2);
            }
            case 6: {
                return MathUtils.roundToDigits(skilledPlayer.getRawXP(), 2);
            }
            case 0: {
                return skilledPlayer.getSkillName();
            }
            case 16: {
                BossBar bossBar = VergilPassive.MOTIVATION_LEVELS.get(skilledPlayer.getId());
                if (bossBar == null) {
                    return -1;
                }
                return VergilPassive.getMotivationLevelFromProgress(bossBar.getProgress());
            }
            case 1: {
                return skilledPlayer.getSkill().getDisplayName();
            }
            case 3: {
                return skilledPlayer.getSouls();
            }
            case 19: {
                Player player = skilledPlayer.getPlayer();
                if (player == null || !player.isOnline()) {
                    return "";
                }
                if (player.hasPotionEffect(XPotion.POISON.getPotionEffectType())) {
                    return SkillsConfig.ACTIONBAR_STATUS_POISONED.parse((OfflinePlayer)player, new Object[0]);
                }
                if (player.getHealth() <= 6.0) {
                    return SkillsConfig.ACTIONBAR_STATUS_LOWHEALTH.parse((OfflinePlayer)player, new Object[0]);
                }
                if (skilledPlayer.isActiveReady()) {
                    return SkillsConfig.ACTIONBAR_STATUS_ACTIVATED.parse((OfflinePlayer)player, new Object[0]);
                }
                return SkillsConfig.ACTIONBAR_STATUS_OK.parse((OfflinePlayer)player, new Object[0]);
            }
            case 4: {
                return MathUtils.roundToDigits(skilledPlayer.getXP(), 2);
            }
        }
        return SkillsPlaceholders.translateEvents(skillsPlaceholders, skilledPlayer);
    }

    private static Object translateEvents(@NonNull SkillsPlaceholders skillsPlaceholders, @NonNull SkilledPlayer skilledPlayer) {
        SkillsBonus skillsBonus = null;
        SkillsBonus skillsBonus2 = null;
        SkillsLang skillsLang = null;
        if (skillsPlaceholders.name().contains("EVENT")) {
            if (skillsPlaceholders.name().startsWith("XP_EVENT")) {
                skillsBonus2 = SkillsEventManager.getEvent(SkillsEventType.XP);
            } else if (skillsPlaceholders.name().startsWith("SOUL_EVENT")) {
                skillsBonus = SkillsEventManager.getEvent(SkillsEventType.SOUL);
            }
            if (skillsBonus2 != null || skillsBonus != null) {
                skillsLang = SkillsLang.EVENT_NOT_RUNNING;
            }
        } else if (skillsPlaceholders.name().contains("BONUS")) {
            if (skillsPlaceholders.name().startsWith("XP_BONUS")) {
                skillsBonus2 = skilledPlayer.getBonus(SkillsEventType.XP).stream().findFirst().orElse(null);
            } else if (skillsPlaceholders.name().startsWith("SOUL_BONUS")) {
                skillsBonus = skilledPlayer.getBonus(SkillsEventType.SOUL).stream().findFirst().orElse(null);
            }
            if (skillsBonus2 != null || skillsBonus != null) {
                skillsLang = SkillsLang.BONUS_INACTIVE;
            }
        }
        if (skillsLang == null) {
            return "";
        }
        if (skillsBonus2 == null && skillsBonus == null) {
            return skillsLang.parse(skilledPlayer.getOfflinePlayer());
        }
        switch (skillsPlaceholders.ordinal()) {
            case 28: 
            case 34: {
                return skillsBonus.isActive() ? "&aActive" : skillsLang.parse(skilledPlayer.getOfflinePlayer());
            }
            case 31: 
            case 35: {
                return skillsBonus2.isActive() ? "&aActive" : skillsLang.parse(skilledPlayer.getOfflinePlayer());
            }
            case 29: 
            case 37: {
                return skillsBonus.getDisplayDuration();
            }
            case 32: 
            case 36: {
                return skillsBonus2.getDisplayDuration();
            }
            case 30: 
            case 38: {
                return skillsBonus.getMultiplierFor(skilledPlayer.getOfflinePlayer());
            }
            case 33: 
            case 39: {
                return skillsBonus2.getMultiplierFor(skilledPlayer.getOfflinePlayer());
            }
        }
        return null;
    }

    public Object translate(SkilledPlayer skilledPlayer) {
        return SkillsPlaceholders.translate(this, skilledPlayer);
    }

    public String getPlaceholder() {
        return IDENTIFY + this.name().toLowerCase() + '%';
    }
}

