/*
 * Decompiled with CFR 0.152.
 */
package org.skills.services.manager;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import me.clip.placeholderapi.PlaceholderAPI;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SLogger;
import org.skills.main.SkillsPro;
import org.skills.main.locale.MessageHandler;
import org.skills.services.ServiceCitizens;
import org.skills.services.ServiceDiscordSRV;
import org.skills.services.ServiceFactions;
import org.skills.services.ServiceKingdoms;
import org.skills.services.ServiceMassiveFactions;
import org.skills.services.ServiceMyPet;
import org.skills.services.ServiceResidence;
import org.skills.services.ServiceWorldGuard;
import org.skills.services.mobs.ServiceEliteMobs;
import org.skills.services.mobs.ServiceLevelledMobs;
import org.skills.services.mobs.ServiceLorinthsRpgMobs;
import org.skills.services.mobs.ServiceMythicMobs;
import org.skills.services.placeholders.ServicePlaceholderAPI;
import org.skills.services.placeholders.SkillsPlaceholders;
import org.skills.utils.Pair;
import org.skills.utils.StringUtils;
import org.skills.utils.xseries.XMaterial;

public class ServiceHandler {
    private static final Set<String> PRESENT = new HashSet<String>();
    private static final Map<Plugin, BiFunction<Player, Player, Boolean>> FRIENDLY_HANDLERS = new HashMap<Plugin, BiFunction<Player, Player, Boolean>>();

    public static void init(SkillsPro skillsPro) {
        for (String string : skillsPro.getDescription().getSoftDepend()) {
            Plugin plugin = Bukkit.getPluginManager().getPlugin(string);
            if (plugin != null && plugin.isEnabled()) {
                PRESENT.add(string);
                MessageHandler.sendConsolePluginMessage("&e" + plugin.getName() + " &3found and hooked.");
                continue;
            }
            MessageHandler.sendConsolePluginMessage("&e" + string + " &cnot found.");
        }
    }

    public static boolean isAvailable(String string) {
        return PRESENT.contains(string);
    }

    public static String translatePlaceholders(OfflinePlayer offlinePlayer, String string) {
        Objects.requireNonNull(offlinePlayer, "Cannot translate placeholder for null player");
        Validate.isTrue((string != null ? 1 : 0) != 0, (String)"Cannot translate null string");
        string = StringUtils.replace((String)string, (String)"%player%", (String)offlinePlayer.getName());
        if (offlinePlayer.isOnline()) {
            string = StringUtils.replace((String)string, (String)"%displayname%", (String)((Player)offlinePlayer).getDisplayName());
        }
        return ServiceHandler.isAvailable("PlaceholderAPI") ? PlaceholderAPI.setPlaceholders((OfflinePlayer)offlinePlayer, (String)string) : SkillsPlaceholders.translatePlaceholders(offlinePlayer, string);
    }

    public static boolean isMyPet(Entity entity) {
        return ServiceHandler.isAvailable("MyPet") && ServiceMyPet.isMyPet(entity);
    }

    public static Player getPetOwner(Entity entity) {
        return ServiceMyPet.getPetOwner(entity);
    }

    public static boolean isNPC(Entity entity) {
        return ServiceHandler.isAvailable("Citizens") && ServiceCitizens.isNPC(entity);
    }

    public static boolean areFriendly(Entity entity, Entity entity2) {
        SkilledPlayer skilledPlayer;
        if (entity.getEntityId() == entity2.getEntityId()) {
            return true;
        }
        if (ServiceHandler.isAvailable("Citizens") && (ServiceCitizens.isNPC(entity) || ServiceCitizens.isNPC(entity2))) {
            return true;
        }
        if (!(entity instanceof Player)) {
            return false;
        }
        if (!(entity2 instanceof Player)) {
            return false;
        }
        Player player = (Player)entity;
        Player player2 = (Player)entity2;
        SkilledPlayer skilledPlayer2 = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player);
        if (skilledPlayer2.isFrendly(skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player2))) {
            return true;
        }
        if (Bukkit.getPluginManager().getPlugin("Kingdoms") != null) {
            return !ServiceKingdoms.canFight(player, player2);
        }
        Plugin plugin = Bukkit.getPluginManager().getPlugin("Factions");
        if (plugin != null) {
            try {
                if (Bukkit.getPluginManager().getPlugin("MasiveCore") != null && !plugin.getDescription().getWebsite().contains("factionsuuid") ? !ServiceMassiveFactions.canFight(player, player2) : !ServiceFactions.canFight(player, player2)) {
                    return true;
                }
            }
            catch (Throwable throwable) {
                SLogger.error("Factions support has encountered an error!");
                throwable.printStackTrace();
            }
        }
        for (Map.Entry entry : FRIENDLY_HANDLERS.entrySet()) {
            try {
                Boolean throwable = (Boolean)((BiFunction)entry.getValue()).apply(player, player2);
                if (throwable == null || !throwable.booleanValue()) continue;
                return true;
            }
            catch (Throwable throwable) {
                MessageHandler.sendConsolePluginMessage("&4An error occurred while '&e" + ((Plugin)entry.getKey()).getName() + "&4' plugin was handling friendly checks&8:");
                throwable.printStackTrace();
            }
        }
        return false;
    }

    public static void logPartyChat(Player player, String string) {
        if (ServiceHandler.isAvailable("DiscordSRV")) {
            ServiceDiscordSRV.logPartyChat(player, string);
        }
    }

    public static boolean isKingdomMob(LivingEntity livingEntity) {
        return ServiceHandler.isAvailable("Kingdoms") && ServiceKingdoms.isKingdomMob(livingEntity);
    }

    public static boolean canFight(Entity entity, Entity entity2) {
        if (ServiceHandler.areFriendly(entity, entity2)) {
            return false;
        }
        if (ServiceHandler.isAvailable("Residence")) {
            return ServiceResidence.canFight(entity, entity2);
        }
        if (ServiceHandler.isAvailable("WorldGuard")) {
            try {
                if (XMaterial.supports(13) ? !ServiceWorldGuard.canFight(entity, entity2) : !ServiceWorldGuard.canFightOld(entity, entity2)) {
                    return false;
                }
            }
            catch (Throwable throwable) {
                Plugin plugin = Bukkit.getPluginManager().getPlugin("WorldGuard");
                String string = plugin == null ? "NOT FOUND" : plugin.getDescription().getVersion();
                SLogger.error("WorldGuard support [" + string + "] has encountered an error!");
                throwable.printStackTrace();
            }
        }
        return true;
    }

    public static Pair<String, Number> getMobProperties(LivingEntity livingEntity) {
        Pair<String, Number> pair;
        if (livingEntity.hasMetadata("NPC")) {
            return Pair.of(ServiceCitizens.getNPCName((Entity)livingEntity), 0);
        }
        if (ServiceHandler.isAvailable("LevelledMobs") && (pair = ServiceLevelledMobs.getMobProperties(livingEntity)) != null) {
            return pair;
        }
        if (ServiceHandler.isAvailable("MythicMobs") && (pair = ServiceMythicMobs.getMobProperties(livingEntity)) != null) {
            return pair;
        }
        if (ServiceHandler.isAvailable("EliteMobs") && (pair = ServiceEliteMobs.getMobProperties(livingEntity)) != null) {
            return pair;
        }
        if (ServiceHandler.isAvailable("LorinthsRpgMobs")) {
            return ServiceLorinthsRpgMobs.getMobProperties(livingEntity);
        }
        return null;
    }

    public static boolean isPvPOff(Player player) {
        if (!ServiceHandler.isAvailable("WorldGuard")) {
            return false;
        }
        if (XMaterial.supports(13)) {
            return ServiceWorldGuard.isPvPOff(player);
        }
        return ServiceWorldGuard.isPvPOffOld(player);
    }

    public static boolean isInRegion(Player player, List<String> list) {
        if (list == null || list.isEmpty()) {
            return false;
        }
        if (ServiceHandler.isAvailable("WorldGuard")) {
            return false;
        }
        return ServiceWorldGuard.isInRegion(player, list);
    }

    public static void registerPlaceHolders() {
        if (ServiceHandler.isAvailable("PlaceholderAPI")) {
            boolean bl = new ServicePlaceholderAPI().register();
            if (bl) {
                MessageHandler.sendConsolePluginMessage("&3Successfully registered placeholders.");
            } else {
                MessageHandler.sendConsolePluginMessage("&cCould not register placeholders!");
            }
        }
    }

    public static void registerFriendlyHandler(Plugin plugin, BiFunction<Player, Player, Boolean> biFunction) {
        if (plugin instanceof SkillsPro) {
            throw new IllegalArgumentException("Friendly registrar cannot be SkillsPro plugin");
        }
        Objects.requireNonNull(biFunction, "Friendly handler function cannot be null");
        if (FRIENDLY_HANDLERS.containsKey(plugin)) {
            throw new IllegalArgumentException("Plugin has already registered a friendly handler: " + plugin.getName());
        }
        FRIENDLY_HANDLERS.put(plugin, biFunction);
    }

    public static void unregisterFriendlyHandler(Plugin plugin) {
        Objects.requireNonNull(plugin, "Cannot unregister friendly handler for null plugin");
        if (FRIENDLY_HANDLERS.remove(plugin) == null) {
            throw new IllegalArgumentException("Plugin did not register any friendly handlers: " + plugin.getName());
        }
    }
}

