/*
 * Decompiled with CFR 0.152.
 */
package org.skills.services;

import com.google.common.base.Strings;
import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.api.ListenerPriority;
import github.scarsz.discordsrv.api.Subscribe;
import github.scarsz.discordsrv.api.events.DiscordReadyEvent;
import java.util.List;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.TextChannel;
import org.apache.commons.lang.StringUtils;
import org.bukkit.entity.Player;
import org.skills.main.SkillsConfig;
import org.skills.main.locale.MessageHandler;
import org.skills.services.manager.ServiceHandler;

public class ServiceDiscordSRV {
    private static final ServiceDiscordSRV instance = new ServiceDiscordSRV();
    private static TextChannel partyChannel;

    public static void init() {
        if (!ServiceHandler.isAvailable("DiscordSRV")) {
            return;
        }
        MessageHandler.sendConsolePluginMessage("&2Initiating DiscordSRV support...");
        String string = SkillsConfig.DISCORDSRV_PARTY_CHANNEL.getString();
        if (!Strings.isNullOrEmpty((String)string) && (partyChannel = ServiceDiscordSRV.getChannel(string)) == null) {
            MessageHandler.sendConsolePluginMessage("&cInvalid channel specified &e'" + string + "' &cfor DiscordSRV private channel.");
        }
    }

    public static void subscribe() {
        DiscordSRV.api.subscribe((Object)instance);
    }

    public static void unsubscribe() {
        DiscordSRV.api.unsubscribe((Object)instance);
    }

    public static void logPartyChat(Player player, String string) {
        if (partyChannel == null) {
            return;
        }
        string = StringUtils.replace((String)string, (String)"@", (String)"@\u200b");
        partyChannel.sendMessage((CharSequence)string).queue();
    }

    private static TextChannel getChannel(String string) {
        if (string.equalsIgnoreCase("$console")) {
            return DiscordSRV.getPlugin().getConsoleChannel();
        }
        if (string.equalsIgnoreCase("$main")) {
            return DiscordSRV.getPlugin().getMainTextChannel();
        }
        Guild guild = DiscordSRV.getPlugin().getMainGuild();
        int n = string.length();
        if (n > 15 && n < 20 && org.skills.utils.StringUtils.isPureNumber(string)) {
            return guild.getTextChannelById(Long.parseUnsignedLong(string));
        }
        List list = guild.getTextChannelsByName(string, true);
        return list.isEmpty() ? null : (TextChannel)list.get(0);
    }

    @Subscribe(priority=ListenerPriority.MONITOR)
    public void onBotLoad(DiscordReadyEvent discordReadyEvent) {
        ServiceDiscordSRV.init();
    }
}

