/*
 * Decompiled with CFR 0.152.
 */
package org.skills.party;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.skills.data.managers.DataHandlers;
import org.skills.data.managers.DataManager;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsConfig;
import org.skills.main.SkillsPro;
import org.skills.main.locale.MessageHandler;
import org.skills.party.SkillsParty;
import org.skills.services.manager.ServiceHandler;

public class PartyManager
extends DataManager<SkillsParty>
implements Listener {
    public static final Map<UUID, List<UUID>> INVITES = new HashMap<UUID, List<UUID>>();
    public static final Set<UUID> CHAT = new HashSet<UUID>();
    public static final Set<UUID> SPY = new HashSet<UUID>();

    public PartyManager(SkillsPro skillsPro) {
        super(DataHandlers.getDatabase(skillsPro, "parties", SkillsParty.class));
        this.autoSave(skillsPro);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOW)
    public void onFriendlyFire(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (!(entityDamageByEntityEvent.getDamager() instanceof Player)) {
            return;
        }
        if (!(entityDamageByEntityEvent.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)entityDamageByEntityEvent.getEntity();
        Player player2 = (Player)entityDamageByEntityEvent.getDamager();
        SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player2);
        if (!SkillsConfig.FRIENDS_FRIENDLY_FIRE.getBoolean() && skilledPlayer.getFriends().contains(player.getUniqueId())) {
            entityDamageByEntityEvent.setCancelled(true);
        } else if (!SkillsConfig.PARTY_FRIENDLY_FIRE.getBoolean() && skilledPlayer.hasParty() && skilledPlayer.getParty().getMembers().contains(player.getUniqueId())) {
            entityDamageByEntityEvent.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void partyChat(AsyncPlayerChatEvent asyncPlayerChatEvent) {
        Player player = asyncPlayerChatEvent.getPlayer();
        if (!CHAT.contains(player.getUniqueId())) {
            return;
        }
        SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player);
        if (!skilledPlayer.hasParty()) {
            CHAT.remove(player.getUniqueId());
            return;
        }
        asyncPlayerChatEvent.setCancelled(true);
        String string = MessageHandler.colorize(ServiceHandler.translatePlaceholders((OfflinePlayer)player, SkillsConfig.PARTY_CHAT_FORMAT.getString()) + asyncPlayerChatEvent.getMessage());
        String string2 = MessageHandler.colorize(ServiceHandler.translatePlaceholders((OfflinePlayer)player, SkillsConfig.PARTY_SPY_FORMAT.getString()) + asyncPlayerChatEvent.getMessage());
        ServiceHandler.logPartyChat(player, MessageHandler.stripColors(string, false));
        List<UUID> list = skilledPlayer.getParty().getMembers();
        Bukkit.getConsoleSender().sendMessage(string);
        for (Player player2 : Bukkit.getOnlinePlayers()) {
            if (list.contains(player2.getUniqueId())) {
                player2.sendMessage(string);
                continue;
            }
            if (!SPY.contains(player2.getUniqueId())) continue;
            player2.sendMessage(string2);
        }
    }
}

