/*
 * Decompiled with CFR 0.152.
 */
package org.skills.masteries.managers;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.skills.main.SkillsConfig;
import org.skills.main.SkillsPro;
import org.skills.main.locale.MessageHandler;
import org.skills.masteries.brutality.MasteryFortune;
import org.skills.masteries.brutality.MasteryGlory;
import org.skills.masteries.brutality.MasteryPower;
import org.skills.masteries.brutality.MasteryThickSkin;
import org.skills.masteries.efficiency.MasteryHarvesting;
import org.skills.masteries.efficiency.MasteryLogging;
import org.skills.masteries.efficiency.MasteryMining;
import org.skills.masteries.efficiency.MasteryPacifist;
import org.skills.masteries.efficiency.MasteryRegeneration;
import org.skills.masteries.finesse.MasteryAcrobatics;
import org.skills.masteries.finesse.MasteryPrecision;
import org.skills.masteries.finesse.MasteryReap;
import org.skills.masteries.managers.Mastery;

public class MasteryManager
implements Listener {
    protected static final String PLACED = "PLACED";
    private static final List<Mastery> MASTERIES = new ArrayList<Mastery>();

    public MasteryManager() {
        MessageHandler.sendConsolePluginMessage("&3Setting up masteries...");
        MASTERIES.clear();
        new MasteryLogging();
        new MasteryHarvesting();
        new MasteryMining();
        new MasteryPacifist();
        new MasteryRegeneration();
        new MasteryReap();
        new MasteryPrecision();
        new MasteryAcrobatics();
        new MasteryFortune();
        new MasteryGlory();
        new MasteryPower();
        new MasteryThickSkin();
        MASTERIES.sort(Comparator.comparing(Mastery::getName));
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)SkillsPro.get());
    }

    protected static void registerDefault(Mastery mastery) {
        MASTERIES.add(mastery);
        Bukkit.getPluginManager().registerEvents((Listener)mastery, (Plugin)SkillsPro.get());
    }

    protected static void registerMastery(JavaPlugin javaPlugin, Mastery mastery) {
        MASTERIES.add(mastery);
        Bukkit.getPluginManager().registerEvents((Listener)mastery, (Plugin)javaPlugin);
        MASTERIES.sort(Comparator.comparing(Mastery::getName));
    }

    public static void unregisterMastery(String string) {
        if (!MasteryManager.isMasteryRegistered(string)) {
            return;
        }
        HandlerList.unregisterAll((Listener)MasteryManager.getMastery(string));
        MASTERIES.removeIf(mastery -> mastery.getName().equalsIgnoreCase(string));
    }

    public static List<Mastery> getMasteries() {
        return MASTERIES;
    }

    public static Mastery getMastery(String string) {
        return MASTERIES.stream().filter(mastery -> mastery.getName().equalsIgnoreCase(string)).findFirst().orElse(null);
    }

    public static boolean isMasteryRegistered(String string) {
        return MASTERIES.stream().anyMatch(mastery -> mastery.getName().equalsIgnoreCase(string));
    }

    public boolean isEnabled(Mastery mastery) {
        return SkillsConfig.valueOf("MASTERY_ENABLED_" + mastery.getName()).getBoolean();
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlace(BlockPlaceEvent blockPlaceEvent) {
        blockPlaceEvent.getBlock().setMetadata(PLACED, (MetadataValue)new FixedMetadataValue((Plugin)SkillsPro.get(), null));
    }
}

