/*
 * Decompiled with CFR 0.152.
 */
package org.skills.masteries.brutality;

import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsConfig;
import org.skills.main.locale.MessageHandler;
import org.skills.masteries.managers.Mastery;
import org.skills.utils.MathUtils;
import org.skills.utils.xseries.XItemStack;

public class MasteryFortune
extends Mastery {
    public MasteryFortune() {
        super("Fortune", true);
    }

    @EventHandler
    public void onHarvest(EntityDeathEvent entityDeathEvent) {
        LivingEntity livingEntity = entityDeathEvent.getEntity();
        Player player = livingEntity.getKiller();
        if (player == null) {
            return;
        }
        if (player.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        if (SkillsConfig.isInDisabledWorld(player.getLocation())) {
            return;
        }
        SkilledPlayer skilledPlayer = this.checkup(player);
        if (skilledPlayer == null) {
            return;
        }
        EntityType entityType = livingEntity.getType();
        ConfigurationSection configurationSection = this.getExtra("mobs." + entityType.name()).getSection();
        if (configurationSection == null) {
            return;
        }
        int n = skilledPlayer.getMasteryLevel(this);
        Location location = livingEntity.getLocation();
        World world = player.getWorld();
        for (String string2 : configurationSection.getKeys(false)) {
            ConfigurationSection configurationSection2 = configurationSection.getConfigurationSection(string2);
            if (!MathUtils.hasChance((int)this.getAbsoluteScaling(skilledPlayer, configurationSection2.getString("chance"), new Object[0]))) continue;
            ItemStack itemStack = XItemStack.deserialize(configurationSection2);
            if (itemStack == null) {
                MessageHandler.sendConsolePluginMessage("&4Could not parse Fortune mastery item for option: &e" + configurationSection2.getName() + " &4with properties&8:");
                configurationSection2.getValues(true).forEach((string, object) -> MessageHandler.sendConsolePluginMessage("&6" + string + "&8: &e" + (object instanceof ConfigurationSection ? "" : object)));
                continue;
            }
            int n2 = (int)this.getAbsoluteScaling(skilledPlayer, configurationSection2.getString("amount"), "lvl", n);
            if (n2 > 0) {
                itemStack.setAmount(n2);
            }
            world.dropItemNaturally(location, itemStack);
        }
    }
}

