/*
 * Decompiled with CFR 0.152.
 */
package org.skills.managers.resurrect;

import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.boss.BossBar;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.skills.main.SkillsConfig;
import org.skills.main.SkillsPro;
import org.skills.managers.blood.DamageAestheticsManager;
import org.skills.managers.blood.HeartPulse;
import org.skills.managers.resurrect.LastBreath;
import org.skills.utils.LocationUtils;
import org.skills.utils.StringUtils;
import org.skills.utils.xseries.XSound;
import org.skills.utils.xseries.XWorldBorder;
import org.skills.utils.xseries.reflection.minecraft.MinecraftConnection;

final class LastManStanding {
    protected final float speed;
    protected final GameMode gameMode;
    protected final Player player;
    protected final Object dataWatcher;
    private final BukkitTask invulnerability;
    private final BukkitTask bleedOut;
    private final BukkitTask bossBarUpdate;
    private final BossBar bossBar;
    protected Player reviver;
    protected int progress;
    protected BukkitTask reviveTask;

    public LastManStanding(final Player player) {
        this.player = player;
        this.dataWatcher = LastBreath.registerDataWatcher(player, true);
        this.speed = player.getWalkSpeed();
        this.gameMode = player.getGameMode();
        this.bossBar = this.initBossBar();
        int n = SkillsConfig.LAST_BREATH_INVULNERABILITY.getInt();
        if (n > 0) {
            player.setInvulnerable(true);
            this.invulnerability = new BukkitRunnable(){

                public void run() {
                    player.setInvulnerable(false);
                }
            }.runTaskLater((Plugin)SkillsPro.get(), (long)n * 20L);
        } else {
            this.invulnerability = null;
        }
        final int n2 = SkillsConfig.LAST_BREATH_BLEED_OUT.getInt();
        if (n2 > 0) {
            this.bleedOut = new BukkitRunnable(){

                public void run() {
                    LastManStanding.this.die();
                    XSound.play(SkillsConfig.LAST_BREATH_SOUNDS_BLEED_OUT.getString(), soundPlayer -> soundPlayer.forPlayers(player));
                }
            }.runTaskLater((Plugin)SkillsPro.get(), (long)n2 * 20L);
            this.bossBarUpdate = this.bossBar != null ? new BukkitRunnable(){
                float seconds;
                {
                    this.seconds = n2;
                }

                public void run() {
                    LastManStanding.this.bossBar.setProgress((double)(this.seconds / (float)(n2 + 1)));
                    this.seconds -= 0.05f;
                }
            }.runTaskTimerAsynchronously((Plugin)SkillsPro.get(), 0L, 1L) : null;
        } else {
            this.bleedOut = null;
            this.bossBarUpdate = null;
        }
        this.aesthetics();
        DamageAestheticsManager.MANAGED_PLAYERS.add(player.getUniqueId());
    }

    public BossBar initBossBar() {
        ConfigurationSection configurationSection = SkillsConfig.LAST_BREATH_BOSSBAR.getSection();
        if (!configurationSection.getBoolean("enabled")) {
            return null;
        }
        BossBar bossBar = StringUtils.parseBossBarFromConfig(this.player, configurationSection);
        bossBar.addPlayer(this.player);
        return bossBar;
    }

    public void die() {
        this.player.setHealth(0.0);
        this.resetState();
        LastBreath.LAST_MEN_STANDING.remove(this.player.getEntityId());
    }

    public void aesthetics() {
        this.player.setSwimming(true);
        this.player.setSprinting(true);
        this.player.setGameMode(GameMode.ADVENTURE);
        this.player.setWalkSpeed((float)SkillsConfig.LAST_BREATH_SPEED.getDouble());
        this.player.setFoodLevel(0);
        XSound.play(SkillsConfig.LAST_BREATH_SOUNDS_START.getString(), soundPlayer -> soundPlayer.forPlayers(this.player));
        XSound.play(SkillsConfig.LAST_BREATH_SOUNDS_MUSIC.getString(), soundPlayer -> soundPlayer.forPlayers(this.player));
        Bukkit.getScheduler().runTaskLater((Plugin)SkillsPro.get(), () -> {
            if (SkillsConfig.PULSE_ENABLED.getBoolean()) {
                HeartPulse.pulse(this.player, 0, 0);
            }
            if (SkillsConfig.RED_SCREEN_ENABLED.getBoolean()) {
                DamageAestheticsManager.send(this.player, 0, 0);
            }
        }, 1L);
    }

    public void resetProgress() {
        this.progress = 0;
        this.reviver = null;
        this.player.setFoodLevel(0);
        if (this.reviveTask != null) {
            this.reviveTask.cancel();
        }
    }

    public int progress() {
        return ++this.progress;
    }

    public void revive() {
        XSound.play(SkillsConfig.LAST_BREATH_SOUNDS_REVIVE.getString(), soundPlayer -> soundPlayer.forPlayers(this.player));
        this.resetState();
        this.standWouldYouKindly();
        Location location = this.player.getLocation().add(0.0, 1.0, 0.0);
        this.player.sendBlockChange(location, location.getBlock().getBlockData());
        HeartPulse.remove(this.player);
        XWorldBorder.remove(this.player);
    }

    public void resetState() {
        this.end();
        this.player.setWalkSpeed(this.speed);
        this.player.setGameMode(this.gameMode);
        this.player.setSwimming(false);
        this.player.setSprinting(false);
        this.player.setInvulnerable(false);
        XSound.stopMusic(this.player);
    }

    private void standWouldYouKindly() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)SkillsPro.get(), () -> {
            Object object = LastBreath.registerDataWatcher(this.player, false);
            Location location = this.player.getLocation();
            for (Player player : this.player.getWorld().getPlayers()) {
                if (this.player == player || !(LocationUtils.distanceSquared(location, player.getLocation()) < 100.0)) continue;
                MinecraftConnection.sendPacket(player, object);
            }
        });
    }

    public void end() {
        if (this.invulnerability != null) {
            this.invulnerability.cancel();
        }
        if (this.bleedOut != null) {
            this.bleedOut.cancel();
        }
        if (this.reviveTask != null) {
            this.reviveTask.cancel();
        }
        if (this.bossBar != null) {
            this.bossBar.removeAll();
            this.bossBarUpdate.cancel();
        }
        DamageAestheticsManager.MANAGED_PLAYERS.remove(this.player.getUniqueId());
    }
}

