/*
 * Decompiled with CFR 0.152.
 */
package org.skills.managers.resurrect;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.EntityEffect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityMountEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityToggleGlideEvent;
import org.bukkit.event.entity.EntityToggleSwimEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.event.player.PlayerToggleSprintEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.skills.main.SkillsConfig;
import org.skills.main.SkillsPro;
import org.skills.managers.resurrect.LastManStanding;
import org.skills.utils.Cooldown;
import org.skills.utils.LocationUtils;
import org.skills.utils.MathUtils;
import org.skills.utils.xseries.XMaterial;
import org.skills.utils.xseries.XPotion;
import org.skills.utils.xseries.particles.ParticleDisplay;
import org.skills.utils.xseries.particles.XParticle;
import org.skills.utils.xseries.reflection.XReflection;
import org.skills.utils.xseries.reflection.minecraft.MinecraftConnection;
import org.skills.utils.xseries.reflection.minecraft.NMSExtras;

public final class LastBreath
implements Listener {
    protected static final int VIEW_DISTANCE = 100;
    protected static final int ENTITY_POSE_REGISTRY = 6;
    protected static final Map<Integer, LastManStanding> LAST_MEN_STANDING = new HashMap<Integer, LastManStanding>();
    protected static final Map<Integer, LastManStanding> REVIVERS = new HashMap<Integer, LastManStanding>();
    private static final Object DATA_WATCHER_REGISTRY;
    private static final MethodHandle PACKET_PLAY_OUT_ENTITY_METADATA;
    private static final MethodHandle CREATE_DATA_WATCHER;
    private static final MethodHandle WATCHER_PACK;

    protected static Object registerDataWatcher(Player player, boolean bl) {
        try {
            Object object = NMSExtras.getEntityHandle((Entity)player);
            Object object2 = NMSExtras.getDataWatcher(object);
            Object object3 = CREATE_DATA_WATCHER.invoke(6, DATA_WATCHER_REGISTRY);
            Object object4 = (bl ? NMSExtras.EntityPose.SWIMMING : NMSExtras.EntityPose.STANDING).getEnumValue();
            NMSExtras.setData(object2, object3, object4);
            if (XReflection.supports(19)) {
                return PACKET_PLAY_OUT_ENTITY_METADATA.invoke(player.getEntityId(), WATCHER_PACK.invoke(object2));
            }
            return PACKET_PLAY_OUT_ENTITY_METADATA.invoke(player.getEntityId(), object2, true);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    protected static void cover(Player player, Location location) {
        if (XReflection.supports(13)) {
            player.sendBlockChange(location, Material.BARRIER.createBlockData());
        } else {
            player.sendBlockChange(location, Material.BARRIER, (byte)0);
        }
    }

    private static void cancel(Cancellable cancellable, Entity entity) {
        if (LAST_MEN_STANDING.containsKey(entity.getEntityId())) {
            cancellable.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onSwim(EntityToggleSwimEvent entityToggleSwimEvent) {
        LastBreath.cancel((Cancellable)entityToggleSwimEvent, entityToggleSwimEvent.getEntity());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onStruggle(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        Entity entity = entityDamageByEntityEvent.getDamager();
        if (!(entity instanceof Player)) {
            return;
        }
        if (!LAST_MEN_STANDING.containsKey(entity.getEntityId())) {
            return;
        }
        entityDamageByEntityEvent.setDamage(SkillsConfig.LAST_BREATH_DAMAGE.getDouble());
    }

    public static void totemOfUndying(Player player) {
        player.playEffect(EntityEffect.TOTEM_RESURRECT);
        player.setHealth(player.getHealth() + 1.0);
        player.getActivePotionEffects().forEach(potionEffect -> player.removePotionEffect(potionEffect.getType()));
        player.addPotionEffect(XPotion.REGENERATION.buildPotionEffect(900, 2));
        player.addPotionEffect(XPotion.FIRE_RESISTANCE.buildPotionEffect(800, 1));
        player.addPotionEffect(XPotion.ABSORPTION.buildPotionEffect(100, 1));
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onDeathOrDamage(EntityDamageEvent entityDamageEvent) {
        if (!(entityDamageEvent.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)entityDamageEvent.getEntity();
        LastManStanding lastManStanding = LAST_MEN_STANDING.remove(player.getEntityId());
        if (lastManStanding != null) {
            lastManStanding.resetState();
            return;
        }
        switch (entityDamageEvent.getCause()) {
            case SUICIDE: 
            case SUFFOCATION: 
            case LAVA: 
            case VOID: 
            case DROWNING: 
            case CUSTOM: {
                return;
            }
            case STARVATION: {
                LastBreath.cancel((Cancellable)entityDamageEvent, entityDamageEvent.getEntity());
            }
        }
        double d = player.getHealth() - entityDamageEvent.getFinalDamage();
        if (d > 0.0) {
            return;
        }
        if (XReflection.supports(11)) {
            boolean bl;
            boolean bl2 = XMaterial.matchXMaterial(player.getInventory().getItemInMainHand()) == XMaterial.TOTEM_OF_UNDYING;
            boolean bl3 = bl = XMaterial.matchXMaterial(player.getInventory().getItemInOffHand()) == XMaterial.TOTEM_OF_UNDYING;
            if (bl2 || bl) {
                LastBreath.totemOfUndying(player);
                if (bl2) {
                    player.getInventory().setItemInMainHand(null);
                } else {
                    player.getInventory().setItemInOffHand(null);
                }
                entityDamageEvent.setCancelled(true);
                return;
            }
        }
        if (Cooldown.isInCooldown(player.getUniqueId(), "LASTBREATH")) {
            return;
        }
        if (d > SkillsConfig.LAST_BREATH_INTENSITY_RESISTANCE.getDouble()) {
            return;
        }
        Entity entity = player.getVehicle();
        if (entity != null) {
            entity.eject();
        }
        lastManStanding = new LastManStanding(player);
        LAST_MEN_STANDING.put(player.getEntityId(), lastManStanding);
        entityDamageEvent.setDamage(Math.max(player.getHealth() - 1.0, 0.01));
        LastBreath.cover(player, player.getLocation().add(0.0, 1.0, 0.0));
        new Cooldown(player.getUniqueId(), "LASTBREATH", SkillsConfig.LAST_BREATH_COOLDOWN.getTimeMillis());
    }

    @EventHandler(ignoreCancelled=true)
    public void onSprint(PlayerToggleSprintEvent playerToggleSprintEvent) {
        LastBreath.cancel((Cancellable)playerToggleSprintEvent, (Entity)playerToggleSprintEvent.getPlayer());
    }

    @EventHandler
    public void onLeave(PlayerQuitEvent playerQuitEvent) {
        Player player = playerQuitEvent.getPlayer();
        LastManStanding lastManStanding = LAST_MEN_STANDING.remove(player.getEntityId());
        if (lastManStanding != null) {
            player.setHealth(0.0);
            lastManStanding.resetState();
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onInteract(PlayerInteractEvent playerInteractEvent) {
        LastBreath.cancel((Cancellable)playerInteractEvent, (Entity)playerInteractEvent.getPlayer());
    }

    @EventHandler(ignoreCancelled=true)
    public void onMount(EntityMountEvent entityMountEvent) {
        LastBreath.cancel((Cancellable)entityMountEvent, entityMountEvent.getEntity());
    }

    @EventHandler(ignoreCancelled=true)
    public void onGlide(EntityToggleGlideEvent entityToggleGlideEvent) {
        LastBreath.cancel((Cancellable)entityToggleGlideEvent, entityToggleGlideEvent.getEntity());
    }

    @EventHandler(ignoreCancelled=true)
    public void onTarget(EntityTargetEvent entityTargetEvent) {
        if (entityTargetEvent.getTarget() == null) {
            return;
        }
        if (!LAST_MEN_STANDING.containsKey(entityTargetEvent.getTarget().getEntityId())) {
            return;
        }
        if (!SkillsConfig.LAST_BREATH_MOBS_IGNORE.getBoolean()) {
            return;
        }
        entityTargetEvent.setCancelled(true);
    }

    @EventHandler(ignoreCancelled=true)
    public void onRegenHP(EntityRegainHealthEvent entityRegainHealthEvent) {
        LastBreath.cancel((Cancellable)entityRegainHealthEvent, entityRegainHealthEvent.getEntity());
    }

    @EventHandler(ignoreCancelled=true)
    public void onConsumeFood(PlayerItemConsumeEvent playerItemConsumeEvent) {
        LastBreath.cancel((Cancellable)playerItemConsumeEvent, (Entity)playerItemConsumeEvent.getPlayer());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onSneak(PlayerToggleSneakEvent playerToggleSneakEvent) {
        Player player = playerToggleSneakEvent.getPlayer();
        LastManStanding lastManStanding = LAST_MEN_STANDING.get(player.getEntityId());
        if (lastManStanding != null) {
            lastManStanding.die();
            return;
        }
        if (!playerToggleSneakEvent.isSneaking()) {
            LastManStanding lastManStanding2 = REVIVERS.remove(player.getEntityId());
            if (lastManStanding2 != null) {
                lastManStanding2.resetProgress();
                ParticleDisplay.of(XParticle.LARGE_SMOKE).withLocation(player.getLocation()).withCount(30).offset(0.5).spawn();
            }
            return;
        }
        double d = Double.MAX_VALUE;
        LastManStanding lastManStanding3 = null;
        double d2 = SkillsConfig.LAST_BREATH_REVIVE_DISTANCE.getDouble();
        Location location = player.getLocation();
        for (Entity entity : player.getNearbyEntities(d2, d2, d2)) {
            double d3;
            LastManStanding lastManStanding4;
            if (!(entity instanceof Player) || (lastManStanding4 = LAST_MEN_STANDING.get(entity.getEntityId())) == null || !((d3 = location.distanceSquared(entity.getLocation())) < d)) continue;
            lastManStanding3 = lastManStanding4;
            d = d3;
        }
        if (lastManStanding3 == null) {
            return;
        }
        if (lastManStanding3.reviver != null) {
            return;
        }
        REVIVERS.put(player.getEntityId(), lastManStanding3);
        lastManStanding3.reviver = player;
        ++lastManStanding3.progress;
        Iterator iterator = lastManStanding3;
        lastManStanding3.reviveTask = new BukkitRunnable((LastManStanding)((Object)iterator), player){
            final ParticleDisplay display = ParticleDisplay.of(XParticle.HAPPY_VILLAGER).withCount(20).offset(1.0);
            final int maxProgress = SkillsConfig.LAST_BREATH_REVIVE_TIME.getInt();
            final /* synthetic */ LastManStanding val$finLastMan;
            final /* synthetic */ Player val$player;
            {
                this.val$finLastMan = lastManStanding;
                this.val$player = player;
            }

            public void run() {
                this.display.spawn(this.val$finLastMan.player.getLocation());
                double d = MathUtils.getPercent(this.val$finLastMan.progress(), this.maxProgress);
                this.val$finLastMan.player.setFoodLevel((int)MathUtils.percentOfAmount(d, 20.0));
                if (this.val$finLastMan.progress >= this.maxProgress) {
                    LAST_MEN_STANDING.remove(this.val$finLastMan.player.getEntityId());
                    REVIVERS.remove(this.val$player.getEntityId());
                    this.val$finLastMan.revive();
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)SkillsPro.get(), 0L, 20L);
    }

    public static boolean isLastBreaths(Player player) {
        return LAST_MEN_STANDING.containsKey(player.getEntityId());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onMove(PlayerMoveEvent playerMoveEvent) {
        if (!LocationUtils.hasMovedABlock(playerMoveEvent.getFrom(), playerMoveEvent.getTo())) {
            return;
        }
        Player player = playerMoveEvent.getPlayer();
        if (!LastBreath.isLastBreaths(player)) {
            return;
        }
        Block block = playerMoveEvent.getTo().getBlock();
        Block block2 = block.getRelative(BlockFace.UP);
        if (block2.getType() == Material.AIR || !block2.getType().isSolid()) {
            if (!block.isLiquid() && !block2.isLiquid()) {
                LastBreath.cover(player, block2.getLocation());
            }
            Block block3 = playerMoveEvent.getFrom().getBlock().getRelative(BlockFace.UP);
            player.sendBlockChange(block3.getLocation(), block3.getBlockData());
        }
    }

    static {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        Object object = null;
        MethodHandle methodHandle = null;
        MethodHandle methodHandle2 = null;
        MethodHandle methodHandle3 = null;
        Class<?> clazz = XReflection.getNMSClass("network.syncher", "DataWatcher");
        Class<?> clazz2 = XReflection.getNMSClass("network.syncher", "DataWatcherObject");
        Class<?> clazz3 = XReflection.getNMSClass("network.syncher", "DataWatcherRegistry");
        Class<?> clazz4 = XReflection.getNMSClass("network.syncher", "DataWatcherSerializer");
        Class<?> clazz5 = XReflection.getNMSClass("network.protocol.game", "PacketPlayOutEntityMetadata");
        try {
            object = lookup.findStaticGetter(clazz3, XReflection.v(19, "s").v(13, "p").orElse("n"), clazz4).invoke();
            methodHandle2 = lookup.findConstructor(clazz2, MethodType.methodType(Void.TYPE, Integer.TYPE, clazz4));
            methodHandle = lookup.findConstructor(clazz5, XReflection.v(19, MethodType.methodType(Void.TYPE, Integer.TYPE, List.class)).orElse(MethodType.methodType(Void.TYPE, Integer.TYPE, clazz, Boolean.TYPE)));
            if (XReflection.supports(19)) {
                methodHandle3 = lookup.findVirtual(clazz, "b", MethodType.methodType(List.class));
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        DATA_WATCHER_REGISTRY = object;
        CREATE_DATA_WATCHER = methodHandle2;
        PACKET_PLAY_OUT_ENTITY_METADATA = methodHandle;
        WATCHER_PACK = methodHandle3;
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)SkillsPro.get(), () -> {
            for (LastManStanding lastManStanding : LAST_MEN_STANDING.values()) {
                Location location = lastManStanding.player.getLocation();
                for (Player player : lastManStanding.player.getWorld().getPlayers()) {
                    if (player == lastManStanding.player || !(LocationUtils.distanceSquared(location, player.getLocation()) < 100.0)) continue;
                    MinecraftConnection.sendPacket(player, lastManStanding.dataWatcher);
                }
            }
        }, 100L, 1L);
    }
}

