/*
 * Decompiled with CFR 0.152.
 */
package org.skills.managers.blood;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.skills.main.SkillsConfig;
import org.skills.main.SkillsPro;
import org.skills.main.locale.MessageHandler;
import org.skills.utils.MathUtils;
import org.skills.utils.xseries.XSound;

public class HeartPulse {
    private static final Map<UUID, BukkitTask> PULSE = new HashMap<UUID, BukkitTask>();

    public static void remove(Player player) {
        BukkitTask bukkitTask = PULSE.remove(player.getUniqueId());
        if (bukkitTask != null) {
            bukkitTask.cancel();
        }
    }

    public static CompletableFuture<Void> pulse(Player player, int n) {
        return HeartPulse.pulse(player, n, SkillsConfig.PULSE_DURATION.getInt());
    }

    public static BukkitTask getPulse(Player player) {
        return PULSE.get(player.getUniqueId());
    }

    public static CompletableFuture<Void> pulse(final Player player, int n, final int n2) {
        return CompletableFuture.runAsync(() -> {
            HeartPulse.remove(player);
            final Sound sound = ((XSound)XSound.matchXSound(SkillsConfig.PULSE_DUB.getString()).orElse(null)).parseSound();
            final Sound sound2 = ((XSound)XSound.matchXSound(SkillsConfig.PULSE_LUB.getString()).orElse(null)).parseSound();
            final int n3 = (int)MathUtils.getPercent(n, SkillsConfig.PULSE_HEALTH.getInt());
            final float f = 100 - n3;
            BukkitTask bukkitTask = new BukkitRunnable(){
                static final int beatSpeed = 2;
                final boolean constantPulse;
                float sound;
                final float soundDiv;
                int total;
                int beats;
                int delay;
                boolean start;
                {
                    this.constantPulse = n2 == 0;
                    this.sound = f / 100.0f;
                    this.soundDiv = this.constantPulse ? 0.0f : this.sound / (float)n2;
                    this.total = 0;
                    this.beats = 0;
                    this.delay = n3 / 5;
                    this.start = false;
                }

                public void run() {
                    ++this.total;
                    ++this.beats;
                    this.sound -= this.soundDiv;
                    if (this.start) {
                        if (this.beats >= 2) {
                            player.playSound(player.getLocation(), sound2, this.sound, 0.7f);
                            this.beats = 0;
                            this.start = false;
                        }
                        return;
                    }
                    if (this.beats >= this.delay) {
                        this.start = true;
                        this.beats = 0;
                        ++this.delay;
                        player.playSound(player.getLocation(), sound, this.sound, 0.5f);
                    }
                    if (!this.constantPulse && this.total > n2) {
                        this.cancel();
                    }
                }
            }.runTaskTimerAsynchronously((Plugin)SkillsPro.get(), 0L, 1L);
            PULSE.put(player.getUniqueId(), bukkitTask);
        }).exceptionally(throwable -> {
            MessageHandler.sendConsolePluginMessage("&cAn error occurred while performing heartbeat:");
            throwable.printStackTrace();
            return null;
        });
    }
}

