/*
 * Decompiled with CFR 0.152.
 */
package org.skills.managers.blood;

import java.time.Duration;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.skills.main.SkillsConfig;
import org.skills.managers.blood.HeartPulse;
import org.skills.utils.MathUtils;
import org.skills.utils.versionsupport.VersionSupport;
import org.skills.utils.xseries.XWorldBorder;

public class DamageAestheticsManager
implements Listener {
    public static final Set<UUID> MANAGED_PLAYERS = new HashSet<UUID>();
    private static final double BORDER_SIZE = 1000000.0;

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlayerDamage(EntityDamageEvent entityDamageEvent) {
        if (!(entityDamageEvent.getEntity() instanceof Player)) {
            return;
        }
        if (MANAGED_PLAYERS.contains(entityDamageEvent.getEntity().getUniqueId())) {
            return;
        }
        double d = entityDamageEvent.getFinalDamage();
        if (d <= 0.0) {
            return;
        }
        Player player = (Player)entityDamageEvent.getEntity();
        if (player.getHealth() - d <= 0.0) {
            return;
        }
        int n = VersionSupport.getHealthPercent((LivingEntity)player, entityDamageEvent);
        if (SkillsConfig.PULSE_ENABLED.getBoolean() && n < SkillsConfig.PULSE_HEALTH.getInt()) {
            HeartPulse.pulse(player, n);
        }
        if (SkillsConfig.RED_SCREEN_ENABLED.getBoolean()) {
            DamageAestheticsManager.send(player, SkillsConfig.RED_SCREEN_DURATION.getInt(), n);
        }
    }

    public static void send(Player player, int n, int n2) {
        int n3 = SkillsConfig.RED_SCREEN_HEALTH.getInt();
        if (n2 > n3) {
            return;
        }
        DamageAestheticsManager.send(player, n, n3, n2);
    }

    public static void send(Player player, int n, int n2, int n3) {
        int n4 = (int)MathUtils.getPercent(n3, n2);
        int n5 = (int)MathUtils.percentOfAmount(n4, 4.0E7);
        XWorldBorder xWorldBorder = XWorldBorder.getOrCreate(player);
        xWorldBorder.setWarningDistance(1);
        if (n == 0) {
            xWorldBorder.setSize(n5, Duration.ZERO);
            xWorldBorder.setSizeLerpTarget(n5);
        } else {
            xWorldBorder.setSize(1.0E8, Duration.ofSeconds(n));
            xWorldBorder.setSizeLerpTarget(n5);
        }
        xWorldBorder.send();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onDeath(PlayerDeathEvent playerDeathEvent) {
        Player player = playerDeathEvent.getEntity();
        if (SkillsConfig.RED_SCREEN_ENABLED.getBoolean()) {
            XWorldBorder.remove(player);
        }
        if (SkillsConfig.PULSE_ENABLED.getBoolean()) {
            HeartPulse.remove(player);
        }
    }
}

