/*
 * Decompiled with CFR 0.152.
 */
package org.skills.managers.blood;

import com.google.common.base.Enums;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.skills.main.SkillsConfig;
import org.skills.main.locale.MessageHandler;
import org.skills.utils.xseries.XMaterial;

public final class BloodManager
implements Listener {
    private static void playEffect(LivingEntity livingEntity, String string) {
        String[] stringArray = StringUtils.split((String)StringUtils.deleteWhitespace((String)string), (char)',');
        try {
            Location location = livingEntity.getEyeLocation();
            Effect effect = (Effect)Enums.getIfPresent(Effect.class, (String)stringArray[0]).orNull();
            Material material = XMaterial.matchXMaterial(stringArray[1]).orElseThrow(() -> new IllegalArgumentException("Unable to get blood material: " + stringArray[1])).parseMaterial();
            int n = Integer.parseInt(stringArray[2]);
            livingEntity.getWorld().playEffect(location, effect, (Object)material, n);
        }
        catch (Exception exception) {
            if (exception instanceof NumberFormatException) {
                MessageHandler.sendConsolePluginMessage("&4There was a problem while getting a number for one of the effects in &econfig.yml&8: &e" + exception.getMessage());
            }
            MessageHandler.sendConsolePluginMessage("&4There was a problem while getting an effect or a material type in &econfig.yml&8: &e" + exception.getMessage());
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onBlood(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        Entity entity = entityDamageByEntityEvent.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        if (entity.getType() == EntityType.ARMOR_STAND) {
            return;
        }
        Player player = SkillsConfig.BLOOD_DISABLED_MOBS.getStringList().iterator();
        while (player.hasNext()) {
            String string = player.next();
            try {
                if (entity.getType() != Enums.getIfPresent(EntityType.class, (String)string).orNull()) continue;
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                MessageHandler.sendConsolePluginMessage("&4There was something wrong while attempting to get an &eEntity Type &4from &econfig.yml &4in section &erestricted-entites&8: &e" + indexOutOfBoundsException.getMessage());
            }
        }
        if (entity instanceof Player && (player = (Player)entity).isBlocking() && entityDamageByEntityEvent.getFinalDamage() == 0.0) {
            BloodManager.playEffect((LivingEntity)entity, SkillsConfig.BLOOD_SHIELD.getString());
            return;
        }
        player = SkillsConfig.BLOOD_CUSTOM_MOBS.getSection();
        for (String string : player.getKeys(false)) {
            if (entity.getType() != Enums.getIfPresent(EntityType.class, (String)string).orNull()) continue;
            BloodManager.playEffect((LivingEntity)entity, player.getString(string));
            return;
        }
        BloodManager.playEffect((LivingEntity)entity, SkillsConfig.BLOOD_DEFAULT.getString());
    }
}

